/*
  ================================================
  * TODO soon
  
  check if gmemory_change after page->slide_size change can be commented out or not
  relax the condition of if(page->owner_flag == TRUE && page->valid_num == 1) @ exclude_page_pre()
  free mmapped memory in the end by DMI_malloc()
  
  construct dmi's spis and apis in a stateless-malloc way
  hook mprotect
  munmap in syscall_destroy
  
  ================================================
*/

#include "dmi_system.h"

__thread int32_t _tls_pheap_id = SYS_ID_UNDEF;
__thread int32_t _tls_thread_id = SYS_ID_UNDEF;
int32_t _flag0 = FALSE;
int32_t _flag1 = FALSE;
int32_t _flag2 = FALSE;
int32_t _flag3 = FALSE;
double _t0 = 0;
double _t1 = 0;
double _t2 = 0;
double _t3 = 0;
memory_t *_memory;

void* (*mid_syscall_mmap)(void *start, size_t length, int prot, int flags, int fd, off_t offset);
void* (*true_syscall_mmap)(void *start, size_t length, int prot, int flags, int fd, off_t offset);
void* (*mid_syscall_mremap)(void *old_address, size_t old_size, size_t new_size, int flags);
void* (*true_syscall_mremap)(void *old_address, size_t old_size, size_t new_size, int flags);
int (*mid_syscall_munmap)(void *start, size_t length);
int (*true_syscall_munmap)(void *start, size_t length);
int (*mid_syscall_mprotect)(void *addr, size_t len, int prot);
int (*true_syscall_mprotect)(void *addr, size_t len, int prot);
int (*mid_syscall_brk)(void *end_data_segment);
int (*true_syscall_brk)(void *end_data_segment);

/* spi */

dmi_t* spi_alloc_dmi(uint16_t listen_port, int64_t gmemory_size)
{
  dmi_t *dmi;
  
  dmi = dmi_alloc();
  
  dmi_init(dmi, listen_port, gmemory_size);
  return dmi;
}

void spi_free_dmi(dmi_t *dmi)
{
  gate_t *gate;
  int32_t i, gate_num;
  
  gate_num = xvector_size(dmi->peer_gate_xvector);
  for(i = 0; i < gate_num; i++)
    {
      gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, i);
      gate_free(gate);
    }
  
  gate_num = xvector_size(dmi->vm_gate_xvector);
  for(i = 0; i < gate_num; i++)
    {
      gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, i);
      gate_free(gate);
    }
  
  gate_num = xvector_size(dmi->thread_gate_xvector);
  for(i = 0; i < gate_num; i++)
    {
      gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, i);
      gate_free(gate);
    }
  
  dmi_destroy(dmi);
  
  dmi_free(dmi);
  return;
}

int32_t spi_rank_dmi(dmi_t *dmi, int32_t *dmi_id_ptr)
{
  int32_t ret_value;
  
  ret_value = dmi_rank_dmi(dmi, dmi_id_ptr);
  return ret_value;
}

void spi_join_world(dmi_t *dmi, char *ip, uint16_t port, status_t *status)
{
  dmi_join_world(dmi, ip, port, status);
  return;
}

void spi_leave_world(dmi_t *dmi, status_t *status)
{
  dmi_leave_world(dmi, status);
  return;
}

void spi_create_thread(dmi_t *dmi, dmi_thread_t *dmi_thread_ptr, int32_t dmi_id, int64_t dmi_addr, int64_t stack_size, int8_t pheap_flag, int64_t value1, int64_t value2, int64_t value3, status_t *status)
{
  dmi_create_thread(dmi, dmi_thread_ptr, dmi_id, dmi_addr, stack_size, pheap_flag, value1, value2, value3, status);
  return;
}

void spi_join_thread(dmi_t *dmi, dmi_thread_t dmi_thread, int64_t *dmi_addr_ptr, status_t *status)
{
  dmi_join_thread(dmi, dmi_thread, dmi_addr_ptr, status);
  return;
}

void spi_detach_thread(dmi_t *dmi, dmi_thread_t dmi_thread, status_t *status)
{
  dmi_detach_thread(dmi, dmi_thread, status);
  return;
}

void spi_migrate_thread(dmi_t *dmi, dmi_thread_t dmi_thread, int32_t dmi_id, dmi_thread_t *dmi_thread_ptr, int8_t *migrate_flag_ptr, status_t *status)
{
  dmi_migrate_thread(dmi, dmi_thread, dmi_id, dmi_thread_ptr, migrate_flag_ptr, status);
  return;
}

int32_t spi_isyield_thread(dmi_t *dmi, int8_t *yield_flag_ptr)
{
  int32_t ret;
  
  ret = dmi_isyield_thread(dmi, yield_flag_ptr);
  return ret;
}

int32_t spi_yield_thread(dmi_t *dmi, int8_t *yield_flag_ptr)
{
  int32_t ret;
  
  ret = dmi_yield_thread(dmi, yield_flag_ptr);
  return ret;
}

void spi_wake_thread(dmi_t *dmi, dmi_thread_t dmi_thread, void *out_ptr, int64_t out_size, status_t *status)
{
  dmi_wake_thread(dmi, dmi_thread, out_ptr, out_size, status);
  return;
}

int32_t spi_suspend_thread(dmi_t *dmi, void *in_ptr)
{
  int32_t ret_value;
  
  ret_value = dmi_suspend_thread(dmi, in_ptr);
  return ret_value;
}

int32_t spi_self_thread(dmi_t *dmi, dmi_thread_t *dmi_thread_ptr)
{
  int32_t ret_value;
  
  ret_value = dmi_self_thread(dmi, dmi_thread_ptr);
  return ret_value;
}

void* spi_mmap_tls(dmi_t *dmi, void *start, size_t length, int prot, int flags, int fd, off_t offset)
{
  void *ptr;
  
  ptr = dmi_mmap_tls(dmi, start, length, prot, flags, fd, offset);
  return ptr;
}

void* spi_mremap_tls(dmi_t *dmi, void *old_address, size_t old_size, size_t new_size, int flags)
{
  void *ptr;
  
  ptr = dmi_mremap_tls(dmi, old_address, old_size, new_size, flags);
  return ptr;
}

int32_t spi_mprotect_tls(dmi_t *dmi, void *addr, size_t len, int prot)
{
  int32_t ret;
  
  ret = dmi_mprotect_tls(dmi, addr, len, prot);
  return ret;
}

int32_t spi_munmap_tls(dmi_t *dmi, void *start, size_t length)
{
  int32_t ret;
  
  ret = dmi_munmap_tls(dmi, start, length);
  return ret;
}

void spi_mmap_vms(dmi_t *dmi, int64_t *dmi_addrs, int64_t *page_sizes, int64_t *page_nums, int32_t vm_num, status_t *status)
{
  dmi_mmap_vms(dmi, dmi_addrs, page_sizes, page_nums, vm_num, status);
  return;
}

void spi_munmap_vms(dmi_t *dmi, int64_t *dmi_addrs, int32_t vm_num, status_t *status)
{
  dmi_munmap_vms(dmi, dmi_addrs, vm_num, status);
  return;
}

int32_t spi_init_group(dmi_t *dmi, group_t *group, int64_t *addrs, int64_t *ptr_offsets, int64_t *sizes, int32_t group_num)
{
  int32_t ret_value;
  
  ret_value = dmi_init_group(dmi, group, addrs, ptr_offsets, sizes, group_num);
  return ret_value;
}

int32_t spi_destroy_group(dmi_t *dmi, group_t *group)
{
  int32_t ret_value;
  
  ret_value = dmi_destroy_group(dmi, group);
  return ret_value;
}

void spi_read_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *in_ptr, int8_t access_type, status_t *status)
{
  dmi_read_addr(dmi, dmi_addr, size, in_ptr, access_type, status);
  return;
}

void spi_gread_addr(dmi_t *dmi, group_t *group, void *in_ptr, int8_t access_type, status_t *status)
{
  dmi_gread_addr(dmi, group, in_ptr, access_type, status);
  return;
}

void spi_watch_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *in_ptr, void *out_ptr, status_t *status)
{
  dmi_watch_addr(dmi, dmi_addr, size, in_ptr, out_ptr, status);
  return;
}

void spi_write_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *out_ptr, int8_t access_type, status_t *status)
{
  dmi_write_addr(dmi, dmi_addr, size, out_ptr, access_type, status);
  return;
}

void spi_gwrite_addr(dmi_t *dmi, group_t *group, void *out_ptr, int8_t access_type, status_t *status)
{
  dmi_gwrite_addr(dmi, group, out_ptr, access_type, status);
  return;
}

void spi_atomic_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *out_ptr, int64_t out_size, void *in_ptr, int64_t in_size, int8_t tag, int8_t access_type, status_t *status)
{
  dmi_atomic_addr(dmi, dmi_addr, size, out_ptr, out_size, in_ptr, in_size, tag, access_type, status);
  return;
}

int32_t spi_save_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size)
{
  int32_t ret_value;
  
  ret_value = dmi_decorate_addr(dmi, dmi_addr, size, 1);
  return ret_value;
}

int32_t spi_unsave_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size)
{
  int32_t ret_value;
  
  ret_value = dmi_decorate_addr(dmi, dmi_addr, size, 0);
  return ret_value;
}

void spi_new_object(dmi_t *dmi, int32_t *object_ids, int64_t *slide_sizes, int32_t object_num, status_t *status)
{
  dmi_new_object(dmi, object_ids, slide_sizes, object_num, status);
  return;
}

void spi_delete_object(dmi_t *dmi, int32_t *object_ids, int32_t object_num, status_t *status)
{
  dmi_delete_object(dmi, object_ids, object_num, status);
  return;
}

void spi_read_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *in_ptr, int8_t access_type, status_t *status)
{
  dmi_read_object(dmi, object_id, object_offset, size, in_ptr, access_type, status);
  return;
}

void spi_write_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *out_ptr, int8_t access_type, status_t *status)
{
  dmi_write_object(dmi, object_id, object_offset, size, out_ptr, access_type, status);
  return;
}

void spi_gread_object(dmi_t *dmi, int32_t object_id, int64_t *object_offsets, int64_t *sizes, int64_t *ptr_offsets, int32_t group_num, void *in_ptr, int8_t access_type, status_t *status)
{
  dmi_gread_object(dmi, object_id, object_offsets, sizes, ptr_offsets, group_num, in_ptr, access_type, status);
  return;
}

void spi_gwrite_object(dmi_t *dmi, int32_t object_id, int64_t *object_offsets, int64_t *sizes, int64_t *ptr_offsets, int32_t group_num, void *out_ptr, int8_t access_type, status_t *status)
{
  dmi_gwrite_object(dmi, object_id, object_offsets, sizes, ptr_offsets, group_num, out_ptr, access_type, status);
  return;
}

void spi_atomic_object(dmi_t *dmi, int32_t object_id, void *out_ptr, int64_t out_size, void *in_ptr, int64_t in_size, int8_t tag, int8_t access_type, status_t *status)
{
  dmi_atomic_object(dmi, object_id, out_ptr, out_size, in_ptr, in_size, tag, access_type, status);
  return;
}

void spi_watch_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *in_ptr, void *out_ptr, status_t *status)
{
  dmi_watch_object(dmi, object_id, object_offset, size, in_ptr, out_ptr, status);
  return;
}

void spi_getsize_object(dmi_t *dmi, int32_t object_id, int64_t *slide_size_ptr, int8_t access_type, status_t *status)
{
  dmi_getsize_object(dmi, object_id, slide_size_ptr, access_type, status);
  return;
}

void spi_setsize_object(dmi_t *dmi, int32_t object_id, int64_t slide_size, int8_t access_type, status_t *status)
{
  dmi_setsize_object(dmi, object_id, slide_size, access_type, status);
  return;
}

int32_t spi_save_object(dmi_t *dmi, int32_t object_id)
{
  int32_t ret_value;
  
  ret_value = dmi_decorate_object(dmi, object_id, 1);
  return ret_value;
}

int32_t spi_unsave_object(dmi_t *dmi, int32_t object_id)
{
  int32_t ret_value;
  
  ret_value = dmi_decorate_object(dmi, object_id, 0);
  return ret_value;
}

void spi_start_status(status_t *status)
{
  status_start(status);
  return;
}

int32_t spi_check_status(status_t *status, int32_t *ret_ptr)
{
  int32_t ret_value;
  
  ret_value = status_check(status, ret_ptr);
  return ret_value;
}

void spi_wait_status(status_t *status, int32_t *ret_ptr)
{
  status_wait(status, ret_ptr);
  return;
}

/* init/destroy/rank dmi */

void __attribute__((constructor)) constructor(void)
{
  static memory_t memory;
  static theap_t theap = {0x100000, PTHREAD_MUTEX_INITIALIZER};
  struct timeval tv;
  
  gettimeofday(&tv, NULL);
  mrand_init(tv.tv_usec);
  
  syscall_init();
  
  _memory = &memory;
  _memory->theap = &theap;
  _memory->pheap_xvector = xvector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  _memory->xidpool = xidpool_alloc(CONTAINER_DEFAULT);
  pthread_mutex_init(&_memory->mmap_mutex, NULL);
  
  _tls_thread_id = SYS_MAIN_THREAD_ID;
  return;
}

void __attribute__((destructor)) destructor(void)
{
  _tls_thread_id = SYS_ID_UNDEF;
  
  xidpool_free(_memory->xidpool);
  xvector_free(_memory->pheap_xvector);
  pthread_mutex_destroy(&_memory->mmap_mutex);
  
  syscall_destroy();
  return;
}

#if DEBUG_SWEEP
void* dmi_monitor(void *arg)
{
  dmi_t *dmi;
  
  dmi = (dmi_t*)arg;
  
  while(1)
    {
      halt(0.5);
      if(dmi->dmi_id == 0)
        {
          fprintf(stdout, "global_memory rank=%d size=%lf MB\n", dmi->dmi_id, dmi->gmemory->total_size / 1024.0 / 1024.0);
          fflush(stdout);
        }
    }
  return NULL;
}
#endif

void dmi_init(dmi_t *dmi, uint16_t listen_port, int64_t gmemory_size)
{
  xlease_t *context_xlease;
  
#if DEBUG_SWEEP
  pthread_t monitor_pthread;
  
  pthread_create(&monitor_pthread, NULL, dmi_monitor, dmi);
  pthread_detach(monitor_pthread);
#endif
  
  dmi->contexts_gate = gate_alloc();
  dmi->main_thread = thread_alloc();
  dmi->token = token_alloc();
  dmi->peer_gate_xvector = xvector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  dmi->vm_gate_xvector = xvector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  dmi->thread_gate_xvector = xvector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  dmi->packet_taskque = taskque_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  
  dmi->load = load_alloc();
  
  dmi->gmemory = gmemory_alloc(gmemory_size);
  
  dmi->comm = comm_alloc(listen_port);
  
  context_xlease = xlease_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  dmi->contexts_gate->body = context_xlease;
  
  dmi->main_thread->context = NULL;
  dmi->main_thread->wake_flag = FALSE;
  dmi->main_thread->pthread = pthread_self();
  
  pthread_create(&dmi->recver_pthread, NULL, dmi_recver, dmi);
  pthread_create(&dmi->handler_pthread, NULL, dmi_handler, dmi);
  pthread_create(&dmi->sweeper_pthread, NULL, dmi_sweeper, dmi);
  return;
}

void dmi_destroy(dmi_t *dmi)
{
  xlease_t *context_xlease;
  
  dmi_kill_sweeper(dmi);
  pthread_join(dmi->sweeper_pthread, NULL);
  
  dmi_kill_handler(dmi);
  pthread_join(dmi->handler_pthread, NULL);
  
  dmi_kill_recver(dmi);
  pthread_join(dmi->recver_pthread, NULL);
  
  context_xlease = (xlease_t*)dmi->contexts_gate->body;
  xlease_free(context_xlease);
  
  comm_free(dmi->comm);
  
  gmemory_free(dmi->gmemory);
  
  if(load_size(dmi->load) != 0) error();
  
  load_free(dmi->load);
  
  taskque_free(dmi->packet_taskque);
  xvector_free(dmi->thread_gate_xvector);
  xvector_free(dmi->vm_gate_xvector);
  xvector_free(dmi->peer_gate_xvector);
  token_free(dmi->token);
  thread_free(dmi->main_thread);
  gate_free(dmi->contexts_gate);
  return;
}

int32_t dmi_rank_dmi(dmi_t *dmi, int32_t *dmi_id_ptr)
{
  *dmi_id_ptr = dmi->dmi_id;
  return TRUE;
}

/* create/join/detach/wake/suspend/self thread */

void dmi_create_thread(dmi_t *dmi, dmi_thread_t *dmi_thread_ptr, int32_t dmi_id, int64_t dmi_addr, int64_t stack_size, int8_t pheap_flag, int64_t value1, int64_t value2, int64_t value3, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_CREATE_THREAD;
  context_dmi_thread_ptr(new_context) = dmi_thread_ptr;
  context_dmi_id(new_context) = dmi_id;
  context_dmi_addr(new_context) = dmi_addr;
  if(stack_size <= 0)
    {
      context_stack_size(new_context) = CONST_DEFAULT_STACK_SIZE;
    }
  else
    {
      context_stack_size(new_context) = stack_size;
    }
  context_pheap_flag(new_context) = pheap_flag;
  context_value1(new_context) = value1;
  context_value2(new_context) = value2;
  context_value3(new_context) = value3;
  
  context_create_thread_pre(new_context);
  return;
}

void context_create_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  int32_t ret;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_id(context));
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_CREATE_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_id(context);
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_dmi_addr(send_packet) = context_dmi_addr(context);
  packet_stack_size(send_packet) = context_stack_size(context);
  packet_pheap_flag(send_packet) = context_pheap_flag(context);
  packet_value1(send_packet) = context_value1(context);
  packet_value2(send_packet) = context_value2(context);
  packet_value3(send_packet) = context_value3(context);
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_create_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *new_context;
  thread_t *thread;
  pheap_t *pheap;
  gate_t *thread_gate;
  int32_t thread_id, thread_num, pheap_id, ret;
  int64_t addr, uoffset, usize;
  
  pheap = pheap_alloc();
  
  pheap->stack_size = packet_stack_size(recv_packet);
  do
    {
      if(packet_pheap_flag(recv_packet) == TRUE)
        {
          addr = (int64_t)(mrand_01() * CONST_THEAP_SEGMENT_SIZE);
        }
      else
        {
          addr = (int64_t)(mrand_01() * CONST_PHEAP_SEGMENT_SIZE) + CONST_THEAP_SEGMENT_SIZE;
        }
      addr = SYS_PAGESIZE_ALIGN_CEIL(addr);
      pheap->stack_ptr = (void*)addr;
      
      pheap->stack_ptr = fixed_mmap(pheap->stack_ptr, pheap->stack_size, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS);
    }
  while(pheap->stack_ptr == MAP_FAILED);
#if DEBUG_THREAD
  fprintf(stderr, "stack_ptr = %p, stack_size = %ld\n", pheap->stack_ptr, pheap->stack_size);
#endif
  
  uoffset = 0;
  usize = sizeof(ucontext_t);
  pheap->uc_child_ptr = (ucontext_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  usize = sizeof(ucontext_t);
  pheap->uc_parent_ptr = (ucontext_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  usize = sizeof(int64_t);
  pheap->dmi_addr_ptr = (int64_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  
  ret = getcontext(pheap->uc_child_ptr);
  if(ret < 0) error();
  pheap->uc_child_ptr->uc_stack.ss_sp = pheap->stack_ptr;
  pheap->uc_child_ptr->uc_stack.ss_size = pheap->stack_size;
  pheap->uc_child_ptr->uc_link = NULL;
  pheap->dmi_addr = packet_dmi_addr(recv_packet);
  pheap->value1 = packet_value1(recv_packet);
  pheap->value2 = packet_value2(recv_packet);
  pheap->value3 = packet_value3(recv_packet);
  
  makecontext(pheap->uc_child_ptr, (void (*)())dmi_call_thread, 2
              , (int32_t)((int64_t)dmi >> 32ULL)
              , (int32_t)((int64_t)dmi & 0xffffffffULL));
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_MASTER);
  if(new_context == NULL)
    {
      /* clear allocated memory for pheap */
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_CREATE_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  new_context->type = CONTEXT_RUN_THREAD;
  context_state(new_context) = STATE_CREATE;
  context_yield_flag(new_context) = FALSE;
  context_migration_flag(new_context) = FALSE;
  
  pheap_id = xidpool_get(_memory->xidpool);
  xvector_assign(_memory->pheap_xvector, pheap_id, pheap);
  context_pheap_id(new_context) = pheap_id;
  
  thread_gate = NULL;
  thread_num = xvector_size(dmi->thread_gate_xvector);
  for(thread_id = 0; thread_id < thread_num; thread_id++)
    {
      thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
      if(thread_gate->state == STATE_FORBID)
        {
          break;
        }
    }
  if(thread_id == thread_num)
    {
      thread_gate = gate_alloc();
      xvector_push(dmi->thread_gate_xvector, thread_gate);
    }
  context_thread_id(new_context) = thread_id;
  
  thread = thread_alloc();
  thread->wake_flag = FALSE;
  thread->context = new_context;
  
  thread_gate->body = thread;
  
  gate_permit(thread_gate);
  
  ret = gate_enter(thread_gate);
  if(ret == FALSE) error();
  
  pthread_create(&thread->pthread, NULL, context_switcher, new_context);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_CREATE_THREAD;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_thread_id(send_packet) = context_thread_id(new_context);
  packet_ret_flag(send_packet) = TRUE;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_call_thread(int32_t reg1, int32_t reg2)
{
  dmi_t *dmi;
  context_t *context;
  thread_t *thread;
  pheap_t *pheap;
  gate_t *thread_gate;
  ucontext_t *uc_child_ptr, *uc_parent_ptr;
  int32_t thread_id;
  int64_t value1, value2, value3;
  int64_t dmi_addr;
  int64_t *dmi_addr_ptr;
  
  dmi = (dmi_t*)(((int64_t)reg1 << 32ULL) | (reg2 & 0xffffffffULL));
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      error();
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, context_pheap_id(context));
  
  dmi_addr = pheap->dmi_addr;
  value1 = pheap->value1;
  value2 = pheap->value2;
  value3 = pheap->value3;
  uc_child_ptr = pheap->uc_child_ptr;
  uc_parent_ptr = pheap->uc_parent_ptr;
  dmi_addr_ptr = pheap->dmi_addr_ptr;
  
  *dmi_addr_ptr = dmi_thread(dmi_addr, value1, value2, value3);
  
#if DEBUG_THREAD
  print_str("before call swapcontext\n");
#endif
  swapcontext(uc_child_ptr, uc_parent_ptr);
#if DEBUG_THREAD
  print_str("after call swapcontext\n");
#endif
  return;
}

void* context_switcher(void *arg)
{
  packet_t *send_packet;
  context_t *context;
  pheap_t *pheap;
  struct timeval tv;
  int32_t ret;
  
  context = (context_t*)arg;
  
  gettimeofday(&tv, NULL);
  mrand_init(tv.tv_usec);
  
  pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, context_pheap_id(context));
  
  while(1)
    {
      context_yield_flag(context) = FALSE;
      
      _tls_thread_id = context_thread_id(context);
      
#if DEBUG_THREAD
      print_str("before switcher swapcontext\n");
#endif
      ret = swapcontext(pheap->uc_parent_ptr, pheap->uc_child_ptr);
      if(ret < 0) error();
#if DEBUG_THREAD
      print_str("after switcher swapcontext\n");
#endif
      
      _tls_thread_id = SYS_ID_UNDEF;
      
      if(context_yield_flag(context) == TRUE)
        {
          context_ret_flag(context) = UNDEF;
          
          context_yield_thread_pre(context);
          pthread_mutex_lock(&context->mutex);
          
          while(context_ret_flag(context) == UNDEF)
            {
              pthread_cond_wait(&context->cond, &context->mutex);
            }
          
          pthread_mutex_unlock(&context->mutex);
          
          if(context_ret_flag(context) == TRUE)
            {
              pthread_mutex_lock(&context->mutex);
              
              send_packet = packet_alloc();
              send_packet->type = PACKET_ACK_MIGRATE_THREAD;
              send_packet->src_dmi_id = context->dmi->dmi_id;
              send_packet->context_id = context_parent_dmi_context(context).context_id;
              send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
              send_packet->page_payload_size = 0;
              send_packet->data_payload_size = 0;
              packet_thread_id(send_packet) = context_new_thread_id(context);
              packet_migrate_flag(send_packet) = TRUE;
              packet_ret_flag(send_packet) = TRUE;
              dmi_send_packet(context->dmi, send_packet);
              packet_free(send_packet);
              
              context_migration_flag(context) = FALSE;
              
              switch(context_state(context))
                {
                case STATE_CREATE:
                case STATE_JOIN:
                case STATE_DETACH:
                  context_state(context) = STATE_EXIT;
                  break;
                case STATE_EXIT:
                  error();
                  break;
                default:
                  error();
                }
              
              pthread_mutex_unlock(&context->mutex);
              
              context_close_thread_pre(context);
              break;
            }
          else
            {
              pthread_mutex_lock(&context->mutex);
              
              send_packet = packet_alloc();
              send_packet->type = PACKET_ACK_MIGRATE_THREAD;
              send_packet->src_dmi_id = context->dmi->dmi_id;
              send_packet->context_id = context_parent_dmi_context(context).context_id;
              send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
              send_packet->page_payload_size = 0;
              send_packet->data_payload_size = 0;
              packet_thread_id(send_packet) = context_new_thread_id(context);
              packet_migrate_flag(send_packet) = FALSE;
              packet_ret_flag(send_packet) = TRUE;
              dmi_send_packet(context->dmi, send_packet);
              packet_free(send_packet);
              
              context_migration_flag(context) = FALSE;
              
              pthread_mutex_unlock(&context->mutex);
            }
        }
      else
        {
          pthread_mutex_lock(&context->mutex);
          
          context_dmi_addr(context) = *pheap->dmi_addr_ptr;
          
          if(context_migration_flag(context) == TRUE)
            {
              send_packet = packet_alloc();
              send_packet->type = PACKET_ACK_MIGRATE_THREAD;
              send_packet->src_dmi_id = context->dmi->dmi_id;
              send_packet->context_id = context_parent_dmi_context(context).context_id;
              send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
              send_packet->page_payload_size = 0;
              send_packet->data_payload_size = 0;
              packet_ret_flag(send_packet) = FALSE;
              dmi_send_packet(context->dmi, send_packet);
              packet_free(send_packet);
              
              context_migration_flag(context) = FALSE;
            }
          
          switch(context_state(context))
            {
            case STATE_CREATE:
              context_state(context) = STATE_EXIT;
              
              pthread_mutex_unlock(&context->mutex);
              break;
            case STATE_EXIT:
              error();
              break;
            case STATE_JOIN:
            case STATE_DETACH:
              pthread_mutex_unlock(&context->mutex);
              
              context_close_thread_pre(context);
              break;
            default:
              error();
            }
          break;
        }
    }
  return NULL;
}

int32_t dmi_isyield_thread(dmi_t *dmi, int8_t *yield_flag_ptr)
{
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t thread_id;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return FALSE;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
    
  pthread_mutex_lock(&context->mutex);
  
  if(context_migration_flag(context) == TRUE)
    {
      *yield_flag_ptr = TRUE;
    }
  else
    {
      *yield_flag_ptr = FALSE;
    }
  
  pthread_mutex_unlock(&context->mutex);
  return TRUE;
}

int32_t dmi_yield_thread(dmi_t *dmi, int8_t *yield_flag_ptr)
{
#if !DEBUG_MIGRATION
  return FALSE;
#else
  context_t *context;
  thread_t *thread;
  pheap_t *pheap;
  gate_t *thread_gate;
  ucontext_t *uc_child_ptr, *uc_parent_ptr;
  int32_t thread_id, ret;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return FALSE;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
    
  pthread_mutex_lock(&context->mutex);
  
  if(context_migration_flag(context) == TRUE)
    {
      *yield_flag_ptr = TRUE;
      
      pthread_mutex_unlock(&context->mutex);
      
      context_yield_flag(context) = TRUE;
      
      pheap = xvector_at(_memory->pheap_xvector, context_pheap_id(context));
      
      uc_child_ptr = pheap->uc_child_ptr;
      uc_parent_ptr = pheap->uc_parent_ptr;
      
#if DEBUG_THREAD
      print_str("before yield swapcontext\n");
#endif
      ret = swapcontext(uc_child_ptr, uc_parent_ptr);
      if(ret < 0) error();
#if DEBUG_THREAD
      print_str("after yield swapcontext\n");
#endif
    }
  else
    {
      *yield_flag_ptr = FALSE;
      
      pthread_mutex_unlock(&context->mutex);
    }
  return TRUE;
#endif
}

void context_yield_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  pheap_t *pheap;
  mblock_t *mblock;
  mmapped_t *mmapped;
  writebuf_t *writebuf;
  int8_t *buf;
  int32_t ret, mblock_num, mmapped_num;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_id(context));
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      pthread_mutex_lock(&context->mutex);
      
      context_ret_flag(context) = FALSE;
      context_new_thread_id(context) = SYS_ID_UNDEF;
      pthread_cond_broadcast(&context->cond);
      
      pthread_mutex_unlock(&context->mutex);
      return;
    }
  
#if DEBUG_THREAD
  fprintf(stderr, "sending thread image from %d to %d\n", context->dmi->dmi_id, context_dmi_id(context));
#endif
  pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, context_pheap_id(context));
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
#if DEBUG_THREAD
  fprintf(stderr, "[send] stack_ptr=%p, stack_size=%ld\n", pheap->stack_ptr, pheap->stack_size);
#endif
  writebuf_copy(writebuf, &pheap->stack_ptr, sizeof(intptr_t));
  writebuf_copy(writebuf, &pheap->stack_size, sizeof(int64_t));
  
  writebuf_copy(writebuf, pheap->stack_ptr, pheap->stack_size);
  
  writebuf_copy(writebuf, pheap->uc_child_ptr, sizeof(ucontext_t));
  
  mblock_num = list_size(pheap->mblock_list);
#if DEBUG_THREAD
  fprintf(stderr, "[send] mblock_num=%d\n", mblock_num);
#endif
  writebuf_copy(writebuf, &mblock_num, sizeof(int32_t));
  
  list_head(pheap->mblock_list);
  while(list_hasnext(pheap->mblock_list))
    {
      mblock = (mblock_t*)list_next(pheap->mblock_list);
      
#if DEBUG_THREAD
      fprintf(stderr, "[send] mblock_start_ptr=%p, mblock_size=%ld\n", mblock->start_ptr, mblock->size);
#endif
      writebuf_copy(writebuf, &mblock->start_ptr, sizeof(intptr_t));
      writebuf_copy(writebuf, &mblock->size, sizeof(int64_t));
    }
  
  mmapped_num = list_size(pheap->mmapped_list);
#if DEBUG_THREAD
  fprintf(stderr, "[send] mmapped_num=%d\n", mmapped_num);
#endif
  writebuf_copy(writebuf, &mmapped_num, sizeof(int32_t));
  
  list_head(pheap->mmapped_list);
  while(list_hasnext(pheap->mmapped_list))
    {
      mmapped = (mmapped_t*)list_next(pheap->mmapped_list);
      
#if DEBUG_THREAD
      fprintf(stderr, "[send] mmapped_start_ptr=%p, mmapped_size=%ld\n", mmapped->start_ptr, mmapped->size);
#endif
      writebuf_copy(writebuf, &mmapped->start_ptr, sizeof(intptr_t));
      writebuf_copy(writebuf, &mmapped->size, sizeof(int64_t));
      writebuf_copy(writebuf, &mmapped->prot, sizeof(int32_t));
      writebuf_copy(writebuf, &mmapped->flags, sizeof(int32_t));
      writebuf_copy(writebuf, mmapped->start_ptr, mmapped->size);
    }
  
#if DEBUG_THREAD
  fprintf(stderr, "[send] total_size=%ld\n", writebuf_size(writebuf));
#endif
  
  buf = (int8_t*)my_malloc(SYS_MRAND_BUF_SIZE);
  mrand_snapshot(buf);
  writebuf_copy(writebuf, buf, SYS_MRAND_BUF_SIZE);
  my_free(buf);
  
  buf = (int8_t*)my_malloc(SYS_TIME_BUF_SIZE);
  time_snapshot(buf);
  writebuf_copy(writebuf, buf, SYS_TIME_BUF_SIZE);
  my_free(buf);
  
  pthread_mutex_lock(&context->mutex);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_YIELD_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_id(context);
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_state(send_packet) = context_state(context);
  packet_context_id(send_packet) = context_join_dmi_context(context).context_id;
  packet_dmi_id(send_packet) = context_join_dmi_context(context).dmi_id;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
#if DEBUG_BASIC
  fprintf(stderr, "sending size=%lf MB\n", writebuf_size(writebuf) / 1024.0 / 1024.0);
#endif
  
  pthread_mutex_unlock(&context->mutex);
  
  writebuf_free(writebuf);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_yield_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *new_context;
  thread_t *thread;
  pheap_t *pheap;
  mblock_t *mblock;
  mmapped_t *mmapped;
  gate_t *thread_gate;
  readbuf_t *readbuf;
  int8_t *buf;
  int32_t thread_id, pheap_id, thread_num, mblock_num, mmapped_num, ret, i, j;
  int64_t uoffset, usize;
  
#if DEBUG_THREAD
  fprintf(stderr, "recving thread image from %d to %d\n", recv_packet->src_dmi_id, dmi->dmi_id);
#endif
  pheap = pheap_alloc();
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  
  readbuf_copy(readbuf, &pheap->stack_ptr, sizeof(intptr_t));
  readbuf_copy(readbuf, &pheap->stack_size, sizeof(int64_t));
#if DEBUG_THREAD
  fprintf(stderr, "[recv] stack_ptr=%p, stack_size=%ld\n", pheap->stack_ptr, pheap->stack_size);
#endif
  
  pheap->stack_ptr = fixed_mmap(pheap->stack_ptr, pheap->stack_size, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS);
  if(pheap->stack_ptr == MAP_FAILED)
    {
#if DEBUG_TEMPORAL
      {
        outn("============= test memory map ================");
        outn("[stack] stack_ptr=%p, stack_size=%ld", pheap->stack_ptr, pheap->stack_size);
        int block = 4096;
        int num = CONST_PHEAP_SEGMENT_SIZE / block;
        int i;
        int count = 0;
        for(i = 0; i < num; i++)
          {
            int64_t addr = CONST_THEAP_SEGMENT_SIZE + i * block;
            void *ptr = fixed_mmap((void*)(intptr_t)addr, block, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS);
            if(ptr == MAP_FAILED)
              {
                count++;
                out("<%lx>", addr);
              }
            else
              {
                out("[%lx]", addr);
              }
          }
        outn("count = %d, %d", count, (int)log2(count * 4096));
      }
#endif
      
      readbuf_free(readbuf);
      
      pheap_free(pheap);
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_YIELD_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
#if DEBUG_THREAD
  fprintf(stderr, "re-mmap stackaddr on %p\n", pheap->stack_ptr);
#endif
  
  readbuf_copy(readbuf, pheap->stack_ptr, pheap->stack_size);
  
  uoffset = 0;
  usize = sizeof(ucontext_t);
  pheap->uc_child_ptr = (ucontext_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  usize = sizeof(ucontext_t);
  pheap->uc_parent_ptr = (ucontext_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  usize = sizeof(int64_t);
  pheap->dmi_addr_ptr = (int64_t*)((char*)pheap->stack_ptr + uoffset);
  uoffset += usize;
  
  readbuf_copy(readbuf, pheap->uc_child_ptr, sizeof(ucontext_t));
  
  readbuf_copy(readbuf, &mblock_num, sizeof(int32_t));
#if DEBUG_THREAD
  fprintf(stderr, "[recv] mblock_num=%d\n", mblock_num);
#endif
  for(i = 0; i < mblock_num; i++)
    {
      mblock = mblock_alloc();
      
      readbuf_copy(readbuf, &mblock->start_ptr, sizeof(intptr_t));
      readbuf_copy(readbuf, &mblock->size, sizeof(int64_t));
#if DEBUG_THREAD
      fprintf(stderr, "[recv] mblock_start_ptr=%p, mblock_size=%ld\n", mblock->start_ptr, mblock->size);
#endif
      
      list_push(pheap->mblock_list, mblock);
    }
  
  readbuf_copy(readbuf, &mmapped_num, sizeof(int32_t));
#if DEBUG_THREAD
  fprintf(stderr, "[recv] mmapped_num=%d\n", mmapped_num);
#endif
  for(i = 0; i < mmapped_num; i++)
    {
      mmapped = mmapped_alloc();
      
      readbuf_copy(readbuf, &mmapped->start_ptr, sizeof(intptr_t));
      readbuf_copy(readbuf, &mmapped->size, sizeof(int64_t));
      readbuf_copy(readbuf, &mmapped->prot, sizeof(int32_t));
      readbuf_copy(readbuf, &mmapped->flags, sizeof(int32_t));
#if DEBUG_THREAD
      fprintf(stderr, "[recv] mmapped_start_ptr=%p, mmapped_size=%ld\n", mmapped->start_ptr, mmapped->size);
#endif
      mmapped->start_ptr = fixed_mmap(mmapped->start_ptr, mmapped->size, mmapped->prot, mmapped->flags);
      if(mmapped->start_ptr == MAP_FAILED)
        {
          mmapped = (mmapped_t*)list_pop(pheap->mmapped_list);
          
          mmapped_free(mmapped);
          
          for(j = 0; j < i; j++)
            {
              mmapped = (mmapped_t*)list_pop(pheap->mmapped_list);
              
              ret = true_syscall_munmap(mmapped->start_ptr, mmapped->size);
              if(ret < 0) error();
              
              mmapped_free(mmapped);
            }
          
          for(j = 0; j < mblock_num; j++)
            {
              mblock = (mblock_t*)list_pop(pheap->mblock_list);
              
              mblock_free(mblock);
            }
          
          ret = true_syscall_munmap(pheap->stack_ptr, pheap->stack_size);
          if(ret < 0) error();
          
          readbuf_free(readbuf);
          
          pheap_free(pheap);
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_CREATE_THREAD;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          packet_ret_flag(send_packet) = FALSE;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          return;
        }
      
      readbuf_copy(readbuf, mmapped->start_ptr, mmapped->size);
      
      list_push(pheap->mmapped_list, mmapped);
    }
  
  buf = (int8_t*)my_malloc(SYS_MRAND_BUF_SIZE);
  readbuf_copy(readbuf, buf, SYS_MRAND_BUF_SIZE);
  mrand_resume(buf);
  my_free(buf);
  
  buf = (int8_t*)my_malloc(SYS_TIME_BUF_SIZE);
  readbuf_copy(readbuf, buf, SYS_TIME_BUF_SIZE);
  time_resume(buf);
  my_free(buf);
  
  readbuf_free(readbuf);
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_MASTER);
  if(new_context == NULL)
    {
      /* clear allocated memory for pheap */
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_CREATE_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  new_context->type = CONTEXT_RUN_THREAD;
  context_state(new_context) = packet_state(recv_packet);
  context_join_dmi_context(new_context).context_id = packet_context_id(recv_packet);
  context_join_dmi_context(new_context).dmi_id = packet_dmi_id(recv_packet);
  context_yield_flag(new_context) = FALSE;
  context_migration_flag(new_context) = FALSE;
  
  pheap_id = xidpool_get(_memory->xidpool);
  xvector_assign(_memory->pheap_xvector, pheap_id, pheap);
  context_pheap_id(new_context) = pheap_id;
  
  thread_gate = NULL;
  thread_num = xvector_size(dmi->thread_gate_xvector);
  for(thread_id = 0; thread_id < thread_num; thread_id++)
    {
      thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
      if(thread_gate->state == STATE_FORBID)
        {
          break;
        }
    }
  if(thread_id == thread_num)
    {
      thread_gate = gate_alloc();
      xvector_push(dmi->thread_gate_xvector, thread_gate);
    }
  context_thread_id(new_context) = thread_id;
  
  thread = thread_alloc();
  thread->wake_flag = FALSE;
  thread->context = new_context;
  
  thread_gate->body = thread;
  
  gate_permit(thread_gate);
  
  ret = gate_enter(thread_gate);
  if(ret == FALSE) error();
  
  pthread_create(&thread->pthread, NULL, context_switcher, new_context);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_YIELD_THREAD;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_thread_id(send_packet) = context_thread_id(new_context);
  packet_ret_flag(send_packet) = TRUE;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_ack_yield_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_yield_thread_post(context);
  return;
}

void context_yield_thread_post(context_t *context)
{
  pthread_mutex_lock(&context->mutex);
  
  context_ret_flag(context) = packet_ret_flag(context->recv_packet);
  context_new_thread_id(context) = packet_thread_id(context->recv_packet);
  pthread_cond_broadcast(&context->cond);
  
  pthread_mutex_unlock(&context->mutex);
  return;
}

void context_close_thread_pre(context_t *context)
{
  gate_t *thread_gate;
  
  thread_gate = (gate_t*)xvector_at(context->dmi->thread_gate_xvector, context_thread_id(context));
  
  gate_escape(thread_gate);
  
  gate_forbid(thread_gate, context, context_close_thread_post);
  return;
}

void context_close_thread_post(context_t *context)
{
  packet_t *send_packet;
  thread_t *thread;
  pheap_t *pheap;
  mblock_t *mblock;
  mmapped_t *mmapped;
  gate_t *thread_gate;
  int32_t ret;
  
  thread_gate = (gate_t*)xvector_at(context->dmi->thread_gate_xvector, context_thread_id(context));
  thread = (thread_t*)thread_gate->body;
  thread_gate->body = NULL;
  
  pthread_join(thread->pthread, NULL);
  
  pthread_mutex_lock(&context->mutex);
  
  switch(context_state(context))
    {
    case STATE_CREATE:
      error();
      break;
    case STATE_EXIT:
      break;
    case STATE_JOIN:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_JOIN_THREAD;
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context_join_dmi_context(context).context_id;
      send_packet->dst_dmi_id = context_join_dmi_context(context).dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_dmi_addr(send_packet) = context_dmi_addr(context);
      packet_ret_flag(send_packet) = TRUE;
      dmi_send_packet(context->dmi, send_packet);
      packet_free(send_packet);
      break;
    case STATE_DETACH:
      break;
    default:
      error();
    }
  
  pthread_mutex_unlock(&context->mutex);
  
  thread_free(thread);
  
  pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, context_pheap_id(context));
  xvector_assign(_memory->pheap_xvector, context_pheap_id(context), NULL);
  xidpool_put(_memory->xidpool, context_pheap_id(context));
  
  dmi_free_context(context->dmi, context, TRUE);
  
  while(!list_isempty(pheap->mblock_list))
    {
      mblock = (mblock_t*)list_shift(pheap->mblock_list);
      
      mblock_free(mblock);
    }
  
  while(!list_isempty(pheap->mmapped_list))
    {
      mmapped = (mmapped_t*)list_shift(pheap->mmapped_list);
      
      pthread_mutex_lock(&_memory->mmap_mutex);
      
      ret = true_syscall_munmap(mmapped->start_ptr, mmapped->size);
      if(ret < 0) error();
      
      pthread_mutex_unlock(&_memory->mmap_mutex);
      
      mmapped_free(mmapped);
    }
  
  ret = true_syscall_munmap(pheap->stack_ptr, pheap->stack_size);
  if(ret < 0) error();
  
  pheap_free(pheap);
  return;
}

void dmi_handle_ack_create_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_create_thread_post(context);
  return;
}

void context_create_thread_post(context_t *context)
{
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      (*context_dmi_thread_ptr(context)).dmi_id = context_dmi_id(context);
      (*context_dmi_thread_ptr(context)).thread_id = packet_thread_id(context->recv_packet);
      
      dmi_free_context(context->dmi, context, TRUE);
    }
  else
    {
      dmi_free_context(context->dmi, context, FALSE);
    }
  return;
}

void dmi_join_thread(dmi_t *dmi, dmi_thread_t dmi_thread, int64_t *dmi_addr_ptr, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_JOIN_THREAD;
  context_dmi_thread(new_context) = dmi_thread;
  context_dmi_addr_ptr(new_context) = dmi_addr_ptr;
  
  context_join_thread_pre(new_context);
  return;
}

void context_join_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  int32_t ret;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_thread(context).dmi_id);
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_JOIN_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_thread(context).dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_thread_id(send_packet) = context_dmi_thread(context).thread_id;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_join_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t ret;
  
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, packet_thread_id(recv_packet));
  
  ret = gate_enter(thread_gate);
  if(ret == FALSE)
    {
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_JOIN_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  pthread_mutex_lock(&context->mutex);
  
  switch(context_state(context))
    {
    case STATE_CREATE:
      context_state(context) = STATE_JOIN;
      context_join_dmi_context(context).context_id = recv_packet->context_id;
      context_join_dmi_context(context).dmi_id = recv_packet->src_dmi_id;
      
      pthread_mutex_unlock(&context->mutex);
      break;
    case STATE_EXIT:
      context_state(context) = STATE_JOIN;
      context_join_dmi_context(context).context_id = recv_packet->context_id;
      context_join_dmi_context(context).dmi_id = recv_packet->src_dmi_id;
      
      pthread_mutex_unlock(&context->mutex);
      
      context_close_thread_pre(context);
      break;
    case STATE_JOIN:
    case STATE_DETACH:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_JOIN_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&context->mutex);
      break;
    default:
      error();
    }
  
  gate_escape(thread_gate);
  return;
}

void dmi_handle_ack_join_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_join_thread_post(context);
  return;
}

void context_join_thread_post(context_t *context)
{
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      if(context_dmi_addr_ptr(context) != NULL)
        {
          *context_dmi_addr_ptr(context) = packet_dmi_addr(context->recv_packet);
        }
      
      dmi_free_context(context->dmi, context, TRUE);
    }
  else
    {
      dmi_free_context(context->dmi, context, FALSE);
    }
  return;
}

void dmi_detach_thread(dmi_t *dmi, dmi_thread_t dmi_thread, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_DETACH_THREAD;
  context_dmi_thread(new_context) = dmi_thread;
  
  context_detach_thread_pre(new_context);
  return;
}

void context_detach_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  int32_t ret;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_thread(context).dmi_id);
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_DETACH_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_thread(context).dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_thread_id(send_packet) = context_dmi_thread(context).thread_id;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_detach_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t ret;
  
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, packet_thread_id(recv_packet));
  
  ret = gate_enter(thread_gate);
  if(ret == FALSE)
    {
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_DETACH_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  pthread_mutex_lock(&context->mutex);
  
  switch(context_state(context))
    {
    case STATE_CREATE:
      context_state(context) = STATE_DETACH;
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_DETACH_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = TRUE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&context->mutex);
      break;
    case STATE_EXIT:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_DETACH_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = TRUE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&context->mutex);
      
      context_close_thread_pre(context);
      break;
    case STATE_JOIN:
    case STATE_DETACH:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_DETACH_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&context->mutex);
      break;
    default:
      error();
    }
  
  gate_escape(thread_gate);
  return;
}

void dmi_handle_ack_detach_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_detach_thread_post(context);
  return;
}

void context_detach_thread_post(context_t *context)
{
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      dmi_free_context(context->dmi, context, TRUE);
    }
  else
    {
      dmi_free_context(context->dmi, context, FALSE);
    }
  return;
}

void dmi_migrate_thread(dmi_t *dmi, dmi_thread_t dmi_thread, int32_t dmi_id, dmi_thread_t *dmi_thread_ptr, int8_t *migrate_flag_ptr, status_t *status)
{
#if !DEBUG_MIGRATION
  status_finish(status, FALSE);
  return;
#else
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_MIGRATE_THREAD;
  context_dmi_thread(new_context) = dmi_thread;
  context_dmi_id(new_context) = dmi_id;
  context_dmi_thread_ptr(new_context) = dmi_thread_ptr;
  context_flag_ptr(new_context) = migrate_flag_ptr;
  
  context_migrate_thread_pre(new_context);
  return;
#endif
}

void context_migrate_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  int32_t ret;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_thread(context).dmi_id);
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_MIGRATE_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_thread(context).dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_thread_id(send_packet) = context_dmi_thread(context).thread_id;
  packet_dmi_id(send_packet) = context_dmi_id(context);
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_migrate_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t ret;
  
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, packet_thread_id(recv_packet));
  
  ret = gate_enter(thread_gate);
  if(ret == FALSE)
    {
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_MIGRATE_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  pthread_mutex_lock(&context->mutex);
  
  switch(context_state(context))
    {
    case STATE_CREATE:
    case STATE_JOIN:
    case STATE_DETACH:
      context_migration_flag(context) = TRUE;
      context_dmi_id(context) = packet_dmi_id(recv_packet);
      context_parent_dmi_context(context).context_id = recv_packet->context_id;
      context_parent_dmi_context(context).dmi_id = recv_packet->src_dmi_id;
      
      pthread_mutex_unlock(&context->mutex);
      break;
    case STATE_EXIT:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_MIGRATE_THREAD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&context->mutex);
      
      context_close_thread_pre(context);
      break;
    default:
      error();
    }
  
  gate_escape(thread_gate);
  return;
}

void dmi_handle_ack_migrate_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_migrate_thread_post(context);
  return;
}

void context_migrate_thread_post(context_t *context)
{
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      *context_flag_ptr(context) = packet_migrate_flag(context->recv_packet);
      if(packet_migrate_flag(context->recv_packet) == TRUE)
        {
          (*context_dmi_thread_ptr(context)).dmi_id = context_dmi_id(context);
          (*context_dmi_thread_ptr(context)).thread_id = packet_thread_id(context->recv_packet);
        }
      
      dmi_free_context(context->dmi, context, TRUE);
    }
  else
    {
      dmi_free_context(context->dmi, context, FALSE);
    }
  return;
}

void dmi_wake_thread(dmi_t *dmi, dmi_thread_t dmi_thread, void *out_ptr, int64_t out_size, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_WAKE_THREAD;
  context_dmi_thread(new_context) = dmi_thread;
  context_out_size(new_context) = out_size;
  context_out_ptr(new_context) = (int8_t*)out_ptr;
  
  context_wake_thread_pre(new_context);
  return;
}

void context_wake_thread_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  int32_t ret;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_dmi_thread(context).dmi_id);
  ret = gate_enter(peer_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_WAKE_THREAD;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_dmi_thread(context).dmi_id;
  send_packet->page_payload_size = 0;
  packet_thread_id(send_packet) = context_dmi_thread(context).thread_id;
  send_packet->data_payload_size = context_out_size(context);
  send_packet->data_payload_buf = (int8_t*)my_malloc(send_packet->data_payload_size);
  send_packet->data_payload_ptr = send_packet->data_payload_buf;
  memcpy(send_packet->data_payload_ptr, context_out_ptr(context), context_out_size(context));
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_wake_thread(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t ret;
  
  if(packet_thread_id(recv_packet) == SYS_MAIN_THREAD_ID)
    {
      thread_gate = NULL;
      thread = dmi->main_thread;
    }
  else
    {
      thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, packet_thread_id(recv_packet));
      
      ret = gate_enter(thread_gate);
      if(ret == FALSE)
        {
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_WAKE_THREAD;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          packet_ret_flag(send_packet) = FALSE;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          return;
        }
      thread = (thread_t*)thread_gate->body;
    }
  
  pthread_mutex_lock(&thread->mutex);
  
  thread->in_size = recv_packet->data_payload_size;
  thread->in_buf = (int8_t*)my_realloc(thread->in_buf, thread->in_size);
  memcpy(thread->in_buf, recv_packet->data_payload_ptr, thread->in_size);
  thread->wake_flag = TRUE;
  
  pthread_cond_broadcast(&thread->cond);
  
  pthread_mutex_unlock(&thread->mutex);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_WAKE_THREAD;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_ret_flag(send_packet) = TRUE;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  if(thread_gate != NULL)
    {
      gate_escape(thread_gate);
    }
  return;
}

void dmi_handle_ack_wake_thread(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_wake_thread_post(context);
  return;
}

void context_wake_thread_post(context_t *context)
{
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      dmi_free_context(context->dmi, context, TRUE);
    }
  else
    {
      dmi_free_context(context->dmi, context, FALSE);
    }
  return;
}

int32_t dmi_suspend_thread(dmi_t *dmi, void *in_ptr)
{
  thread_t *thread;
  gate_t *thread_gate;
  int32_t thread_id;
  
  thread_id = _tls_thread_id;
  if(thread_id == SYS_ID_UNDEF)
    {
      return FALSE;
    }
  
  if(thread_id == SYS_MAIN_THREAD_ID)
    {
      thread = dmi->main_thread;
    }
  else
    {
      thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
      thread = (thread_t*)thread_gate->body;
    }
  
  pthread_mutex_lock(&thread->mutex);
  
  while(thread->wake_flag == FALSE)
    {
      pthread_cond_wait(&thread->cond, &thread->mutex);
    }
  
  if(in_ptr != NULL)
    {
      memcpy(in_ptr, thread->in_buf, thread->in_size);
    }
  thread->wake_flag = FALSE;
  
  pthread_mutex_unlock(&thread->mutex);
  return TRUE;
}

int32_t dmi_self_thread(dmi_t *dmi, dmi_thread_t *dmi_thread_ptr)
{
  int32_t thread_id;
  
  thread_id = _tls_thread_id;
  if(thread_id == SYS_ID_UNDEF)
    {
      return FALSE;
    }
  
  (*dmi_thread_ptr).dmi_id = dmi->dmi_id;
  (*dmi_thread_ptr).thread_id = thread_id;
  return TRUE;
}

void* dmi_mmap_tls(dmi_t *dmi, void *start, size_t length, int prot, int flags, int fd, off_t offset)
{
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  void *ptr;
  int32_t thread_id;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return MAP_FAILED;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  _tls_pheap_id = context_pheap_id(context);
  
  ptr = hook_syscall_mmap(start, length, prot, flags, fd, offset);
  
  _tls_pheap_id = SYS_ID_UNDEF;
  return ptr;
}

void* dmi_mremap_tls(dmi_t *dmi, void *old_address, size_t old_size, size_t new_size, int flags)
{
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  void *ptr;
  int32_t thread_id;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return MAP_FAILED;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  _tls_pheap_id = context_pheap_id(context);
  
  ptr = hook_syscall_mremap(old_address, old_size, new_size, flags);
  
  _tls_pheap_id = SYS_ID_UNDEF;
  return ptr;
}

int32_t dmi_mprotect_tls(dmi_t *dmi, void *addr, size_t len, int prot)
{
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t thread_id, ret;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return -1;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  _tls_pheap_id = context_pheap_id(context);
  
  ret = hook_syscall_mprotect(addr, len, prot);
  
  _tls_pheap_id = SYS_ID_UNDEF;
  return ret;
}

int32_t dmi_munmap_tls(dmi_t *dmi, void *start, size_t length)
{
  context_t *context;
  thread_t *thread;
  gate_t *thread_gate;
  int32_t thread_id, ret;
  
  thread_id = _tls_thread_id;
  thread_gate = (gate_t*)xvector_at(dmi->thread_gate_xvector, thread_id);
  if(thread_gate == NULL)
    {
      return -1;
    }
  thread = (thread_t*)thread_gate->body;
  context = thread->context;
  
  _tls_pheap_id = context_pheap_id(context);
  
  ret = hook_syscall_munmap(start, length);
  
  _tls_pheap_id = SYS_ID_UNDEF;
  return ret;
}

/* lock/unlock/trylock/delegate token */

void context_lock_token_pre(context_t *context)
{
  packet_t *send_packet;
  token_t *token;
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_LOCK_TOKEN;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = token->owner_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  pthread_mutex_unlock(&token->mutex);
  return;
}

void dmi_handle_req_lock_token(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  token_t *token;
  dmi_context_t *dmi_context_buf;
  
  token = dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  if(token->owner_flag == TRUE)
    {
      if(token->lock_flag == FALSE)
        {
          token->lock_flag = TRUE;
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_LOCK_TOKEN;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
        }
      else
        {
          dmi_context_buf = (dmi_context_t*)my_malloc(sizeof(dmi_context_t));
          dmi_context_buf->context_id = recv_packet->context_id;
          dmi_context_buf->dmi_id = recv_packet->src_dmi_id;
          deque_unshift(token->dmi_context_deque, dmi_context_buf);
        }
    }
  else
    {
      recv_packet->dst_dmi_id = token->owner_id;
      dmi_send_packet(dmi, recv_packet);
    }
  
  pthread_mutex_unlock(&token->mutex);
  return;
}

void dmi_handle_ack_lock_token(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_lock_token_post(context);
  return;
}

void context_lock_token_post(context_t *context)
{
  packet_t *send_packet;
  gate_t *peer_gate, *vm_gate;
  peer_t *peer;
  vm_t *vm;
  page_t *page;
  token_t *token;
  writebuf_t *writebuf;
  int32_t dmi_id, peer_gate_num, vm_id, vm_gate_num, count;
  int64_t page_id, offset;
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  token->owner_id = context->recv_packet->src_dmi_id;
  
  pthread_mutex_unlock(&token->mutex);
  
  switch(context->type)
    {
    case CONTEXT_JOIN_WORLD:
      writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
      
      peer_gate_num = xvector_size(context->dmi->peer_gate_xvector);
      writebuf_copy(writebuf, &peer_gate_num, sizeof(int32_t));
      offset = writebuf_skip(writebuf, sizeof(int32_t));
      count = 0;
      for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
        {
          peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
          if(peer_gate->state == STATE_PERMIT)
            {
              peer = (peer_t*)peer_gate->body;
              
              writebuf_copy(writebuf, &dmi_id, sizeof(int32_t));
              writebuf_copy(writebuf, &peer->ip_size, sizeof(uint16_t));
              writebuf_copy(writebuf, &peer->port, sizeof(uint16_t));
              writebuf_copy(writebuf, peer->ip, peer->ip_size);
              count++;
            }
        }
      writebuf_seekcopy(writebuf, offset, &count, sizeof(int32_t));
      
      vm_gate_num = xvector_size(context->dmi->vm_gate_xvector);
      writebuf_copy(writebuf, &vm_gate_num, sizeof(int32_t));
      offset = writebuf_skip(writebuf, sizeof(int32_t));
      count = 0;
      for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
        {
          vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
          if(vm_gate->state == STATE_PERMIT)
            {
              vm = (vm_t*)vm_gate->body;
              
              writebuf_copy(writebuf, &vm_id, sizeof(int32_t));
              writebuf_copy(writebuf, &vm->page_size, sizeof(int64_t));
              writebuf_copy(writebuf, &vm->page_num, sizeof(int64_t));
              count++;
              
              for(page_id = 0; page_id < vm->page_num; page_id++)
                {
                  page = vm->page_table[page_id];
                  
                  writebuf_copy(writebuf, &page->owner_id, sizeof(int32_t));
                  writebuf_copy(writebuf, &page->slide_size, sizeof(int64_t));
                }
            }
        }
      writebuf_seekcopy(writebuf, offset, &count, sizeof(int32_t));
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_HELLO_WORLD;
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context_parent_dmi_context(context).context_id;
      send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = writebuf_size(writebuf);
      send_packet->data_payload_ptr = writebuf_buf(writebuf);
      send_packet->sock = context_sock(context);
      packet_owner_id(send_packet) = context->dmi->token->owner_id;
      packet_ret_flag(send_packet) = TRUE;
      dmi_send_packet(context->dmi, send_packet);
      packet_free(send_packet);
      
      writebuf_free(writebuf);
      
      dmi_free_context(context->dmi, context, TRUE);
      break;
    case CONTEXT_LEAVE_WORLD:
      context_forbid_peer_pre(context);
      break;
    case CONTEXT_ALLOC_VMS:
      context_alloc_vms_pre(context);
      break;
    case CONTEXT_FREE_VMS:
      context_forbid_vms_pre(context);
      break;
    default:
      error();
    }
  return;
}

void context_unlock_token_pre(context_t *context)
{
  packet_t *send_packet;
  token_t *token;
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_UNLOCK_TOKEN;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = token->owner_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  pthread_mutex_unlock(&token->mutex);
  return;
}

void dmi_handle_req_unlock_token(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  token_t *token;
  dmi_context_t *dmi_context_buf;
  
  token = dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  if(token->owner_flag == TRUE)
    {
      if(token->lock_flag == TRUE)
        {
          if(deque_isempty(token->dmi_context_deque))
            {
              token->lock_flag = FALSE;
            }
          else
            {
              dmi_context_buf = (dmi_context_t*)deque_pop(token->dmi_context_deque);
              
              send_packet = packet_alloc();
              send_packet->type = PACKET_ACK_LOCK_TOKEN;
              send_packet->src_dmi_id = dmi->dmi_id;
              send_packet->context_id = dmi_context_buf->context_id;
              send_packet->dst_dmi_id = dmi_context_buf->dmi_id;
              send_packet->page_payload_size = 0;
              send_packet->data_payload_size = 0;
              dmi_send_packet(dmi, send_packet);
              packet_free(send_packet);
              
              my_free(dmi_context_buf);
            }
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_UNLOCK_TOKEN;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
        }
      else
        {
          error();
        }
    }
  else
    {
      recv_packet->dst_dmi_id = token->owner_id;
      dmi_send_packet(dmi, recv_packet);
    }
  
  pthread_mutex_unlock(&token->mutex);
  return;
}

void dmi_handle_ack_unlock_token(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_unlock_token_post(context);
  return;
}

void context_unlock_token_post(context_t *context)
{
  packet_t *send_packet;
  token_t *token;
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  token->owner_id = context->recv_packet->src_dmi_id;
  
  pthread_mutex_unlock(&token->mutex);
  
  switch(context->type)
    {
    case CONTEXT_JOIN_WORLD:
      gate_permit(context->dmi->contexts_gate);
      
      dmi_free_context(context->dmi, context, TRUE);
      break;
    case CONTEXT_LEAVE_WORLD:
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_BYE_WORLD;
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context_parent_dmi_context(context).context_id;
      send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      send_packet->sock = context_sock(context);
      dmi_send_packet(context->dmi, send_packet);
      packet_free(send_packet);
      
      dmi_free_context(context->dmi, context, TRUE);
      break;
    case CONTEXT_ALLOC_VMS:
      dmi_free_context(context->dmi, context, context_ret_flag(context));
      break;
    case CONTEXT_FREE_VMS:
      dmi_free_context(context->dmi, context, context_ret_flag(context));
      break;
    default:
      error();
    }
  return;
}

void context_delegate_token_pre(context_t *context)
{
  packet_t *send_packet;
  token_t *token;
  dmi_context_t *dmi_context_buf;
  writebuf_t *writebuf;
  int32_t owner_id, dmi_context_num;
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  if(token->owner_flag == TRUE)
    {
      owner_id = dmi_enter_token_heir(context->dmi, token);
      if(owner_id == SYS_ID_UNDEF)
        {
          error();
        }
      
      token->owner_flag = FALSE;
      token->owner_id = owner_id;
      
      writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
      
      dmi_context_num = deque_size(token->dmi_context_deque);
      writebuf_copy(writebuf, &dmi_context_num, sizeof(int32_t));
      while(!deque_isempty(token->dmi_context_deque))
        {
          dmi_context_buf = (dmi_context_t*)deque_pop(token->dmi_context_deque);
          writebuf_copy(writebuf, dmi_context_buf, sizeof(dmi_context_t));
          my_free(dmi_context_buf);
        }
      
      send_packet = packet_alloc();
      send_packet->type = PACKET_REQ_DELEGATE_TOKEN;
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context->context_id;
      send_packet->dst_dmi_id = owner_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = writebuf_size(writebuf);
      send_packet->data_payload_ptr = writebuf_buf(writebuf);
      packet_lock_flag(send_packet) = token->lock_flag;
      dmi_send_packet(context->dmi, send_packet);
      packet_free(send_packet);
      
      writebuf_free(writebuf);
      
      dmi_escape_token_heir(context->dmi, owner_id);
      
      pthread_mutex_unlock(&token->mutex);
    }
  else
    {
      pthread_mutex_unlock(&token->mutex);
      
      context_free_peer_pre(context);
    }
  return;
}

int32_t dmi_enter_token_heir(dmi_t *dmi, token_t *token)
{
  gate_t *peer_gate;
  int32_t dmi_id, peer_gate_num, i, ret;
  
  peer_gate_num = xvector_size(dmi->peer_gate_xvector);
  dmi_id = mrand_int(0, peer_gate_num - 1);
  for(i = 0; i < peer_gate_num; i++)
    {
      if(dmi_id != dmi->dmi_id)
        {
          peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, dmi_id);
          ret = gate_enter(peer_gate);
          if(ret == TRUE)
            {
              return dmi_id;
            }
        }
      dmi_id = (dmi_id + 1) % peer_gate_num;
    }
  return SYS_ID_UNDEF;
}

void dmi_escape_token_heir(dmi_t *dmi, int32_t owner_id)
{
  gate_t *peer_gate;
  
  peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, owner_id);
  gate_escape(peer_gate);
  return;
}

void dmi_handle_req_delegate_token(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  token_t *token;
  dmi_context_t *dmi_context_buf;
  readbuf_t *readbuf;
  int32_t i, dmi_context_num;
  
  token = dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  token->owner_flag = TRUE;
  token->lock_flag = packet_lock_flag(recv_packet);
  token->owner_id = dmi->dmi_id;
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  
  readbuf_copy(readbuf, &dmi_context_num, sizeof(int32_t));
  for(i = 0; i < dmi_context_num; i++)
    {
      dmi_context_buf = (dmi_context_t*)my_malloc(sizeof(dmi_context_t));
      readbuf_copy(readbuf, dmi_context_buf, sizeof(dmi_context_t));
      deque_unshift(token->dmi_context_deque, dmi_context_buf);
    }
  
  readbuf_free(readbuf);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_DELEGATE_TOKEN;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  pthread_mutex_unlock(&token->mutex);
  return;
}

void dmi_handle_ack_delegate_token(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_delegate_token_post(context);
  return;
}

void context_delegate_token_post(context_t *context)
{
  context_free_peer_pre(context);
  return;
}

/* join/leave world */

void dmi_join_world(dmi_t *dmi, char *ip, uint16_t port, status_t *status)
{
  context_t *new_context;
  vm_t *vm;
  token_t *token;
  gate_t *vm_gate;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_SLAVE);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_JOIN_WORLD;
  context_ip(new_context) = ip;
  context_port(new_context) = port;
  
  if(context_ip(new_context) == NULL)
    {
      dmi->dmi_id = 0;
      
      token = dmi->token;
      token->owner_flag = TRUE;
      token->lock_flag = FALSE;
      token->owner_id = dmi->dmi_id;
      
      token->lock_flag = TRUE;
      
      vm_gate = gate_alloc();
      xvector_push(dmi->vm_gate_xvector, vm_gate);
      
      vm = vm_alloc();
      vm->page_size = sizeof(int64_t);
      vm->page_num = 1;
      
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, 0);
      vm_gate->body = vm;
      
      dmi_alloc_pages(dmi, vm, &dmi->dmi_id, 1, sizeof(int64_t));
      
      gate_permit(vm_gate);
      
      context_permit_peer_pre(new_context);
    }
  else
    {
      context_hello_world_pre(new_context);
    }
  return;
}

void context_hello_world_pre(context_t *context)
{
  packet_t *send_packet, *recv_packet;
  int temporal_sock;
  int32_t ret, dmi_id;
  char ip[IP_SIZE];
  
  fqdn_to_ip(context_ip(context), ip, IP_SIZE);
  
  temporal_sock = sock_connect(ip, context_port(context));
  if(temporal_sock < 0)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  dmi_id = SYS_ID_UNDEF;
  ret = sock_send(temporal_sock, &dmi_id, sizeof(int32_t));
  if(ret < 0) error();
    
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_HELLO_WORLD;
  send_packet->src_dmi_id = SYS_ID_UNDEF;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  send_packet->sock = temporal_sock;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  recv_packet = packet_alloc();
  ret = packet_recv(recv_packet, temporal_sock, TYPE_SOCKET);
  if(ret == FALSE) error();
  recv_packet->sock = temporal_sock;
  
  dmi_handle_packet(context->dmi, recv_packet);
  
  packet_free(recv_packet);
  
  sock_close(temporal_sock);
  return;
}

void dmi_handle_req_hello_world(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_MASTER);
  if(new_context == NULL)
    {
      send_packet = packet_alloc();
      send_packet->type = PACKET_ACK_HELLO_WORLD;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = SYS_ID_UNDEF;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      send_packet->sock = recv_packet->sock;
      packet_ret_flag(send_packet) = FALSE;
      dmi_send_packet(dmi, send_packet);
      packet_free(send_packet);
      return;
    }
  new_context->type = CONTEXT_JOIN_WORLD;
  context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
  context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
  context_sock(new_context) = recv_packet->sock;
  
  context_lock_token_pre(new_context);
  return;
}

void dmi_handle_ack_hello_world(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_hello_world_post(context);
  return;
}

void context_hello_world_post(context_t *context)
{
  peer_t *peer;
  vm_t *vm;
  page_t *page;
  token_t *token;
  gate_t *peer_gate, *vm_gate;
  readbuf_t *readbuf;
  host_t host;
  int32_t dmi_id, peer_gate_num, peer_num, vm_id, vm_gate_num, vm_num, owner_id, i;
  int64_t page_id, slide_size;
  
  if(packet_ret_flag(context->recv_packet) == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  token = context->dmi->token;
  token->owner_flag = FALSE;
  token->lock_flag = FALSE;
  token->owner_id = packet_owner_id(context->recv_packet);
  
  readbuf = readbuf_alloc(context->recv_packet->data_payload_ptr, context->recv_packet->data_payload_size);
  
  readbuf_copy(readbuf, &peer_gate_num, sizeof(int32_t));
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = gate_alloc();
      xvector_push(context->dmi->peer_gate_xvector, peer_gate);
    }
  readbuf_copy(readbuf, &peer_num, sizeof(int32_t));
  for(i = 0; i < peer_num; i++)
    {
      readbuf_copy(readbuf, &dmi_id, sizeof(int32_t));
      
      peer = peer_alloc();
      readbuf_copy(readbuf, &peer->ip_size, sizeof(uint16_t));
      readbuf_copy(readbuf, &peer->port, sizeof(uint16_t));
      readbuf_copy(readbuf, peer->ip, peer->ip_size);
      
      if(dmi_id == context->recv_packet->src_dmi_id)
        {
          sock_get_yourhost(context->recv_packet->sock, &host);
          peer->ip_size = strlen(host.ip) + 1;
          memcpy(peer->ip, host.ip, peer->ip_size);
        }
      
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      peer_gate->body = peer;
      
      gate_permit(peer_gate);
    }
  
  readbuf_copy(readbuf, &vm_gate_num, sizeof(int32_t));
  for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
    {
      vm_gate = gate_alloc();
      xvector_push(context->dmi->vm_gate_xvector, vm_gate);
    }
  readbuf_copy(readbuf, &vm_num, sizeof(int32_t));
  for(i = 0; i < vm_num; i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      
      vm = vm_alloc();
      readbuf_copy(readbuf, &vm->page_size, sizeof(int64_t));
      readbuf_copy(readbuf, &vm->page_num, sizeof(int64_t));
      vm->page_table = (page_t**)my_malloc(vm->page_num * sizeof(page_t*));
      
      for(page_id = 0; page_id < vm->page_num; page_id++)
        {
          readbuf_copy(readbuf, &owner_id, sizeof(int32_t));
          readbuf_copy(readbuf, &slide_size, sizeof(int64_t));
          if(owner_id == SYS_ID_UNDEF)
            {
              owner_id = context->recv_packet->src_dmi_id;
            }
          
          page = page_alloc();
          
          page->state = STATE_INVALID;
          page->slide_size = slide_size;
          page->decor = 0;
          page->owner_flag = FALSE;
          page->owner_id = owner_id;
          page->buf = NULL;
          page->buf_size = 0;
          vm->page_table[page_id] = page;
        }
      
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      vm_gate->body = vm;
      
      gate_permit(vm_gate);
    }
  
  readbuf_free(readbuf);
  
  peer_gate_num = xvector_size(context->dmi->peer_gate_xvector);
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->state == STATE_FORBID)
        {
          break;
        }
    }
  context->dmi->dmi_id = dmi_id;
  
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->state == STATE_PERMIT)
        {
          peer = (peer_t*)peer_gate->body;
          
          comm_connect(context->dmi->comm, context->dmi->dmi_id, dmi_id, peer->ip, peer->port);
        }
    }
  
  context_alloc_peer_pre(context);
  return;
}

void context_alloc_peer_pre(context_t *context)
{
  packet_t *send_packet;
  host_t host;
  
  comm_self(context->dmi->comm, &host);
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_ALLOC_PEER;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_port(send_packet) = host.port;
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  return;
}

void dmi_handle_req_alloc_peer(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  peer_t *peer;
  gate_t *peer_gate;
  host_t host;
  int32_t i;
  
  for(i = xvector_size(dmi->peer_gate_xvector); i <= recv_packet->src_dmi_id; i++)
    {
      peer_gate = gate_alloc();
      xvector_push(dmi->peer_gate_xvector, peer_gate);
    }
  
  peer = peer_alloc();
  peer->port = packet_port(recv_packet);
  sock_get_yourhost(recv_packet->sock, &host);
  peer->ip_size = strlen(host.ip) + 1;
  memcpy(peer->ip, host.ip, peer->ip_size);
  
  peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, recv_packet->src_dmi_id);
  peer_gate->body = peer;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_ALLOC_PEER;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_ack_alloc_peer(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_alloc_peer_post(context);
  return;
}

void context_alloc_peer_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_permit_peer_pre(context);
    }
  return;
}

void context_permit_peer_pre(context_t *context)
{
  packet_t *send_packet;
  peer_t *peer;
  gate_t *peer_gate;
  host_t host;
  int32_t i;
  
  for(i = xvector_size(context->dmi->peer_gate_xvector); i <= context->dmi->dmi_id; i++)
    {
      peer_gate = gate_alloc();
      xvector_push(context->dmi->peer_gate_xvector, peer_gate);
    }
  
  comm_self(context->dmi->comm, &host);
  
  peer = peer_alloc();
  peer->port = host.port;
  peer->ip_size = strlen(host.ip) + 1;
  memcpy(peer->ip, host.ip, peer->ip_size);
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context->dmi->dmi_id);
  peer_gate->body = peer;
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_PERMIT_PEER;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  return;
}

void dmi_handle_req_permit_peer(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  gate_t *peer_gate;
  
  peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, recv_packet->src_dmi_id);
  
  gate_permit(peer_gate);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_PERMIT_PEER;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_ack_permit_peer(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_permit_peer_post(context);
  return;
}

void context_permit_peer_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_unlock_token_pre(context);
    }
  return;
}

void dmi_leave_world(dmi_t *dmi, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_SLAVE);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_LEAVE_WORLD;
  context_vm_num(new_context) = 1;
  new_context->buf = (int8_t*)my_malloc(sizeof(int32_t));
  context_vm_ids(new_context) = (int32_t*)new_context->buf;
  context_vm_ids(new_context)[0] = 0;
  context_ret_flag(new_context) = TRUE;
  context_object_flag(new_context) = FALSE;
  
  context_close_contexts_pre(new_context);
  return;
}

void context_close_contexts_pre(context_t *context)
{
  gate_forbid(context->dmi->contexts_gate, context, context_close_contexts_post);
  return;
}

void context_close_contexts_post(context_t *context)
{
  context_lock_token_pre(context);
  return;
}

void context_forbid_peer_pre(context_t *context)
{
  packet_t *send_packet;
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_FORBID_PEER;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  return;
}

void dmi_handle_req_forbid_peer(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
  new_context->type = CONTEXT_LEAVE_WORLD;
  context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
  context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
  
  context_close_peer_pre(new_context);
  return;
}

void context_close_peer_pre(context_t *context)
{
  gate_t *peer_gate;
  
  peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context_parent_dmi_context(context).dmi_id);
  
  gate_forbid(peer_gate, context, context_close_peer_post);
  return;
}

void context_close_peer_post(context_t *context)
{
  packet_t *send_packet;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_FORBID_PEER;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context_parent_dmi_context(context).context_id;
  send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  dmi_free_context(context->dmi, context, TRUE);
  return;
}

void dmi_handle_ack_forbid_peer(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_forbid_peer_post(context);
  return;
}

void context_forbid_peer_post(context_t *context)
{
  peer_t *peer;
  gate_t *peer_gate;
  
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, context->dmi->dmi_id);
      peer = (peer_t*)peer_gate->body;
      peer_gate->body = NULL;
      
      peer_free(peer);
      
      if(context_total(context) == 1)
        {
          context_count(context) = 0;
          context_total(context) = context_vm_num(context);
          
          context_close_vms_pre(context);
        }
      else
        {      
          context_clear_pages_pre(context);
        }
    }
  return;
}

void context_clear_pages_pre(context_t *context)
{
  context_t *new_context;
  vm_t *vm;
  gate_t *vm_gate;
  int32_t vm_id, vm_gate_num, count;
  int64_t page_id;
  
  count = 0;
  vm_gate_num = xvector_size(context->dmi->vm_gate_xvector);
  for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      if(vm_gate->state == STATE_PERMIT)
        {
          vm = (vm_t*)vm_gate->body;
          count += vm->page_num;
        }
    }
  
  context_count(context) = 0;
  context_total(context) = count;
  
  for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      if(vm_gate->state == STATE_PERMIT)
        {
          vm = (vm_t*)vm_gate->body;
          for(page_id = 0; page_id < vm->page_num; page_id++)
            {
              new_context = dmi_alloc_context(context->dmi, NULL, TYPE_SLAVE);
              new_context->type = CONTEXT_LEAVE_WORLD;
              context_parent_context_id(new_context) = context->context_id;
              context_vm_id(new_context) = vm_id;
              context_page_id(new_context) = page_id;
              
              context_sweep_page_pre(new_context);
            }
        }
    }
  return;
}

void context_clear_pages_post(context_t *context)
{
  context_t *parent_context;
  
  parent_context = dmi_get_context(context->dmi, context_parent_context_id(context));
  
  dmi_free_context(context->dmi, context, TRUE);
  
  pthread_mutex_lock(&parent_context->mutex);
  
  context_count(parent_context)++;
  
  if(context_count(parent_context) == context_total(parent_context))
    {
      pthread_mutex_unlock(&parent_context->mutex);
      
      context_delegate_token_pre(parent_context);
    }
  else
    {
      pthread_mutex_unlock(&parent_context->mutex);
    }
  return;
}

void context_free_peer_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  token_t *token;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t vm_id, vm_gate_num, count;
  int64_t page_id, offset;
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  vm_gate_num = xvector_size(context->dmi->vm_gate_xvector);
  offset = writebuf_skip(writebuf, sizeof(int32_t));
  count = 0;
  for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      if(vm_gate->state == STATE_PERMIT)
        {
          vm = (vm_t*)vm_gate->body;
          writebuf_copy(writebuf, &vm_id, sizeof(int32_t));
          count++;
          
          for(page_id = 0; page_id < vm->page_num; page_id++)
            {
              page = vm->page_table[page_id];
              
              pthread_mutex_lock(&page->mutex);
              
              writebuf_copy(writebuf, &page->owner_id, sizeof(int32_t));
              
              pthread_mutex_unlock(&page->mutex);
            }
        }
    }
  writebuf_seekcopy(writebuf, offset, &count, sizeof(int32_t));
  
  token = context->dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_FREE_PEER;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_owner_id(send_packet) = token->owner_id;
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  
  pthread_mutex_unlock(&token->mutex);
  
  writebuf_free(writebuf);
  return;
}

void dmi_handle_req_free_peer(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  peer_t *peer;
  vm_t *vm;
  page_t *page;
  token_t *token;
  account_t *account;
  gate_t *peer_gate, *vm_gate;
  readbuf_t *readbuf;
  int32_t vm_id, vm_num, i, owner_id;
  int64_t page_id;
  
  peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, recv_packet->src_dmi_id);
  peer = (peer_t*)peer_gate->body;
  peer_gate->body = NULL;
  
  peer_free(peer);
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  
  readbuf_copy(readbuf, &vm_num, sizeof(int32_t));
  for(i = 0; i < vm_num; i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
      vm = (vm_t*)vm_gate->body;
      
      for(page_id = 0; page_id < vm->page_num; page_id++)
        {
          page = vm->page_table[page_id];
          
          readbuf_copy(readbuf, &owner_id, sizeof(int32_t));
          
          pthread_mutex_lock(&page->mutex);
          
          if(page->owner_id == recv_packet->src_dmi_id)
            {
              page->owner_id = owner_id;
            }
          
          account = (account_t*)vector_at(page->account_vector, recv_packet->src_dmi_id);
          if(account != NULL)
            {
              account_free(account);
              
              vector_assign(page->account_vector, recv_packet->src_dmi_id, NULL);
            }
          
          pthread_mutex_unlock(&page->mutex);
        }
    }
  
  readbuf_free(readbuf);
  
  token = dmi->token;
  
  pthread_mutex_lock(&token->mutex);
  
  if(token->owner_id == recv_packet->src_dmi_id)
    {
      token->owner_id = packet_owner_id(recv_packet);
    }
  
  pthread_mutex_unlock(&token->mutex);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_FREE_PEER;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_ack_free_peer(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_free_peer_post(context);
  return;
}

void context_free_peer_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_bye_world_pre(context);
    }
  return;
}

void context_bye_world_pre(context_t *context)
{
  packet_t *send_packet, *recv_packet;
  peer_t *peer;
  vm_t *vm;
  gate_t *peer_gate, *vm_gate;
  char ip[IP_SIZE];
  int temporal_sock;
  int16_t port;
  int32_t dmi_id, peer_gate_num, vm_id, vm_gate_num, ret;
  
  peer_gate_num = xvector_size(context->dmi->peer_gate_xvector);
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->state == STATE_PERMIT)
        {
          comm_close(context->dmi->comm, dmi_id);
        }
    }
  
  port = 0;
  peer_gate = NULL;
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->state == STATE_PERMIT)
        {
          peer = (peer_t*)peer_gate->body;
          strncpy(ip, peer->ip, peer->ip_size);
          port = peer->port;
          break;
        }
    }
  if(dmi_id == peer_gate_num) error();
  
  vm_gate_num = xvector_size(context->dmi->vm_gate_xvector);
  for(vm_id = 0; vm_id < vm_gate_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      if(vm_gate->state == STATE_PERMIT)
        {
          vm = (vm_t*)vm_gate->body;
          vm_gate->body = NULL;
          
          dmi_free_pages(context->dmi, vm);
          
          vm_free(vm);
        }
    }
  
  peer_gate_num = xvector_size(context->dmi->peer_gate_xvector);
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(context->dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->state == STATE_PERMIT)
        {
          peer = (peer_t*)peer_gate->body;
          peer_gate->body = NULL;
          
          peer_free(peer);
        }
    }
    
  temporal_sock = sock_connect(ip, port);
  if(temporal_sock < 0) error();
  dmi_id = SYS_ID_UNDEF;
  ret = sock_send(temporal_sock, &dmi_id, sizeof(int32_t));
  if(ret < 0) error();
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_BYE_WORLD;
  send_packet->src_dmi_id = SYS_ID_UNDEF;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  send_packet->sock = temporal_sock;
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  recv_packet = packet_alloc();
  ret = packet_recv(recv_packet, temporal_sock, TYPE_SOCKET);
  if(ret == FALSE) error();
  recv_packet->sock = temporal_sock;
  
  dmi_handle_packet(context->dmi, recv_packet);
  
  packet_free(recv_packet);
  
  sock_close(temporal_sock);
  return;
}

void dmi_handle_req_bye_world(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
  
  new_context->type = CONTEXT_LEAVE_WORLD;
  context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
  context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
  context_sock(new_context) = recv_packet->sock;
  
  context_unlock_token_pre(new_context);
  return;
}

void dmi_handle_ack_bye_world(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_bye_world_post(context);
  return;
}

void context_bye_world_post(context_t *context)
{
  dmi_free_context(context->dmi, context, TRUE);
  return;
}

/* alloc/free vm */

void dmi_mmap_vms(dmi_t *dmi, int64_t *dmi_addrs, int64_t *page_sizes, int64_t *page_nums, int32_t vm_num, status_t *status)
{
  context_t *new_context;
  int32_t i;
  
  if(vm_num == 0)
    {
      status_finish(status, TRUE);
      return;
    }
  else if(vm_num < 0)
    {
      status_finish(status, FALSE);
      return;
    }
  for(i = 0; i < vm_num; i++)
    {
      if(page_sizes[i] < 0 || page_nums[i] < 0)
        {
          status_finish(status, FALSE);
          return;
        }
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_ALLOC_VMS;
  context_dmi_addrs(new_context) = dmi_addrs;
  context_page_sizes(new_context) = page_sizes;
  context_page_nums(new_context) = page_nums;
  context_vm_num(new_context) = vm_num;
  context_ret_flag(new_context) = TRUE;
  context_object_flag(new_context) = FALSE;
  new_context->buf = (int8_t*)my_malloc(context_vm_num(new_context) * sizeof(int32_t));
  context_vm_ids(new_context) = (int32_t*)new_context->buf;
  
  context_lock_token_pre(new_context);
  return;
}

void context_alloc_vms_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t vm_id, vm_num, vm_gate_num, i, count;
  
  count = 0;
  vm_num = context_vm_num(context);
  vm_gate_num = xvector_size(context->dmi->vm_gate_xvector);
  for(vm_id = 0; vm_id < vm_gate_num && count < vm_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, vm_id);
      if(vm_gate->state == STATE_FORBID)
        {
          context_vm_ids(context)[count++] = vm_id;
        }
    }
  while(count < vm_num)
    {
      context_vm_ids(context)[count++] = vm_id;
      vm_id++;
    }
  
  for(i = 0; i < vm_num; i++)
    {
      if(context_object_flag(context) == FALSE)
        {
          context_dmi_addrs(context)[i] = SYS_ADDR_BUILD(context_vm_ids(context)[i], 0);
        }
    }
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  for(i = 0; i < vm_num; i++)
    {
      if(context_object_flag(context) == TRUE)
        {
          writebuf_copy(writebuf, &context_vm_ids(context)[i], sizeof(int32_t));
          writebuf_copy(writebuf, &context_page_sizes(context)[i], sizeof(int64_t));
        }
      else
        {
          writebuf_copy(writebuf, &context_vm_ids(context)[i], sizeof(int32_t));
          writebuf_copy(writebuf, &context_page_sizes(context)[i], sizeof(int64_t));
          writebuf_copy(writebuf, &context_page_nums(context)[i], sizeof(int64_t));
        }
    }
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_ALLOC_VMS;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_vm_num(send_packet) = context_vm_num(context);
  packet_object_flag(send_packet) = context_object_flag(context);
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  
  writebuf_free(writebuf);
  return;
}

void dmi_handle_req_alloc_vms(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  gate_t *vm_gate, *peer_gate;
  vm_t *vm;
  readbuf_t *readbuf;
  int32_t i, j, vm_id, peer_gate_num, dmi_num, dmi_id;
  int32_t *dmi_ids;
  int64_t page_size, page_num;
  
  peer_gate_num = xvector_size(dmi->peer_gate_xvector);
  
  dmi_ids = (int32_t*)my_malloc(peer_gate_num * sizeof(int32_t));
  
  dmi_num = 0;
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->body != NULL)
        {
          dmi_ids[dmi_num] = dmi_id;
          dmi_num++;
        }
    }
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  
  for(i = 0; i < packet_vm_num(recv_packet); i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      
      for(j = xvector_size(dmi->vm_gate_xvector); j <= vm_id; j++)
        {
          vm_gate = gate_alloc();
          xvector_push(dmi->vm_gate_xvector, vm_gate);
        }
      
      if(packet_object_flag(recv_packet) == TRUE)
        {
          readbuf_copy(readbuf, &page_size, sizeof(int64_t));
          
          vm = vm_alloc();
          vm->page_size = -1;
          vm->page_num = 1;
          
          vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
          vm_gate->body = vm;
          
          dmi_alloc_pages(dmi, vm, dmi_ids, dmi_num, page_size);
        }
      else
        {
          readbuf_copy(readbuf, &page_size, sizeof(int64_t));
          readbuf_copy(readbuf, &page_num, sizeof(int64_t));
          
          vm = vm_alloc();
          vm->page_size = page_size;
          vm->page_num = page_num;
          
          vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
          vm_gate->body = vm;
          
          dmi_alloc_pages(dmi, vm, dmi_ids, dmi_num, page_size);
        }
    }
  
  readbuf_free(readbuf);
  
  my_free(dmi_ids);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_ALLOC_VMS;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_alloc_pages(dmi_t *dmi, vm_t *vm, int32_t *dmi_ids, int32_t dmi_num, int64_t slide_size)
{
  page_t *page;
  account_t *account;
  int32_t owner_index, owner_id;
  int64_t page_id;
  
  if(dmi_num <= 0) error();
  vm->page_table = (page_t**)my_malloc(vm->page_num * sizeof(page_t*));
  
  owner_index = 0;
  for(page_id = 0; page_id < vm->page_num; page_id++)
    {
      owner_id = dmi_ids[owner_index];
      page = page_alloc();
      if(owner_id == dmi->dmi_id)
        {
          page->state = STATE_DOWNVALID;
          page->slide_size = slide_size;
          page->decor = 0;
          page->stamp = 0;
          page->owner_flag = TRUE;
          page->owner_id = dmi->dmi_id;
          page->valid_num = 1;
          page->buf = NULL;
          page->buf_size = 0;
          
          account = account_alloc();
          account->seq = 0;
          account->state = STATE_DOWNVALID;
          account->stamp = page->stamp++;
          vector_assign(page->account_vector, dmi->dmi_id, account);
        }
      else
        {
          page->state = STATE_INVALID;
          page->slide_size = slide_size;
          page->decor = 0;
          page->owner_flag = FALSE;
          page->owner_id = owner_id;
          page->buf = NULL;
          page->buf_size = 0;
        }
      
      vm->page_table[page_id] = page;
      owner_index = (owner_index + 1) % dmi_num;
    }
  return;
}

void dmi_handle_ack_alloc_vms(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  
  context_alloc_vms_post(context);
  return;
}

void context_alloc_vms_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_permit_vms_pre(context);
    }
  return;
}

void context_permit_vms_pre(context_t *context)
{
  packet_t *send_packet;
  writebuf_t *writebuf;
  int32_t i, vm_id, vm_num;
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  vm_num = context_vm_num(context);
  for(i = 0; i < vm_num; i++)
    {
      vm_id = context_vm_ids(context)[i];
      writebuf_copy(writebuf, &vm_id, sizeof(int32_t));
    }
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_PERMIT_VMS;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_vm_num(send_packet) = context_vm_num(context);
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  
  writebuf_free(writebuf);
  return;
}

void dmi_handle_req_permit_vms(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  gate_t *vm_gate;
  readbuf_t *readbuf;
  int32_t i, vm_id;
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  for(i = 0; i < packet_vm_num(recv_packet); i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
      
      gate_permit(vm_gate);
    }
  readbuf_free(readbuf);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_PERMIT_VMS;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_ack_permit_vms(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  
  context_permit_vms_post(context);
  return;
}

void context_permit_vms_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_unlock_token_pre(context);
    }
  return;
}

void dmi_munmap_vms(dmi_t *dmi, int64_t *dmi_addrs, int32_t vm_num, status_t *status)
{
  context_t *new_context;
  int32_t i;
  
  if(vm_num == 0)
    {
      status_finish(status, TRUE);
      return;
    }
  else if(vm_num < 0)
    {
      status_finish(status, FALSE);
      return;
    }
  for(i = 0; i < vm_num; i++)
    {
      if(SYS_ADDR_OFFSET_PART(dmi_addrs[i]) != 0)
        {
          status_finish(status, FALSE);
          return;
        }
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_FREE_VMS;
  context_vm_num(new_context) = vm_num;
  context_ret_flag(new_context) = TRUE;
  context_object_flag(new_context) = FALSE;
  new_context->buf = (int8_t*)my_malloc(context_vm_num(new_context) * sizeof(int32_t));
  context_vm_ids(new_context) = (int32_t*)new_context->buf;
  for(i = 0; i < vm_num; i++)
    {
      context_vm_ids(new_context)[i] = SYS_ADDR_VM_PART(dmi_addrs[i]);
    }
  
  context_lock_token_pre(new_context);
  return;
}

void context_forbid_vms_pre(context_t *context)
{
  packet_t *send_packet;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t i, vm_num;
  
  vm_num = context_vm_num(context);
  for(i = 0; i < vm_num; i++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_ids(context)[i]);
      if(vm_gate == NULL || vm_gate->state == STATE_FORBID)
        {
          context_ret_flag(context) = FALSE;
          
          context_unlock_token_post(context);
          return;
        }
    }
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  for(i = 0; i < vm_num; i++)
    {
      writebuf_copy(writebuf, &context_vm_ids(context)[i], sizeof(int32_t));
    }
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_FORBID_VMS;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_vm_num(send_packet) = context_vm_num(context);
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  
  writebuf_free(writebuf);
  return;
}

void dmi_handle_req_forbid_vms(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *new_context;
  readbuf_t *readbuf;
  int32_t i, vm_id;
  
  new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
  
  new_context->type = CONTEXT_FREE_VMS;
  context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
  context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
  context_vm_num(new_context) = packet_vm_num(recv_packet);
  new_context->buf = (int8_t*)my_malloc(context_vm_num(new_context) * sizeof(int32_t));
  context_vm_ids(new_context) = (int32_t*)new_context->buf;
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  for(i = 0; i < packet_vm_num(recv_packet); i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      context_vm_ids(new_context)[i] = vm_id;
    }
  readbuf_free(readbuf);
  
  context_count(new_context) = 0;
  context_total(new_context) = context_vm_num(new_context);
  
  context_close_vms_pre(new_context);
  return;
}

void context_close_vms_pre(context_t *context)
{
  gate_t *vm_gate;
  int32_t i, vm_num;
  
  vm_num = context_vm_num(context);
  for(i = 0; i < vm_num; i++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_ids(context)[i]);
      
      gate_forbid(vm_gate, context, context_close_vms_post);
    }
  return;
}

void context_close_vms_post(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  gate_t *vm_gate;
  int32_t i, vm_num;
  
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      switch(context->type)
        {
        case CONTEXT_FREE_VMS:
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_FORBID_VMS;
          send_packet->src_dmi_id = context->dmi->dmi_id;
          send_packet->context_id = context_parent_dmi_context(context).context_id;
          send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          dmi_send_packet(context->dmi, send_packet);
          packet_free(send_packet);
          
          dmi_free_context(context->dmi, context, TRUE);
          break;
        case CONTEXT_LEAVE_WORLD:
          vm_num = context_vm_num(context);
          for(i = 0; i < vm_num; i++)
            {
              vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_ids(context)[i]);
              vm = (vm_t*)vm_gate->body;
              vm_gate->body = NULL;
              
              dmi_free_pages(context->dmi, vm);
              
              vm_free(vm);
            }
          
          dmi_free_context(context->dmi, context, TRUE);
          break;
        default:
          error();
        }
    }
  return;
}

void dmi_handle_ack_forbid_vms(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  
  context_forbid_vms_post(context);
  return;
}

void context_forbid_vms_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_free_vms_pre(context);
    }
  return;
}

void context_free_vms_pre(context_t *context)
{
  packet_t *send_packet;
  writebuf_t *writebuf;
  int32_t i, vm_num;
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  vm_num = context_vm_num(context);
  for(i = 0; i < vm_num; i++)
    {
      writebuf_copy(writebuf, &context_vm_ids(context)[i], sizeof(int32_t));
    }
  
  context_count(context) = 0;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_FREE_VMS;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = SYS_ID_UNDEF;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  packet_vm_num(send_packet) = context_vm_num(context);
  dmi_bcast_packet(context->dmi, send_packet, &context_total(context));
  packet_free(send_packet);
  
  writebuf_free(writebuf);
  return;
}

void dmi_handle_req_free_vms(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  gate_t *vm_gate;
  vm_t *vm;
  readbuf_t *readbuf;
  int32_t i, vm_id;
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  for(i = 0; i < packet_vm_num(recv_packet); i++)
    {
      readbuf_copy(readbuf, &vm_id, sizeof(int32_t));
      
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
      vm = (vm_t*)vm_gate->body;
      vm_gate->body = NULL;
      
      dmi_free_pages(dmi, vm);
      
      vm_free(vm);
    }
  
  readbuf_free(readbuf);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_FREE_VMS;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_free_pages(dmi_t *dmi, vm_t *vm)
{
  page_t *page;
  account_t *account;
  int32_t dmi_id, account_num;
  int64_t page_id;
  
  for(page_id = 0; page_id < vm->page_num; page_id++)
    {
      page = vm->page_table[page_id];
      
      page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, 0);
      
      account_num = vector_size(page->account_vector);
      for(dmi_id = 0; dmi_id < account_num; dmi_id++)
        {
          account = (account_t*)vector_at(page->account_vector, dmi_id);
          if(account != NULL)
            {
              account_free(account);
            }
        }
      page_free(page);
    }
  my_free(vm->page_table);
  return;
}

void dmi_handle_ack_free_vms(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_free_vms_post(context);
  return;
}

void context_free_vms_post(context_t *context)
{
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      context_unlock_token_pre(context);
    }
  return;
}

/* read/write/gread/gwrite/atomic/decorate pages */

int32_t dmi_init_group(dmi_t *dmi, group_t *group, int64_t *addrs, int64_t *ptr_offsets, int64_t *sizes, int32_t group_num)
{
  vm_t *vm;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int64_t dmi_addr;
  range_t range;
  range_t *ranges;
  int32_t ret, i, j, vm_num, old_vm_id, range_num;
  int32_t *vm_ids;
  int64_t ptr_offset, page_offset, page_id, old_page_id, uoffset, 
    init_page_id, final_page_id, copy_size, tmp;
#if DEBUG_OPTIMIZATION
  int32_t k;
  int64_t *p;
#else
#endif
  
  if(group_num < 0)
    {
      return FALSE;
    }
  
  vm_ids = (int32_t*)my_malloc(group_num * sizeof(int32_t));
  for(i = 0; i < group_num; i++)
    {
      vm_ids[i] = SYS_ADDR_VM_PART(addrs[i]);
    }
  
  sub_fastsort_vmids(group_num, vm_ids);
  
  vm_num = 0;
  old_vm_id = SYS_ID_UNDEF;
  for(i = 0; i < group_num; i++)
    {
      if(old_vm_id != vm_ids[i])
        {
          vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_ids[i]);
          ret = gate_enter(vm_gate);
          if(ret == FALSE)
            {
              for(j = 0; j < vm_num; j++)
                {
                  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_ids[j]);
                  gate_escape(vm_gate);
                }
              fprintf(stderr, "error: vm_id=%d\n", vm_ids[i]);
              return FALSE;
            }
          vm_ids[vm_num] = vm_ids[i];
          vm_num++;
        }
      old_vm_id = vm_ids[i];
    }
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  range_num = 0;
  for(i = 0; i < group_num; i++)
    {
      dmi_addr = addrs[i];
      
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, SYS_ADDR_VM_PART(dmi_addr));
      vm = (vm_t*)vm_gate->body;
      
      if(!(0 <= SYS_ADDR_OFFSET_PART(dmi_addr)
           && SYS_ADDR_OFFSET_PART(dmi_addr) + sizes[i] <= vm->page_num * vm->page_size) 
         || sizes[i] < 0)
        {
          for(j = 0; j < vm_num; j++)
            {
              vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_ids[j]);
              gate_escape(vm_gate);
            }
          fprintf(stderr, "error: vm_id=%d offset=%ld size=%ld page_num=%ld page_size=%ld\n", SYS_ADDR_VM_PART(dmi_addr), SYS_ADDR_OFFSET_PART(dmi_addr), sizes[i], vm->page_num, vm->page_size);
          return FALSE;
        }
      
      init_page_id = SYS_ADDR_OFFSET_PART(dmi_addr) / vm->page_size;
      final_page_id = (SYS_ADDR_OFFSET_PART(dmi_addr) + sizes[i] - 1) / vm->page_size;
      if(sizes[i] == 0)
        {
          final_page_id = init_page_id;
        }
      
      ptr_offset = 0;
      for(page_id = init_page_id; page_id <= final_page_id; page_id++)
        {
          if(page_id == init_page_id)
            {
              page_offset = SYS_ADDR_OFFSET_PART(dmi_addr) % vm->page_size;
              tmp = vm->page_size - page_offset;
              copy_size = sizes[i] < tmp ? sizes[i] : tmp;
            }
          else if(page_id == final_page_id)
            {
              page_offset = 0;
              copy_size = (SYS_ADDR_OFFSET_PART(dmi_addr) + sizes[i] - 1) % vm->page_size + 1;
            }
          else
            {
              page_offset = 0;
              copy_size = vm->page_size;
            }
          
          range.vm_id = SYS_ADDR_VM_PART(dmi_addr);
          range.page_id = page_id;
          range.ptr_offset = ptr_offsets[i] + ptr_offset;
          range.page_offset = page_offset;
          range.copy_size = copy_size;
          writebuf_copy(writebuf, &range, sizeof(range_t));
          range_num++;
          
          ptr_offset += copy_size;
        }
    }
  
  ranges = (range_t*)writebuf_buf(writebuf);
  
  sub_fastsort_ranges(range_num, ranges);
  
  group->total = -1;
  old_vm_id = SYS_ID_UNDEF;
  old_page_id = SYS_ID_UNDEF;
  for(i = 0; i < range_num; i++)
    {
      if((old_vm_id == SYS_ID_UNDEF && old_page_id == SYS_ID_UNDEF)
         || !(old_vm_id == ranges[i].vm_id && old_page_id == ranges[i].page_id))
        {
          group->total++;
        }
      old_vm_id = ranges[i].vm_id;
      old_page_id = ranges[i].page_id;
    }
  group->total++;
  
  group->tls_size = SYS_PAGESIZE_ALIGN_CEIL(group->total * sizeof(int32_t) * 2 + group->total * sizeof(int64_t) + range_num * sizeof(int64_t) * 3);
  group->tls_buf = (int8_t*)dmi_mmap_tls(dmi, NULL, group->tls_size, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
  if(group->tls_buf == MAP_FAILED) error();
  
  uoffset = 0;
  group->set_nums = (int32_t*)(group->tls_buf + uoffset);
  uoffset += group->total * sizeof(int32_t);
  group->vm_ids = (int32_t*)(group->tls_buf + uoffset);
  uoffset += group->total * sizeof(int32_t);
  group->page_ids = (int64_t*)(group->tls_buf + uoffset);
  uoffset += group->total * sizeof(int64_t);
#if DEBUG_OPTIMIZATION
  group->ptr_offsets = (int64_t*)(group->tls_buf + uoffset);
  uoffset += range_num * 3 * sizeof(int64_t);
#else
  group->ptr_offsets = (int64_t*)(group->tls_buf + uoffset);
  uoffset += range_num * sizeof(int64_t);
  group->page_offsets = (int64_t*)(group->tls_buf + uoffset);
  uoffset += range_num * sizeof(int64_t);
  group->copy_sizes = (int64_t*)(group->tls_buf + uoffset);
  uoffset += range_num * sizeof(int64_t);
#endif
  
#if DEBUG_OPTIMIZATION
  j = -1;
  old_vm_id = SYS_ID_UNDEF;
  old_page_id = SYS_ID_UNDEF;
  for(i = 0; i < range_num; i++)
    {
      if((old_vm_id == SYS_ID_UNDEF && old_page_id == SYS_ID_UNDEF)
         || !(old_vm_id == ranges[i].vm_id && old_page_id == ranges[i].page_id))
        {
          j++;
          group->set_nums[j] = 0;
          group->vm_ids[j] = ranges[i].vm_id;
          group->page_ids[j] = ranges[i].page_id;
        }
      group->set_nums[j]++;
      old_vm_id = ranges[i].vm_id;
      old_page_id = ranges[i].page_id;
    }
  j++;
  if(j != group->total) error();
  
  k = 0;
  p = group->ptr_offsets;
  for(i = 0; i < group->total; i++)
    {
      for(j = 0; j < group->set_nums[i]; j++)
        {
          p[j] = ranges[k].ptr_offset;
          p[j + group->set_nums[i]] = ranges[k].page_offset;
          p[j + group->set_nums[i] * 2] = ranges[k].copy_size;
          k++;
        }
      p += group->set_nums[i] * 3;
    }
  if(k != range_num) error();
  if(group->total > 0)
    {
      group->page_offsets = group->ptr_offsets + group->set_nums[0];
      group->copy_sizes = group->ptr_offsets + group->set_nums[0] * 2;
    }
  else
    {
      group->page_offsets = group->ptr_offsets;
      group->copy_sizes = group->ptr_offsets;
    }
#else
  j = -1;
  old_vm_id = SYS_ID_UNDEF;
  old_page_id = SYS_ID_UNDEF;
  for(i = 0; i < range_num; i++)
    {
      if((old_vm_id == SYS_ID_UNDEF && old_page_id == SYS_ID_UNDEF)
         || !(old_vm_id == ranges[i].vm_id && old_page_id == ranges[i].page_id))
        {
          j++;
          group->set_nums[j] = 0;
          group->vm_ids[j] = ranges[i].vm_id;
          group->page_ids[j] = ranges[i].page_id;
        }
      group->set_nums[j]++;
      old_vm_id = ranges[i].vm_id;
      old_page_id = ranges[i].page_id;
      group->ptr_offsets[i] = ranges[i].ptr_offset;
      group->page_offsets[i] = ranges[i].page_offset;
      group->copy_sizes[i] = ranges[i].copy_size;
    }
  j++;
  if(j != group->total) error();
#endif

  group->vm_num = vm_num;
  
  writebuf_free(writebuf);
  
  for(i = 0; i < vm_num; i++)
    {
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_ids[i]);
      gate_escape(vm_gate);
    }
  
  my_free(vm_ids);
  return TRUE;
}

void sub_fastsort_vmids(int32_t n, int32_t *vm_ids)
{
  int32_t pivot, tmp;
  int32_t i, j, left, right, p;
  int32_t lstack[32], rstack[32];
  
  left = 0;
  right = n - 1;
  p = 0;
  while(1)
    {
      if(right - left <= CONST_FASTSORT_THRESHOLD)
        {
          if(p == 0) break;
          p--;
          left = lstack[p];
          right = rstack[p];
        }
      pivot = vm_ids[(left + right) / 2];
      i = left;
      j = right;
      while(1)
        {
          while(vm_ids[i] < pivot)
            {
              i++;
            }
          while(vm_ids[j] > pivot)
            {
              j--;
            }
          if(i >= j) break;
          tmp = vm_ids[i];
          vm_ids[i] = vm_ids[j];
          vm_ids[j] = tmp;
          i++;
          j--;
        }
      if(i - left > right - j)
        {
          if(i - left > CONST_FASTSORT_THRESHOLD)
            {
              lstack[p] = left;
              rstack[p] = i - 1;
              p++;
            }
          left = j + 1;
        }
      else
        {
          if(right - j > CONST_FASTSORT_THRESHOLD)
            {
              lstack[p] = j + 1;
              rstack[p] = right;
              p++;
            }
          right = i - 1;
        }
    }
  
  for(i = 0; i < n; i++)
    {
      tmp = vm_ids[i];
      for(j = i; j > 0
            && vm_ids[j - 1] > tmp; j--)
        {
          vm_ids[j] = vm_ids[j - 1];
        }
      vm_ids[j] = tmp;
    }
  return;
}

void sub_fastsort_ranges(int32_t n, range_t *ranges)
{
  range_t pivot, tmp;
  int32_t i, j, left, right, p;
  int32_t lstack[32], rstack[32];
  
  left = 0;
  right = n - 1;
  p = 0;
  while(1)
    {
      if(right - left <= CONST_FASTSORT_THRESHOLD)
        {
          if(p == 0) break;
          p--;
          left = lstack[p];
          right = rstack[p];
        }
      pivot = ranges[(left + right) / 2];
      i = left;
      j = right;
      while(1)
        {
          while(ranges[i].vm_id < pivot.vm_id
                || (ranges[i].vm_id == pivot.vm_id 
                    && ranges[i].page_id < pivot.page_id))
            {
              i++;
            }
          while(ranges[j].vm_id > pivot.vm_id
                || (ranges[j].vm_id == pivot.vm_id 
                    && ranges[j].page_id > pivot.page_id))
            {
              j--;
            }
          if(i >= j) break;
          tmp = ranges[i];
          ranges[i] = ranges[j];
          ranges[j] = tmp;
          i++;
          j--;
        }
      if(i - left > right - j)
        {
          if(i - left > CONST_FASTSORT_THRESHOLD)
            {
              lstack[p] = left;
              rstack[p] = i - 1;
              p++;
            }
          left = j + 1;
        }
      else
        {
          if(right - j > CONST_FASTSORT_THRESHOLD)
            {
              lstack[p] = j + 1;
              rstack[p] = right;
              p++;
            }
          right = i - 1;
        }
    }
  
  for(i = 0; i < n; i++)
    {
      tmp = ranges[i];
      for(j = i; j > 0
            && (ranges[j - 1].vm_id > tmp.vm_id
                || (ranges[j - 1].vm_id == tmp.vm_id 
                    && ranges[j - 1].page_id > tmp.page_id)); j--)
        {
          ranges[j] = ranges[j - 1];
        }
      ranges[j] = tmp;
    }
  return;
}

int32_t dmi_destroy_group(dmi_t *dmi, group_t *group)
{
  int32_t ret;
  
  ret = dmi_munmap_tls(dmi, group->tls_buf, group->tls_size);
  if(ret < 0) return FALSE;
  return TRUE;
}

void dmi_read_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *in_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_ONCE || access_type == ACCESS_INVALIDATE || access_type == ACCESS_UPDATE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_READ_PAGES;
  context_dmi_addr(new_context) = dmi_addr;
  context_size(new_context) = size;
  context_in_ptr(new_context) = (int8_t*)in_ptr;
  switch(access_type)
    {
    case ACCESS_ONCE:
      context_access_type(new_context) = ACCESS_ONCE_READ;
      break;
    case ACCESS_INVALIDATE:
      context_access_type(new_context) = ACCESS_INVALIDATE_READ;
      break;
    case ACCESS_UPDATE:
      context_access_type(new_context) = ACCESS_UPDATE_READ;
      break;
    default:
      error();
    }
  
  context_access_pages_pre(new_context);
  return;
}

void dmi_gread_addr(dmi_t *dmi, group_t *group, void *in_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_ONCE || access_type == ACCESS_INVALIDATE || access_type == ACCESS_UPDATE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_GREAD_PAGES;
  context_in_ptr(new_context) = (int8_t*)in_ptr;
  context_vm_num(new_context) = group->vm_num;
  context_vm_ids(new_context) = group->vm_ids;
  context_page_ids(new_context) = group->page_ids;
  context_ptr_offsets(new_context) = group->ptr_offsets;
  context_page_offsets(new_context) = group->page_offsets;
  context_copy_sizes(new_context) = group->copy_sizes;
  context_set_nums(new_context) = group->set_nums;
  context_total(new_context) = group->total;
  switch(access_type)
    {
    case ACCESS_ONCE:
      context_access_type(new_context) = ACCESS_ONCE_GREAD;
      break;
    case ACCESS_INVALIDATE:
      context_access_type(new_context) = ACCESS_INVALIDATE_GREAD;
      break;
    case ACCESS_UPDATE:
      context_access_type(new_context) = ACCESS_UPDATE_GREAD;
      break;
    default:
      error();
    }
  
  context_gaccess_pages_pre(new_context);
  return;
}

void dmi_write_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *out_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_EXCLUDE_PAGES;
  context_dmi_addr(new_context) = dmi_addr;
  context_size(new_context) = size;
  context_out_ptr(new_context) = (int8_t*)out_ptr;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_WRITE;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_WRITE;
      break;
    default:
      error();
    }
  
  context_access_pages_pre(new_context);
  return;
}

void dmi_gwrite_addr(dmi_t *dmi, group_t *group, void *out_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_GEXCLUDE_PAGES;
  context_out_ptr(new_context) = (int8_t*)out_ptr;
  context_vm_num(new_context) = group->vm_num;
  context_vm_ids(new_context) = group->vm_ids;
  context_page_ids(new_context) = group->page_ids;
  context_ptr_offsets(new_context) = group->ptr_offsets;
  context_page_offsets(new_context) = group->page_offsets;
  context_copy_sizes(new_context) = group->copy_sizes;
  context_set_nums(new_context) = group->set_nums;
  context_total(new_context) = group->total;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_GWRITE;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_GWRITE;
      break;
    default:
      error();
    }
  
  context_gaccess_pages_pre(new_context);
  return;
}

void dmi_watch_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *in_ptr, void *out_ptr, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_WATCH_PAGE;
  context_dmi_addr(new_context) = dmi_addr;
  context_copy_size(new_context) = size;
  context_in_ptr(new_context) = in_ptr;
  context_out_ptr(new_context) = out_ptr;
  context_access_type(new_context) = ACCESS_UPDATE_READ;
  context_watch_flag(new_context) = FALSE;
  
  context_access_page_pre(new_context);
  return;
}

void dmi_atomic_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, void *out_ptr, int64_t out_size, void *in_ptr, int64_t in_size, int8_t tag, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_EXCLUDE_PAGE;
  context_dmi_addr(new_context) = dmi_addr;
  context_copy_size(new_context) = size;
  context_out_size(new_context) = out_size;
  context_out_ptr(new_context) = out_ptr;
  context_in_size(new_context) = in_size;
  context_in_ptr(new_context) = in_ptr;
  context_tag(new_context) = tag;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_ATOMIC;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_ATOMIC;
      break;
    default:
      error();
    }
  
  context_access_page_pre(new_context);
  return;
}

int32_t dmi_decorate_addr(dmi_t *dmi, int64_t dmi_addr, int64_t size, int8_t decor)
{
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t ret;
  int64_t page_id, init_page_id, final_page_id;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, SYS_ADDR_VM_PART(dmi_addr));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      return FALSE;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(!(0 <= SYS_ADDR_OFFSET_PART(dmi_addr)
       && SYS_ADDR_OFFSET_PART(dmi_addr) + size <= vm->page_num * vm->page_size)
     || !(size >= 0 || size == SYS_FULL_PAGE_SIZE))
    {
      gate_escape(vm_gate);
      return FALSE;
    }
  
  init_page_id = SYS_ADDR_OFFSET_PART(dmi_addr) / vm->page_size;
  final_page_id = SYS_ADDR_OFFSET_PART(dmi_addr) + size - 1 / vm->page_size;
  if(size == 0)
    {
      final_page_id = init_page_id;
    }
  
  for(page_id = init_page_id; page_id <= final_page_id; page_id++)
    {
      page = vm->page_table[page_id];
      
      pthread_mutex_lock(&page->mutex);
      
      page->decor = decor;
      
      pthread_mutex_unlock(&page->mutex);
    }
  
  gate_escape(vm_gate);
  return TRUE;
}

void dmi_new_object(dmi_t *dmi, int32_t *object_ids, int64_t *slide_sizes, int32_t object_num, status_t *status)
{
  context_t *new_context;
  int32_t i;
  
  if(object_num == 0)
    {
      status_finish(status, TRUE);
      return;
    }
  else if(object_num < 0)
    {
      status_finish(status, FALSE);
      return;
    }
  for(i = 0; i < object_num; i++)
    {
      if(slide_sizes[i] < 0)
        {
          status_finish(status, FALSE);
          return;
        }
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_ALLOC_VMS;
  context_page_sizes(new_context) = slide_sizes;
  context_vm_num(new_context) = object_num;
  context_ret_flag(new_context) = TRUE;
  context_object_flag(new_context) = TRUE;
  context_vm_ids(new_context) = object_ids;
  
  context_lock_token_pre(new_context);
  return;
}

void dmi_delete_object(dmi_t *dmi, int32_t *object_ids, int32_t object_num, status_t *status)
{
  context_t *new_context;
  
  if(object_num == 0)
    {
      status_finish(status, TRUE);
      return;
    }
  else if(object_num < 0)
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_FREE_VMS;
  context_vm_num(new_context) = object_num;
  context_ret_flag(new_context) = TRUE;
  context_object_flag(new_context) = TRUE;
  context_vm_ids(new_context) = object_ids;
  
  context_lock_token_pre(new_context);
  return;
}

void dmi_read_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *in_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_ONCE || access_type == ACCESS_INVALIDATE || access_type == ACCESS_UPDATE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_READ_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = object_offset;
  context_copy_size(new_context) = size;
  context_in_ptr(new_context) = (int8_t*)in_ptr;
  switch(access_type)
    {
    case ACCESS_ONCE:
      context_access_type(new_context) = ACCESS_ONCE_READ;
      break;
    case ACCESS_INVALIDATE:
      context_access_type(new_context) = ACCESS_INVALIDATE_READ;
      break;
    case ACCESS_UPDATE:
      context_access_type(new_context) = ACCESS_UPDATE_READ;
      break;
    default:
      error();
    }
  
  context_access_object_pre(new_context);
  return;
}

void dmi_write_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *out_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_EXCLUDE_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = object_offset;
  context_copy_size(new_context) = size;
  context_out_ptr(new_context) = (int8_t*)out_ptr;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_WRITE;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_WRITE;
      break;
    default:
      error();
    }
  
  context_access_object_pre(new_context);
  return;
}

void dmi_gread_object(dmi_t *dmi, int32_t object_id, int64_t *object_offsets, int64_t *sizes, int64_t *ptr_offsets, int32_t group_num, void *in_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_ONCE || access_type == ACCESS_INVALIDATE || access_type == ACCESS_UPDATE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_GREAD_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_copy_sizes(new_context) = sizes;
  context_page_offsets(new_context) = object_offsets;
  context_ptr_offsets(new_context) = ptr_offsets;
  context_in_ptr(new_context) = (int8_t*)in_ptr;
  context_set_num(new_context) = group_num;
  switch(access_type)
    {
    case ACCESS_ONCE:
      context_access_type(new_context) = ACCESS_ONCE_GREAD;
      break;
    case ACCESS_INVALIDATE:
      context_access_type(new_context) = ACCESS_INVALIDATE_GREAD;
      break;
    case ACCESS_UPDATE:
      context_access_type(new_context) = ACCESS_UPDATE_GREAD;
      break;
    default:
      error();
    }
  
  context_gaccess_object_pre(new_context);
  return;
}

void dmi_gwrite_object(dmi_t *dmi, int32_t object_id, int64_t *object_offsets, int64_t *sizes, int64_t *ptr_offsets, int32_t group_num, void *out_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_GEXCLUDE_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_copy_sizes(new_context) = sizes;
  context_page_offsets(new_context) = object_offsets;
  context_ptr_offsets(new_context) = ptr_offsets;
  context_out_ptr(new_context) = (int8_t*)out_ptr;
  context_set_num(new_context) = group_num;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_GWRITE;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_GWRITE;
      break;
    default:
      error();
    }
  
  context_gaccess_object_pre(new_context);
  return;
}

void dmi_atomic_object(dmi_t *dmi, int32_t object_id, void *out_ptr, int64_t out_size, void *in_ptr, int64_t in_size, int8_t tag, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_EXCLUDE_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = 0;
  context_copy_size(new_context) = SYS_FULL_PAGE_SIZE;
  context_out_size(new_context) = out_size;
  context_out_ptr(new_context) = out_ptr;
  context_in_size(new_context) = in_size;
  context_in_ptr(new_context) = in_ptr;
  context_tag(new_context) = tag;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_ATOMIC;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_ATOMIC;
      break;
    default:
      error();
    }
  
  context_access_object_pre(new_context);
  return;
}

void dmi_watch_object(dmi_t *dmi, int32_t object_id, int64_t object_offset, int64_t size, void *in_ptr, void *out_ptr, status_t *status)
{
  context_t *new_context;
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_WATCH_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = object_offset;
  context_copy_size(new_context) = size;
  context_in_ptr(new_context) = in_ptr;
  context_out_ptr(new_context) = out_ptr;
  context_access_type(new_context) = ACCESS_UPDATE_READ;
  context_watch_flag(new_context) = FALSE;
  
  context_access_object_pre(new_context);
  return;
}

void dmi_getsize_object(dmi_t *dmi, int32_t object_id, int64_t *slide_size_ptr, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_ONCE || access_type == ACCESS_INVALIDATE || access_type == ACCESS_UPDATE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_READ_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = 0;
  context_copy_size(new_context) = 0;
  context_in_ptr(new_context) = NULL;
  context_slide_size_ptr(new_context) = slide_size_ptr;
  switch(access_type)
    {
    case ACCESS_ONCE:
      context_access_type(new_context) = ACCESS_ONCE_GETSIZE;
      break;
    case ACCESS_INVALIDATE:
      context_access_type(new_context) = ACCESS_INVALIDATE_GETSIZE;
      break;
    case ACCESS_UPDATE:
      context_access_type(new_context) = ACCESS_UPDATE_GETSIZE;
      break;
    default:
      error();
    }
  
  context_access_object_pre(new_context);
  return;
}

void dmi_setsize_object(dmi_t *dmi, int32_t object_id, int64_t slide_size, int8_t access_type, status_t *status)
{
  context_t *new_context;
  
  if(!(access_type == ACCESS_LOCAL || access_type == ACCESS_REMOTE))
    {
      status_finish(status, FALSE);
      return;
    }
  
  new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
  if(new_context == NULL)
    {
      status_finish(status, FALSE);
      return;
    }
  new_context->type = CONTEXT_EXCLUDE_OBJECT;
  context_vm_id(new_context) = object_id;
  context_page_id(new_context) = 0;
  context_page_offset(new_context) = 0;
  context_copy_size(new_context) = 0;
  context_out_ptr(new_context) = NULL;
  context_slide_size(new_context) = slide_size;
  switch(access_type)
    {
    case ACCESS_LOCAL:
      context_access_type(new_context) = ACCESS_LOCAL_SETSIZE;
      break;
    case ACCESS_REMOTE:
      context_access_type(new_context) = ACCESS_REMOTE_SETSIZE;
      break;
    default:
      error();
    }
  
  context_access_object_pre(new_context);
  return;
}

int32_t dmi_decorate_object(dmi_t *dmi, int32_t object_id, int8_t decor)
{
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t vm_id, ret;
  
  vm_id = object_id;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      return FALSE;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(vm->page_size != -1)
    {
      gate_escape(vm_gate);
      return FALSE;
    }
  if(vm->page_num > 0)
    {
      gate_escape(vm_gate);
      return TRUE;
    }
  page = vm->page_table[0];
  
  pthread_mutex_lock(&page->mutex);
  
  page->decor = decor;
  
  pthread_mutex_unlock(&page->mutex);
  
  gate_escape(vm_gate);
  return TRUE;
}

void context_access_page_pre(context_t *context)
{
  vm_t *vm;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, SYS_ADDR_VM_PART(context_dmi_addr(context)));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(!(0 <= SYS_ADDR_OFFSET_PART(context_dmi_addr(context))
       && SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) + context_copy_size(context)
       <= vm->page_num * vm->page_size)
     || !(context_copy_size(context) >= 0 || context_copy_size(context) == SYS_FULL_PAGE_SIZE))
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  else if(context_copy_size(context) == 0 && vm->page_num * vm->page_size == 0)
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, TRUE);
      return;
    }
  
  context_vm_id(context) = SYS_ADDR_VM_PART(context_dmi_addr(context));
  context_page_id(context) = SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) / vm->page_size;
  context_page_offset(context) = SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) % vm->page_size;
  
  context_ret_flag(context) = TRUE;
  
  switch(context->type)
    {
    case CONTEXT_WATCH_PAGE:
      context_read_page_pre(context);
      break;
    case CONTEXT_EXCLUDE_PAGE:
      context_exclude_page_pre(context);
      break;
    default:
      error();
    }
  return;
}

void context_access_object_pre(context_t *context)
{
  vm_t *vm;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(vm->page_size != -1
     || !(context_copy_size(context) >= 0 || context_copy_size(context) == SYS_FULL_PAGE_SIZE))
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  context_ret_flag(context) = TRUE;
  
  switch(context->type)
    {
    case CONTEXT_READ_OBJECT:
    case CONTEXT_WATCH_OBJECT:
      context_read_page_pre(context);
      break;
    case CONTEXT_EXCLUDE_OBJECT:
      context_exclude_page_pre(context);
      break;
    default:
      error();
    }
  return;
}

void context_access_pages_pre(context_t *context)
{
  context_t *new_context;
  vm_t *vm;
  gate_t *vm_gate;
  int32_t ret;
  int64_t ptr_offset, page_offset, page_id, init_page_id, final_page_id, copy_size, tmp;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, SYS_ADDR_VM_PART(context_dmi_addr(context)));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(!(0 <= SYS_ADDR_OFFSET_PART(context_dmi_addr(context))
       && SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) + context_size(context) <= vm->page_num * vm->page_size) 
     || context_size(context) < 0)
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  else if(context_size(context) == 0 && vm->page_num * vm->page_size == 0)
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, TRUE);
      return;
    }
  
  init_page_id = SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) / vm->page_size;
  final_page_id = (SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) + context_size(context) - 1) / vm->page_size;
  if(context_size(context) == 0)
    {
      final_page_id = init_page_id;
    }
  
  context_count(context) = 0;
  context_total(context) = final_page_id - init_page_id + 1;
  context_ret_flag(context) = TRUE;
  
  ptr_offset = 0;
  for(page_id = init_page_id; page_id <= final_page_id; page_id++)
    {
      if(page_id == init_page_id)
        {
          page_offset = SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) % vm->page_size;
          tmp = vm->page_size - page_offset;
          copy_size = context_size(context) < tmp ? context_size(context) : tmp;
        }
      else if(page_id == final_page_id)
        {
          page_offset = 0;
          copy_size = (SYS_ADDR_OFFSET_PART(context_dmi_addr(context)) + context_size(context) - 1) % vm->page_size + 1;
        }
      else
        {
          page_offset = 0;
          copy_size = vm->page_size;
        }
      
      switch(context->type)
        {
        case CONTEXT_READ_PAGES:
          new_context = dmi_alloc_context(context->dmi, NULL, TYPE_SLAVE);
          new_context->type = CONTEXT_READ_PAGES;
          context_parent_context_id(new_context) = context->context_id;
          context_vm_id(new_context) = SYS_ADDR_VM_PART(context_dmi_addr(context));
          context_page_id(new_context) = page_id;
          context_page_offset(new_context) = page_offset;
          context_copy_size(new_context) = copy_size;
          context_in_ptr(new_context) = context_in_ptr(context) + ptr_offset;
          context_access_type(new_context) = context_access_type(context);
          context_ret_flag(new_context) = TRUE;
          
          context_read_page_pre(new_context);
          break;
        case CONTEXT_EXCLUDE_PAGES:
          new_context = dmi_alloc_context(context->dmi, NULL, TYPE_SLAVE);
          new_context->type = CONTEXT_EXCLUDE_PAGES;
          context_parent_context_id(new_context) = context->context_id;
          context_vm_id(new_context) = SYS_ADDR_VM_PART(context_dmi_addr(context));
          context_page_id(new_context) = page_id;
          context_page_offset(new_context) = page_offset;
          context_copy_size(new_context) = copy_size;
          context_out_ptr(new_context) = context_out_ptr(context) + ptr_offset;
          context_access_type(new_context) = context_access_type(context);
          context_ret_flag(new_context) = TRUE;
          
          context_exclude_page_pre(new_context);
          break;
        default:
          error();
        }
      
      ptr_offset += copy_size;
    }
  return;
}

void context_gaccess_pages_pre(context_t *context)
{
  context_t *new_context;
  gate_t *vm_gate;
  int32_t ret, i, j, total, vm_num, pos;
  
  if(context_total(context) == 0)
    {
      dmi_free_context(context->dmi, context, TRUE);
      return;
    }
  else if(context_total(context) < 0)
    {
      error();
    }
  
  vm_num = context_vm_num(context);
  for(i = 0; i < vm_num; i++)
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_ids(context)[i]);
      ret = gate_enter(vm_gate);
      if(ret == FALSE)
        {
          for(j = 0; j < i; j++)
            {
              vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_ids(context)[j]);
              gate_escape(vm_gate);
            }
          dmi_free_context(context->dmi, context, FALSE);
          return;
        }
    }
  
  total = context_total(context);
  context_count(context) = 0;
  context_ret_flag(context) = TRUE;
  
  pos = 0;
  for(i = 0; i < total; i++)
    {
      new_context = dmi_alloc_context(context->dmi, NULL, TYPE_SLAVE);
      context_parent_context_id(new_context) = context->context_id;
      context_vm_id(new_context) = context_vm_ids(context)[i];
      context_page_id(new_context) = context_page_ids(context)[i];
      context_set_num(new_context) = context_set_nums(context)[i];
      context_access_type(new_context) = context_access_type(context);
#if DEBUG_OPTIMIZATION
      context_ptr_offsets(new_context) = context_ptr_offsets(context) + pos * 3;
      context_page_offsets(new_context) = context_ptr_offsets(context) + pos * 3 + context_set_nums(context)[i];
      context_copy_sizes(new_context) = context_ptr_offsets(context) + pos * 3 + context_set_nums(context)[i] * 2;
#else
      context_ptr_offsets(new_context) = context_ptr_offsets(context) + pos;
      context_page_offsets(new_context) = context_page_offsets(context) + pos;
      context_copy_sizes(new_context) = context_copy_sizes(context) + pos;
#endif
      context_ret_flag(new_context) = TRUE;
      
      pos += context_set_nums(context)[i];
      
      switch(context->type)
        {
        case CONTEXT_GREAD_PAGES:
          new_context->type = CONTEXT_GREAD_PAGES;
          context_in_ptr(new_context) = context_in_ptr(context);
          
          context_read_page_pre(new_context);
          break;
        case CONTEXT_GEXCLUDE_PAGES:
          new_context->type = CONTEXT_GEXCLUDE_PAGES;
          context_out_ptr(new_context) = context_out_ptr(context);
          
          context_exclude_page_pre(new_context);
          break;
        default:
          error();
        }
    }
  return;
}

void context_gaccess_object_pre(context_t *context)
{
  vm_t *vm;
  gate_t *vm_gate;
  int32_t ret, i;
  
  if(context_set_num(context) == 0)
    {
      dmi_free_context(context->dmi, context, TRUE);
      return;
    }
  else if(context_set_num(context) < 0)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  vm = (vm_t*)vm_gate->body;
  
  for(i = 0; i < context_set_num(context); i++)
    {
      if(vm->page_size != -1 || !(context_copy_sizes(context)[i] >= 0))
        {
          gate_escape(vm_gate);
          
          dmi_free_context(context->dmi, context, FALSE);
          return;
        }
    }
  
  context_ret_flag(context) = TRUE;
  
  switch(context->type)
    {
    case CONTEXT_GREAD_OBJECT:
      context_read_page_pre(context);
      break;
    case CONTEXT_GEXCLUDE_OBJECT:
      context_exclude_page_pre(context);
      break;
    default:
      error();
    }
  return;
}

void context_read_page_pre(context_t *context)
{
  context_t *tmp_context;
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int8_t break_flag, hit_flag, error_flag, context_refcount;
  int32_t i, context_num;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(context->type == CONTEXT_WATCH_PAGE || context->type == CONTEXT_WATCH_OBJECT)
    {
      context_num = vector_size(page->context_vector);
      for(i = 0; i < context_num; i++)
        {
          tmp_context = (context_t*)vector_at(page->context_vector, i);
          if(tmp_context == NULL)
            {
              vector_assign(page->context_vector, i, context);
              break;
            }
        }
      if(i == context_num)
        {
          vector_push(page->context_vector, context);
        }
    }
  
  break_flag = FALSE;
  context_refcount(context) = 1;
  while(break_flag == FALSE)
    {
      hit_flag = FALSE;
      
      if(page->state == STATE_INVALID
         || (page->state == STATE_DOWNVALID
             && (context_access_type(context) == ACCESS_UPDATE_READ
                 || context_access_type(context) == ACCESS_UPDATE_GREAD
                 || context_access_type(context) == ACCESS_UPDATE_GETSIZE))
         || (page->state == STATE_UPVALID
             && (context_access_type(context) == ACCESS_INVALIDATE_READ
                 || context_access_type(context) == ACCESS_INVALIDATE_GREAD
                 || context_access_type(context) == ACCESS_INVALIDATE_GETSIZE
                 || context_access_type(context) == ACCESS_ONCE_READ
                 || context_access_type(context) == ACCESS_ONCE_GREAD
                 || context_access_type(context) == ACCESS_ONCE_GETSIZE)))
        {
          context_refcount(context)++;
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_REQ_READ_PAGE;
          send_packet->src_dmi_id = context->dmi->dmi_id;
          send_packet->context_id = context->context_id;
          send_packet->dst_dmi_id = page->owner_id;
          send_packet->page_payload_size = 0;
          packet_vm_id(send_packet) = context_vm_id(context);
          packet_page_id(send_packet) = context_page_id(context);
          packet_access_type(send_packet) = context_access_type(context);
          
          writebuf = NULL;
          switch(context_access_type(context))
            {
            case ACCESS_ONCE_READ:
            case ACCESS_ONCE_GETSIZE:
              send_packet->data_payload_size = 0;
              packet_page_offset(send_packet) = context_page_offset(context);
              packet_copy_size(send_packet) = context_copy_size(context);
              break;
            case ACCESS_ONCE_GREAD:
              packet_set_num(send_packet) = context_set_num(context);
              send_packet->data_payload_size = packet_set_num(send_packet) * 2 * sizeof(int64_t);
#if DEBUG_OPTIMIZATION
              send_packet->data_payload_ptr = (int8_t*)context_page_offsets(context);
#else
              send_packet->data_payload_buf = (int8_t*)my_malloc(send_packet->data_payload_size);
              send_packet->data_payload_ptr = send_packet->data_payload_buf;
              memcpy(send_packet->data_payload_ptr, context_page_offsets(context), packet_set_num(send_packet) * sizeof(int64_t));
              memcpy(send_packet->data_payload_ptr + packet_set_num(send_packet) * sizeof(int64_t), context_copy_sizes(context), packet_set_num(send_packet) * sizeof(int64_t));
#endif
              break;
            case ACCESS_INVALIDATE_READ:
            case ACCESS_INVALIDATE_GREAD:
            case ACCESS_INVALIDATE_GETSIZE:
            case ACCESS_UPDATE_READ:
            case ACCESS_UPDATE_GREAD:
            case ACCESS_UPDATE_GETSIZE:
              send_packet->data_payload_size = 0;
              break;
            default:
              error();
            }
          
          dmi_send_packet(context->dmi, send_packet);
          
          if(writebuf != NULL)
            {
              writebuf_free(writebuf);
            }
          
          packet_free(send_packet);
        }
      else
        {
          hit_flag = TRUE;
          
          page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
          
          error_flag = FALSE;
          switch(context_access_type(context))
            {
            case ACCESS_ONCE_GREAD:
            case ACCESS_INVALIDATE_GREAD:
            case ACCESS_UPDATE_GREAD:
              for(i = 0; i < context_set_num(context); i++)
                {
                  if(!(0 <= context_page_offsets(context)[i]
                       && context_page_offsets(context)[i] + context_copy_sizes(context)[i]
                       <= page->slide_size) || context_copy_sizes(context)[i] < 0)
                    {
                      error_flag = TRUE;
                      break;
                    }
                }
              for(i = 0; i < context_set_num(context); i++)
                {
                  memcpy(context_in_ptr(context) + context_ptr_offsets(context)[i], page->buf + context_page_offsets(context)[i], context_copy_sizes(context)[i]);
                }
              break;
            case ACCESS_ONCE_READ:
            case ACCESS_INVALIDATE_READ:
            case ACCESS_UPDATE_READ:
              if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
                {
                  context_copy_size(context) = page->slide_size - context_page_offset(context);
                }
              if(!(0 <= context_page_offset(context)
                   && context_page_offset(context) + context_copy_size(context)
                   <= page->slide_size) || context_copy_size(context) < 0)
                {
                  error_flag = TRUE;
                  break;
                }
              
              memcpy(context_in_ptr(context), page->buf + context_page_offset(context), context_copy_size(context));
              break;
            case ACCESS_ONCE_GETSIZE:
            case ACCESS_INVALIDATE_GETSIZE:
            case ACCESS_UPDATE_GETSIZE:
              *context_slide_size_ptr(context) = page->slide_size;
              break;
            default:
              error();
            }
          
          sub_notify_watch(page);
          
          if(error_flag == TRUE)
            {
              context_ret_flag(context) = FALSE;
            }
        }
      
      switch(context->type)
        {
        case CONTEXT_WATCH_PAGE:
        case CONTEXT_WATCH_OBJECT:
          while(1)
            {
              pthread_mutex_unlock(&page->mutex);
              
              pthread_mutex_lock(&context->mutex);
              
              while(context_watch_flag(context) == FALSE)
                {
                  pthread_cond_wait(&context->cond, &context->mutex);
                }
              context_watch_flag(context) = FALSE;
              
              pthread_mutex_unlock(&context->mutex);
              
              pthread_mutex_lock(&page->mutex);
              
              if(context_ret_flag(context) == FALSE
                 || ((page->state == STATE_UPVALID || page->state == STATE_DOWNVALID)
                     && memcmp(page->buf + context_page_offset(context), context_out_ptr(context), context_copy_size(context)) != 0))
                {
                  memcpy(context_in_ptr(context), page->buf + context_page_offset(context), context_copy_size(context));
                  break_flag = TRUE;
                  break;
                }
              else
                {
                  if(page->state == STATE_DOWNVALID || page->state == STATE_INVALID)
                    {
                      break;
                    }
                }
            }
          break;
        case CONTEXT_READ_PAGES:
        case CONTEXT_GREAD_PAGES:
        case CONTEXT_READ_OBJECT:
          break_flag = TRUE;
          break;
        default:
          error();
        }
    }
  
  if(context->type == CONTEXT_WATCH_PAGE || context->type == CONTEXT_WATCH_OBJECT)
    {
      context_num = vector_size(page->context_vector);
      for(i = 0; i < context_num; i++)
        {
          tmp_context = (context_t*)vector_at(page->context_vector, i);
          if(tmp_context == context)
            {
              vector_assign(page->context_vector, i, NULL);
              break;
            }
        }
      if(i == context_num) error();
    }
  
  switch(context->type)
    {
    case CONTEXT_WATCH_PAGE:
      context_refcount = --context_refcount(context);
      
      pthread_mutex_unlock(&page->mutex);
      
      if(context_refcount == 0)
        {
          context_access_page_post(context);
        }
      break;
    case CONTEXT_READ_PAGES:
      pthread_mutex_unlock(&page->mutex);
      
      if(hit_flag == TRUE)
        {
          context_access_pages_post(context);
        }
      break;
    case CONTEXT_GREAD_PAGES:
      pthread_mutex_unlock(&page->mutex);
      
      if(hit_flag == TRUE)
        {
          context_gaccess_pages_post(context);
        }
      break;
    case CONTEXT_WATCH_OBJECT:
      context_refcount = --context_refcount(context);
      
      pthread_mutex_unlock(&page->mutex);
      
      if(context_refcount == 0)
        {
          context_access_object_post(context);
        }
      break;
    case CONTEXT_READ_OBJECT:
      pthread_mutex_unlock(&page->mutex);
      
      if(hit_flag == TRUE)
        {
          context_access_object_post(context);
        }
      break;
    default:
      error();
    }
  return;
}

void sub_notify_watch(page_t *page)
{
  context_t *tmp_context;
  int32_t i, context_num;
  
  context_num = vector_size(page->context_vector);
  for(i = 0; i < context_num; i++)
    {
      tmp_context = (context_t*)vector_at(page->context_vector, i);
      if(tmp_context != NULL)
        {
          pthread_mutex_lock(&tmp_context->mutex);
          
          context_watch_flag(tmp_context) = TRUE;
          pthread_cond_broadcast(&tmp_context->cond);
          
          pthread_mutex_unlock(&tmp_context->mutex);
        }
    }
  return;
}

void dmi_handle_req_read_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  account_t *account, *relay_account;
  int8_t relay_flag, error_flag;
  int8_t *page_payload_ptr;
  int32_t i, dmi_id, min_dmi_id, min_stamp, account_num;
  int64_t page_payload_size;
  int64_t *page_offsets, *copy_sizes;
#if DEBUG_OPTIMIZATION
  int8_t *buf;
  int64_t buf_size, buf_capacity;
#else
  writebuf_t *writebuf;
#endif
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->owner_flag == TRUE)
    {
      page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
      
      account = sub_lookup_account(page->account_vector, recv_packet->src_dmi_id);
      
      page_payload_size = 0;
      page_payload_ptr = NULL;
      error_flag = FALSE;
#if DEBUG_OPTIMIZATION
      buf = NULL;
#else
      writebuf = NULL;
#endif
      if(account->state == STATE_INVALID)
        {
          switch(packet_access_type(recv_packet))
            {
            case ACCESS_ONCE_READ:
              if(packet_copy_size(recv_packet) == SYS_FULL_PAGE_SIZE)
                {
                  packet_copy_size(recv_packet) = page->slide_size - packet_page_offset(recv_packet);
                }
              if(!(0 <= packet_page_offset(recv_packet)
                   && packet_page_offset(recv_packet) + packet_copy_size(recv_packet)
                   <= page->slide_size) || packet_copy_size(recv_packet) < 0)
                {
                  error_flag = TRUE;
                  break;
                }
              
              page_payload_size = packet_copy_size(recv_packet);
              page_payload_ptr = page->buf + packet_page_offset(recv_packet);
              break;
            case ACCESS_ONCE_GETSIZE:
              page_payload_size = 0;
              break;
            case ACCESS_ONCE_GREAD:
#if DEBUG_OPTIMIZATION
              buf_capacity = 4096;
              buf_size = 0;
              buf = my_malloc(buf_capacity);
              page_offsets = (int64_t*)recv_packet->data_payload_ptr;
              copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
              for(i = 0; i < packet_set_num(recv_packet); i++)
                {
                  if(buf_size + copy_sizes[i] >= buf_capacity)
                    {
                      buf_capacity = (buf_size + copy_sizes[i]) * 2;
                      buf = my_realloc(buf, buf_capacity);
                    }
                  memcpy(buf + buf_size, page->buf + page_offsets[i], copy_sizes[i]);
                  buf_size += copy_sizes[i];
                }
              
              page_payload_size = buf_size;
              page_payload_ptr = buf;
#else
              writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
              page_offsets = (int64_t*)recv_packet->data_payload_ptr;
              copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
              
              for(i = 0; i < packet_set_num(recv_packet); i++)
                {
                  if(!(0 <= page_offsets[i] && page_offsets[i] + copy_sizes[i]
                       <= page->slide_size) || copy_sizes[i] < 0)
                    {
                      error_flag = TRUE;
                      break;
                    }
                }
              for(i = 0; i < packet_set_num(recv_packet); i++)
                {
                  writebuf_copy(writebuf, page->buf + page_offsets[i], copy_sizes[i]);
                }
              
              page_payload_size = writebuf_size(writebuf);
              page_payload_ptr = writebuf_buf(writebuf);
#endif
              break;
            case ACCESS_INVALIDATE_READ:
            case ACCESS_INVALIDATE_GREAD:
            case ACCESS_INVALIDATE_GETSIZE:
              page_payload_size = page->buf_size;
              page_payload_ptr = page->buf;
              account->state = STATE_DOWNVALID;
              account->stamp = page->stamp++;
              page->valid_num++;
              break;
            case ACCESS_UPDATE_READ:
            case ACCESS_UPDATE_GREAD:
            case ACCESS_UPDATE_GETSIZE:
              page_payload_size = page->buf_size;
              page_payload_ptr = page->buf;
              account->state = STATE_UPVALID;
              account->stamp = page->stamp++;
              page->valid_num++;
              break;
            default:
              error();
            }
        }
      else
        {
          page_payload_size = 0;
          if(account->state == STATE_UPVALID 
             && (packet_access_type(recv_packet) == ACCESS_INVALIDATE_READ
                 || packet_access_type(recv_packet) == ACCESS_INVALIDATE_GREAD
                 || packet_access_type(recv_packet) == ACCESS_INVALIDATE_GETSIZE
                 || packet_access_type(recv_packet) == ACCESS_ONCE_READ
                 || packet_access_type(recv_packet) == ACCESS_ONCE_GREAD
                 || packet_access_type(recv_packet) == ACCESS_ONCE_GETSIZE))
            {
              account->state = STATE_DOWNVALID;
            }
          else if(account->state == STATE_DOWNVALID
                  && (packet_access_type(recv_packet) == ACCESS_UPDATE_READ
                      || packet_access_type(recv_packet) == ACCESS_UPDATE_GREAD
                      || packet_access_type(recv_packet) == ACCESS_UPDATE_GETSIZE))
            {
              account->state = STATE_UPVALID;
            }
        }
      
      if(error_flag == TRUE)
        {
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_READ_PAGE;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->data_payload_size = 0;
          send_packet->page_payload_size = 0;
          packet_ret_flag(send_packet) = FALSE;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          
          pthread_mutex_unlock(&page->mutex);
          return;
        }
      
      if(page_payload_size > 0
         && page_payload_size >= CONST_LARGE_RELAY_SIZE
         && load_size(dmi->load) >= CONST_HIGHLOAD_SIZE
         && page->valid_num >= 2)
        {
          relay_flag = TRUE;
        }
      else
        {
          relay_flag = FALSE;
        }
      
      if(relay_flag == TRUE)
        {
          min_stamp = 1000000;
          min_dmi_id = SYS_ID_UNDEF;
          account_num = vector_size(page->account_vector);
          for(dmi_id = 0; dmi_id < account_num; dmi_id++)
            {
              relay_account = (account_t*)vector_at(page->account_vector, dmi_id);
              
              if(dmi_id != recv_packet->src_dmi_id
                 && relay_account != NULL
                 && (relay_account->state == STATE_DOWNVALID || relay_account->state == STATE_UPVALID))
                {
                  if(relay_account->stamp < min_stamp)
                    {
                      min_stamp = relay_account->stamp;
                      min_dmi_id = dmi_id;
                    }
                }
            }
          if(min_dmi_id == SYS_ID_UNDEF) error();
          
#if DEBUG_TEMPORAL
          fprintf(stderr, "relay page : load=%ld,size=%ld,src=%d,via=%d,dst=%d\n", load_size(dmi->load), page_payload_size, dmi->dmi_id, min_dmi_id, recv_packet->src_dmi_id);
#endif
          
          relay_account = (account_t*)vector_at(page->account_vector, min_dmi_id);
          relay_account->stamp = page->stamp++;
          relay_account->stamp--;
          account->stamp++;
          
          send_packet = packet_alloc();
          
          send_packet->type = PACKET_REQ_RELAY_PAGE;
          send_packet->src_dmi_id = recv_packet->src_dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = min_dmi_id;
          send_packet->page_payload_size = 0;
          packet_vm_id(send_packet) = packet_vm_id(recv_packet);
          packet_page_id(send_packet) = packet_page_id(recv_packet);
          packet_state(send_packet) = account->state;
          packet_slide_size(send_packet) = page->slide_size;
          packet_access_type(send_packet) = packet_access_type(recv_packet);
          packet_seq(send_packet) = relay_account->seq++;
          packet_seq2(send_packet) = account->seq++;
          
          switch(packet_access_type(recv_packet))
            {
            case ACCESS_ONCE_READ:
              send_packet->data_payload_size = 0;
              packet_page_offset(send_packet) = packet_page_offset(recv_packet);
              packet_copy_size(send_packet) = packet_copy_size(recv_packet);
              break;
            case ACCESS_ONCE_GETSIZE:
              error();
              break;
            case ACCESS_ONCE_GREAD:
              packet_set_num(send_packet) = packet_set_num(recv_packet);
              send_packet->data_payload_size = recv_packet->data_payload_size;
              send_packet->data_payload_ptr = recv_packet->data_payload_buf;
              break;
            case ACCESS_INVALIDATE_READ:
            case ACCESS_INVALIDATE_GREAD:
            case ACCESS_INVALIDATE_GETSIZE:
            case ACCESS_UPDATE_READ:
            case ACCESS_UPDATE_GREAD:
            case ACCESS_UPDATE_GETSIZE:
              send_packet->data_payload_size = 0;
              break;
            default:
              error();
            }
          
          dmi_send_packet(dmi, send_packet);
          
          packet_free(send_packet);
        }
      
      send_packet = packet_alloc();
      
      send_packet->type = PACKET_ACK_READ_PAGE;
      send_packet->src_dmi_id = dmi->dmi_id;
      send_packet->context_id = recv_packet->context_id;
      send_packet->dst_dmi_id = recv_packet->src_dmi_id;
      send_packet->data_payload_size = 0;
      packet_ret_flag(send_packet) = TRUE;
      packet_state(send_packet) = account->state;
      packet_slide_size(send_packet) = page->slide_size;
      packet_seq(send_packet) = account->seq++;
      packet_ack_flag(send_packet) = TRUE;
      packet_relay_flag(send_packet) = relay_flag;
      
      if(relay_flag == TRUE)
        {
          send_packet->page_payload_size = 0;
        }
      else
        {
          send_packet->page_payload_size = page_payload_size;
          send_packet->page_payload_ptr = page_payload_ptr;
        }
      
      dmi_send_packet(dmi, send_packet);
      
      packet_free(send_packet);
      
#if DEBUG_OPTIMIZATION
      if(buf != NULL)
        {
          my_free(buf);
        }
#else
      if(writebuf != NULL)
        {
          writebuf_free(writebuf);
        }
#endif
    }
  else
    {
      recv_packet->dst_dmi_id = page->owner_id;
      dmi_send_packet(dmi, recv_packet);
    }
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_req_relay_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t i, ret;
  int64_t *page_offsets, *copy_sizes;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(dmi, page->order, recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  send_packet = packet_alloc();
  
  if(page->state == STATE_INVALID) error();
  if(packet_slide_size(recv_packet) != page->slide_size) error();
  
  writebuf = NULL;
  switch(packet_access_type(recv_packet))
    {
    case ACCESS_ONCE_READ:
      if(packet_copy_size(recv_packet) == SYS_FULL_PAGE_SIZE)
        {
          error();
        }
      if(!(0 <= packet_page_offset(recv_packet)
           && packet_page_offset(recv_packet) + packet_copy_size(recv_packet)
           <= page->slide_size) || packet_copy_size(recv_packet) < 0)
        {
          error();
        }
      
      send_packet->page_payload_size = packet_copy_size(recv_packet);
      send_packet->page_payload_ptr = page->buf + packet_page_offset(recv_packet);
      break;
    case ACCESS_ONCE_GETSIZE:
      error();
      break;
    case ACCESS_ONCE_GREAD:
      writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
      page_offsets = (int64_t*)recv_packet->data_payload_ptr;
      copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
      
      for(i = 0; i < packet_set_num(recv_packet); i++)
        {
          if(!(0 <= page_offsets[i] && page_offsets[i] + copy_sizes[i]
               <= page->slide_size) || copy_sizes[i] < 0)
            {
              error();
            }
          
          writebuf_copy(writebuf, page->buf + page_offsets[i], copy_sizes[i]);
        }
      
      send_packet->page_payload_size = writebuf_size(writebuf);
      send_packet->page_payload_ptr = writebuf_buf(writebuf);
      break;
    case ACCESS_INVALIDATE_READ:
    case ACCESS_INVALIDATE_GREAD:
    case ACCESS_INVALIDATE_GETSIZE:
      send_packet->page_payload_size = page->buf_size;
      send_packet->page_payload_ptr = page->buf;
      break;
    case ACCESS_UPDATE_READ:
    case ACCESS_UPDATE_GREAD:
    case ACCESS_UPDATE_GETSIZE:
      send_packet->page_payload_size = page->buf_size;
      send_packet->page_payload_ptr = page->buf;
      break;
    default:
      error();
    }
  
  send_packet->type = PACKET_ACK_RELAY_PAGE;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->data_payload_size = 0;
  packet_seq(send_packet) = packet_seq2(recv_packet);
  packet_state(send_packet) = packet_state(recv_packet);
  packet_slide_size(send_packet) = packet_slide_size(recv_packet);
  packet_ack_flag(send_packet) = FALSE;
  packet_relay_flag(send_packet) = FALSE;
  packet_ret_flag(send_packet) = TRUE;
  
  dmi_send_packet(dmi, send_packet);
  
  if(writebuf != NULL)
    {
      writebuf_free(writebuf);
    }
  
  packet_free(send_packet);
  
  sub_increment_order(dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_read_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_read_page_post(context);
  return;
}

void dmi_handle_ack_relay_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_read_page_post(context);
  return;
}

void context_read_page_post(context_t *context)
{
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int8_t error_flag, ack_flag, context_type, context_refcount;
  int32_t ret, i;
  int64_t page_offset;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      ret = sub_check_order(context->dmi, page->order, context->recv_packet);
      if(ret == FALSE)
        {
          pthread_mutex_unlock(&page->mutex);
          return;
        }
      
      if(packet_ack_flag(context->recv_packet) == TRUE)
        {
          page->owner_id = context->recv_packet->src_dmi_id;
          page->state = packet_state(context->recv_packet);
          page->slide_size = packet_slide_size(context->recv_packet);
          sub_notify_watch(page);
        }
      
      if(packet_relay_flag(context->recv_packet) == FALSE)
        {
          error_flag = FALSE;
          if(packet_state(context->recv_packet) == STATE_INVALID)
            {
              switch(context_access_type(context))
                {
                case ACCESS_ONCE_READ:
                  memcpy(context_in_ptr(context), context->recv_packet->page_payload_ptr, context_copy_size(context));
                  break;
                case ACCESS_ONCE_GETSIZE:
                  *context_slide_size_ptr(context) = packet_slide_size(context->recv_packet);
                  break;
                case ACCESS_ONCE_GREAD:
                  page_offset = 0;
                  for(i = 0; i < context_set_num(context); i++)
                    {
                      memcpy(context_in_ptr(context) + context_ptr_offsets(context)[i], context->recv_packet->page_payload_ptr + page_offset, context_copy_sizes(context)[i]);
                      page_offset += context_copy_sizes(context)[i];
                    }
                  break;
                case ACCESS_INVALIDATE_READ:
                case ACCESS_INVALIDATE_GREAD:
                case ACCESS_INVALIDATE_GETSIZE:
                case ACCESS_UPDATE_READ:
                case ACCESS_UPDATE_GREAD:
                case ACCESS_UPDATE_GETSIZE:
                  error();
                  break;
                default:
                  error();
                }
            }
          else
            {
              page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, packet_slide_size(context->recv_packet));
              
              if(context->recv_packet->page_payload_size != 0)
                {
                  memcpy(page->buf, context->recv_packet->page_payload_ptr, page->buf_size);
                }
              
              switch(context_access_type(context))
                {
                case ACCESS_ONCE_GREAD:
                case ACCESS_INVALIDATE_GREAD:
                case ACCESS_UPDATE_GREAD:
                  for(i = 0; i < context_set_num(context); i++)
                    {
                      if(!(0 <= context_page_offsets(context)[i]
                           && context_page_offsets(context)[i] + context_copy_sizes(context)[i]
                           <= page->slide_size) || context_copy_sizes(context)[i] < 0)
                        {
                          error_flag = TRUE;
                          break;
                        }
                    }
                  for(i = 0; i < context_set_num(context); i++)
                    {
                      memcpy(context_in_ptr(context) + context_ptr_offsets(context)[i], page->buf + context_page_offsets(context)[i], context_copy_sizes(context)[i]);
                    }
                  break;
                case ACCESS_ONCE_READ:
                case ACCESS_INVALIDATE_READ:
                case ACCESS_UPDATE_READ:
                  if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
                    {
                      context_copy_size(context) = page->slide_size - context_page_offset(context);
                    }
                  if(!(0 <= context_page_offset(context)
                       && context_page_offset(context) + context_copy_size(context)
                       <= page->slide_size) || context_copy_size(context) < 0)
                    {
                      error_flag = TRUE;
                      break;
                    }
                  
                  memcpy(context_in_ptr(context), page->buf + context_page_offset(context), context_copy_size(context));
                  break;
                case ACCESS_ONCE_GETSIZE:
                case ACCESS_INVALIDATE_GETSIZE:
                case ACCESS_UPDATE_GETSIZE:
                  *context_slide_size_ptr(context) = packet_slide_size(context->recv_packet);
                  break;
                default:
                  error();
                }
            }
          if(error_flag == TRUE)
            {
              context_ret_flag(context) = FALSE;
            }
        }
      
      ack_flag = packet_ack_flag(context->recv_packet);
      context_type = context->type;
      context_refcount = --context_refcount(context);
      
      sub_increment_order(context->dmi, page);
      
      pthread_mutex_unlock(&page->mutex);
      
      if(ack_flag == TRUE)
        {
          switch(context_type)
            {
            case CONTEXT_WATCH_PAGE:
              if(context_refcount == 0)
                {
                  context_access_page_post(context);
                }
              break;
            case CONTEXT_WATCH_OBJECT:
              if(context_refcount == 0)
                {
                  context_access_object_post(context);
                }
              break;
            case CONTEXT_READ_PAGES:
              context_access_pages_post(context);
              break;
            case CONTEXT_GREAD_PAGES:
              context_gaccess_pages_post(context);
              break;
            case CONTEXT_READ_OBJECT:
              context_access_object_post(context);
              break;
            default:
              error();
            }
        }
    }
  else
    {
      context_type = context->type;
      context_refcount = --context_refcount(context);
      
      pthread_mutex_unlock(&page->mutex);
      
      switch(context_type)
        {
        case CONTEXT_WATCH_PAGE:
        case CONTEXT_READ_PAGES:
        case CONTEXT_GREAD_PAGES:
          error();
          break;
        case CONTEXT_READ_OBJECT:
          context_ret_flag(context) = FALSE;
          
          if(context_refcount == 0)
            {
              context_access_object_post(context);
            }
          break;
        case CONTEXT_WATCH_OBJECT:
          context_ret_flag(context) = FALSE;
          
          context_access_object_post(context);
          break;
        default:
          error();
        }
    }
  return;
}

void context_access_page_post(context_t *context)
{
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  gate_escape(vm_gate);
  
  dmi_free_context(context->dmi, context, context_ret_flag(context));
  return;
}

void context_access_object_post(context_t *context)
{
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  gate_escape(vm_gate);
  
  dmi_free_context(context->dmi, context, context_ret_flag(context));
  return;
}

void context_access_pages_post(context_t *context)
{
  context_t *parent_context;
  gate_t *vm_gate;
  int8_t ret_flag;
  
  parent_context = dmi_get_context(context->dmi, context_parent_context_id(context));
  ret_flag = context_ret_flag(context);
  
  dmi_free_context(context->dmi, context, TRUE);
  
  pthread_mutex_lock(&parent_context->mutex);
  
  context_count(parent_context)++;
  if(ret_flag == FALSE)
    {
      context_ret_flag(parent_context) = FALSE;
    }
  
  if(context_count(parent_context) == context_total(parent_context))
    {
      pthread_mutex_unlock(&parent_context->mutex);
      
      vm_gate = (gate_t*)xvector_at(parent_context->dmi->vm_gate_xvector, SYS_ADDR_VM_PART(context_dmi_addr(parent_context)));
      gate_escape(vm_gate);
      
      dmi_free_context(parent_context->dmi, parent_context, context_ret_flag(parent_context));
    }
  else
    {
      pthread_mutex_unlock(&parent_context->mutex);
    }
  return;
}

void context_gaccess_page_post(context_t *context)
{
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  gate_escape(vm_gate);
  
  dmi_free_context(context->dmi, context, context_ret_flag(context));
  return;
}

void context_gaccess_object_post(context_t *context)
{
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  gate_escape(vm_gate);
  
  dmi_free_context(context->dmi, context, context_ret_flag(context));
  return;
}

void context_gaccess_pages_post(context_t *context)
{
  context_t *parent_context;
  gate_t *vm_gate;
  int8_t ret_flag;
  int32_t i, vm_num;
  
  parent_context = dmi_get_context(context->dmi, context_parent_context_id(context));
  ret_flag = context_ret_flag(context);
  
  dmi_free_context(context->dmi, context, TRUE);
  
  pthread_mutex_lock(&parent_context->mutex);
  
  context_count(parent_context)++;
  if(ret_flag == FALSE)
    {
      context_ret_flag(parent_context) = FALSE;
    }
  
  if(context_count(parent_context) == context_total(parent_context))
    {
      pthread_mutex_unlock(&parent_context->mutex);
      
      vm_num = context_vm_num(parent_context);
      for(i = 0; i < vm_num; i++)
        {
          vm_gate = (gate_t*)xvector_at(parent_context->dmi->vm_gate_xvector, context_vm_ids(parent_context)[i]);
          gate_escape(vm_gate);
        }
      
      dmi_free_context(parent_context->dmi, parent_context, context_ret_flag(parent_context));
    }
  else
    {
      pthread_mutex_unlock(&parent_context->mutex);
    }
  return;
}

void context_exclude_page_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int8_t error_flag;
  int32_t i;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->owner_flag == TRUE && page->valid_num == 1)
    {
      page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
      
      error_flag = FALSE;
      switch(context_access_type(context))
        {
        case ACCESS_LOCAL_WRITE:
        case ACCESS_REMOTE_WRITE:
          if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
            {
              context_copy_size(context) = page->slide_size - context_page_offset(context);
            }
          if(!(0 <= context_page_offset(context)
               && context_page_offset(context) + context_copy_size(context)
               <= page->slide_size) || context_copy_size(context) < 0)
            {
              error_flag = TRUE;
              break;
            }
          
          memcpy(page->buf + context_page_offset(context), context_out_ptr(context), context_copy_size(context));
          break;
        case ACCESS_LOCAL_SETSIZE:
        case ACCESS_REMOTE_SETSIZE:
          page->slide_size = context_slide_size(context);
          page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
          break;
        case ACCESS_LOCAL_GWRITE:
        case ACCESS_REMOTE_GWRITE:
          for(i = 0; i < context_set_num(context); i++)
            {
              if(!(0 <= context_page_offsets(context)[i]
                   && context_page_offsets(context)[i] + context_copy_sizes(context)[i]
                   <= page->slide_size) || context_copy_sizes(context)[i] < 0)
                {
                  error_flag = TRUE;
                  break;
                }
            }
          for(i = 0; i < context_set_num(context); i++)
            {
              memcpy(page->buf + context_page_offsets(context)[i], context_out_ptr(context) + context_ptr_offsets(context)[i], context_copy_sizes(context)[i]);
            }
          break;
        case ACCESS_LOCAL_ATOMIC:
        case ACCESS_REMOTE_ATOMIC:
          if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
            {
              context_copy_size(context) = page->slide_size - context_page_offset(context);
            }
          if(!(0 <= context_page_offset(context)
               && context_page_offset(context) + context_copy_size(context)
               <= page->slide_size) || context_copy_size(context) < 0)
            {
              error_flag = TRUE;
              break;
            }
          
          dmi_function(page->buf + context_page_offset(context), context_copy_size(context), context_out_ptr(context), context_out_size(context), context_in_ptr(context), context_in_size(context), context_tag(context));
          break;
        default:
          error();
        }
      
      if(error_flag == TRUE)
        {
          pthread_mutex_unlock(&page->mutex);
          
          switch(context->type)
            {
            case CONTEXT_EXCLUDE_PAGES:
            case CONTEXT_GEXCLUDE_PAGES:
            case CONTEXT_EXCLUDE_PAGE:
              error();
              break;
            case CONTEXT_EXCLUDE_OBJECT:
              context_ret_flag(context) = FALSE;
              
              context_access_object_post(context);
              break;
            case CONTEXT_GEXCLUDE_OBJECT:
              context_ret_flag(context) = FALSE;
              
              context_gaccess_object_post(context);
              break;
            default:
              error();
            }
        }
      else
        {
          switch(context_access_type(context))
            {
            case ACCESS_LOCAL_WRITE:
            case ACCESS_LOCAL_ATOMIC:
            case ACCESS_LOCAL_GWRITE:
            case ACCESS_LOCAL_SETSIZE:
              break;
            case ACCESS_REMOTE_GWRITE:
              context_access_type(context) = ACCESS_LOCAL_GWRITE;
              break;
            case ACCESS_REMOTE_WRITE:
              context_access_type(context) = ACCESS_LOCAL_WRITE;
              break;
            case ACCESS_REMOTE_ATOMIC:
              context_access_type(context) = ACCESS_LOCAL_ATOMIC;
              break;
            case ACCESS_REMOTE_SETSIZE:
              context_access_type(context) = ACCESS_LOCAL_SETSIZE;
              break;
            default:
              error();
            }
          
          sub_notify_watch(page);
          
          if(page->valid_num != 1)
            {
              context_adjust_page_pre(context);
              
              pthread_mutex_unlock(&page->mutex);
            }
          else
            {
              pthread_mutex_unlock(&page->mutex);
              
              switch(context->type)
                {
                case CONTEXT_EXCLUDE_PAGES:
                  context_access_pages_post(context);
                  break;
                case CONTEXT_GEXCLUDE_PAGES:
                  context_gaccess_pages_post(context);
                  break;
                case CONTEXT_EXCLUDE_PAGE:
                  context_access_page_post(context);
                  break;
                case CONTEXT_EXCLUDE_OBJECT:
                  context_access_object_post(context);
                  break;
                case CONTEXT_GEXCLUDE_OBJECT:
                  context_gaccess_object_post(context);
                  break;
                default:
                  error();
                }
            }
        }
    }
  else
    {
      send_packet = packet_alloc();
      
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context->context_id;
      send_packet->dst_dmi_id = page->owner_id;
      packet_vm_id(send_packet) = context_vm_id(context);
      packet_page_id(send_packet) = context_page_id(context);
      
      writebuf = NULL;
      switch(context_access_type(context))
        {
        case ACCESS_LOCAL_WRITE:
        case ACCESS_LOCAL_ATOMIC:
        case ACCESS_LOCAL_GWRITE:
        case ACCESS_LOCAL_SETSIZE:
          send_packet->type = PACKET_REQ_STEAL_PAGE;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          break;
        case ACCESS_REMOTE_WRITE:
          send_packet->type = PACKET_REQ_COMMIT_PAGE;
          send_packet->page_payload_size = context_copy_size(context);
          send_packet->page_payload_ptr = context_out_ptr(context);
          send_packet->data_payload_size = 0;
          packet_page_offset(send_packet) = context_page_offset(context);
          packet_copy_size(send_packet) = context_copy_size(context);
          packet_access_type(send_packet) = context_access_type(context);
          break;
        case ACCESS_REMOTE_SETSIZE:
          send_packet->type = PACKET_REQ_COMMIT_PAGE;
          send_packet->page_payload_size = context_copy_size(context);
          send_packet->page_payload_ptr = context_out_ptr(context);
          send_packet->data_payload_size = 0;
          packet_page_offset(send_packet) = context_page_offset(context);
          packet_copy_size(send_packet) = context_copy_size(context);
          packet_access_type(send_packet) = context_access_type(context);
          packet_slide_size(send_packet) = context_slide_size(context);
          break;
        case ACCESS_REMOTE_ATOMIC:
          send_packet->type = PACKET_REQ_COMMIT_PAGE;
          packet_page_offset(send_packet) = context_page_offset(context);
          packet_copy_size(send_packet) = context_copy_size(context);
          packet_out_size(send_packet) = context_out_size(context);
          packet_in_size(send_packet) = context_in_size(context);
          packet_tag(send_packet) = context_tag(context);
          packet_access_type(send_packet) = context_access_type(context);
          send_packet->page_payload_size = context_out_size(context);
          send_packet->page_payload_ptr = context_out_ptr(context);
          send_packet->data_payload_size = 0;
          break;
        case ACCESS_REMOTE_GWRITE:
          send_packet->type = PACKET_REQ_COMMIT_PAGE;
          send_packet->data_payload_size = 0;
          packet_access_type(send_packet) = context_access_type(context);
          
          writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
          
          packet_set_num(send_packet) = context_set_num(context);
          for(i = 0; i < packet_set_num(send_packet); i++)
            {
              writebuf_copy(writebuf, context_out_ptr(context) + context_ptr_offsets(context)[i], context_copy_sizes(context)[i]);
            }
          
          send_packet->page_payload_size = writebuf_size(writebuf);
          send_packet->page_payload_ptr = writebuf_buf(writebuf);
          
          send_packet->data_payload_size = context_set_num(context) * 2 * sizeof(int64_t);
          send_packet->data_payload_buf = (int8_t*)my_malloc(send_packet->data_payload_size);
          send_packet->data_payload_ptr = send_packet->data_payload_buf;
          memcpy(send_packet->data_payload_ptr, context_page_offsets(context), context_set_num(context) * sizeof(int64_t));
          memcpy(send_packet->data_payload_ptr + context_set_num(context) * sizeof(int64_t), context_copy_sizes(context), context_set_num(context) * sizeof(int64_t));
          break;
        default:
          error();
        }
      
      dmi_send_packet(context->dmi, send_packet);
      
      if(writebuf != NULL)
        {
          writebuf_free(writebuf);
        }
      
      packet_free(send_packet);
      
      pthread_mutex_unlock(&page->mutex);
    }
  return;
}

void dmi_handle_req_steal_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *new_context;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->owner_flag == TRUE)
    {
      new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
      new_context->type = CONTEXT_MIGRATE_PAGE;
      context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
      context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
      context_vm_id(new_context) = packet_vm_id(recv_packet);
      context_page_id(new_context) = packet_page_id(recv_packet);
      context_owner_id(new_context) = recv_packet->src_dmi_id;
      
      context_migrate_page_pre(new_context);
    }
  else
    {
      recv_packet->dst_dmi_id = page->owner_id;
      dmi_send_packet(dmi, recv_packet);
    }
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void context_migrate_page_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  page->owner_flag = FALSE;
  
  account = sub_lookup_account(page->account_vector, context->dmi->dmi_id);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_MIGRATE_PAGE;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context->dmi->dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_vm_id(send_packet) = context_vm_id(context);
  packet_page_id(send_packet) = context_page_id(context);
  packet_seq(send_packet) = account->seq++;
  packet_owner_id(send_packet) = context_owner_id(context);
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  return;
}

void dmi_handle_req_migrate_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(dmi, page->order, recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  page->owner_id = packet_owner_id(recv_packet);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_MIGRATE_PAGE;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  sub_increment_order(dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_migrate_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_migrate_page_post(context);
  return;
}

void context_migrate_page_post(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t dmi_id, account_num, count;
  int64_t offset;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  account = sub_lookup_account(page->account_vector, context_owner_id(context));
      
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_STEAL_PAGE;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context_parent_dmi_context(context).context_id;
  send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
  packet_slide_size(send_packet) = page->slide_size;
  packet_ret_flag(send_packet) = TRUE;
  packet_seq(send_packet) = account->seq++;
  
  if(account->state == STATE_INVALID)
    {
      send_packet->page_payload_size = page->buf_size;
      send_packet->page_payload_ptr = page->buf;
      
      account->state = STATE_DOWNVALID;
      account->stamp = page->stamp++;
      page->valid_num++;
    }
  else
    {
      send_packet->page_payload_size = 0;
    }
  
  packet_state(send_packet) = account->state;
  
  writebuf = NULL;    
  if(context_owner_id(context) != context->dmi->dmi_id)
    {
      packet_valid_num(send_packet) = page->valid_num;
      packet_stamp(send_packet) = page->stamp;
          
      writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
          
      account_num = vector_size(page->account_vector);
      offset = writebuf_skip(writebuf, sizeof(int32_t));
      count = 0;
      for(dmi_id = 0; dmi_id < account_num; dmi_id++)
        {
          account = (account_t*)vector_at(page->account_vector, dmi_id);
          if(account != NULL)
            {
              writebuf_copy(writebuf, &dmi_id, sizeof(int32_t));
              writebuf_copy(writebuf, &account->seq, sizeof(int32_t));
              writebuf_copy(writebuf, &account->stamp, sizeof(int32_t));
              writebuf_copy(writebuf, &account->state, sizeof(int8_t));
              account_free(account);
              
              vector_assign(page->account_vector, dmi_id, NULL);
                  
              count++;
            }
        }
      writebuf_seekcopy(writebuf, offset, &count, sizeof(int32_t));
      
      send_packet->data_payload_size = writebuf_size(writebuf);
      send_packet->data_payload_ptr = writebuf_buf(writebuf);
    }
  else
    {
      send_packet->data_payload_size = 0;
    }
  
  dmi_send_packet(context->dmi, send_packet);
  
  if(writebuf != NULL)
    {
      writebuf_free(writebuf);
    }
  
  packet_free(send_packet);
      
  dmi_free_context(context->dmi, context, TRUE);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_steal_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_exclude_page_post(context);
  return;
}

void context_exclude_page_post(context_t *context)
{
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  readbuf_t *readbuf;
  int8_t error_flag;
  int8_t *in_ptr;
  int32_t i, dmi_id, account_num, ret;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  error_flag = FALSE;
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      ret = sub_check_order(context->dmi, page->order, context->recv_packet);
      if(ret == FALSE)
        {
          pthread_mutex_unlock(&page->mutex);
          return;
        }
      
      switch(context_access_type(context))
        {
        case ACCESS_LOCAL_WRITE:
        case ACCESS_LOCAL_ATOMIC:
        case ACCESS_LOCAL_GWRITE:
        case ACCESS_LOCAL_SETSIZE:
          page->owner_id = context->dmi->dmi_id;
          
          page->state = packet_state(context->recv_packet);
          page->slide_size = packet_slide_size(context->recv_packet);
          page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
          sub_notify_watch(page);
          
          if(context->recv_packet->page_payload_size != 0)
            {
              memcpy(page->buf, context->recv_packet->page_payload_ptr, page->buf_size);
            }
          
          if(context->recv_packet->data_payload_size != 0)
            {
              page->valid_num = packet_valid_num(context->recv_packet);
              page->stamp = packet_stamp(context->recv_packet);
              
              readbuf = readbuf_alloc(context->recv_packet->data_payload_ptr, context->recv_packet->data_payload_size);
              
              readbuf_copy(readbuf, &account_num, sizeof(int32_t));
              for(i = 0; i < account_num; i++)
                {
                  account = account_alloc();
                  readbuf_copy(readbuf, &dmi_id, sizeof(int32_t));
                  readbuf_copy(readbuf, &account->seq, sizeof(int32_t));
                  readbuf_copy(readbuf, &account->stamp, sizeof(int32_t));
                  readbuf_copy(readbuf, &account->state, sizeof(int8_t));
                  
                  vector_assign(page->account_vector, dmi_id, account);
                }
              
              readbuf_free(readbuf);
            }
          
          page->owner_flag = TRUE;
          
          switch(context_access_type(context))
            {
            case ACCESS_LOCAL_WRITE:
              if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
                {
                  context_copy_size(context) = page->slide_size - context_page_offset(context);
                }
              if(!(0 <= context_page_offset(context)
                   && context_page_offset(context) + context_copy_size(context)
                   <= page->slide_size) || context_copy_size(context) < 0)
                {
                  error_flag = TRUE;
                  break;
                }
              
              memcpy(page->buf + context_page_offset(context), context_out_ptr(context), context_copy_size(context));
              break;
            case ACCESS_LOCAL_SETSIZE:
              page->slide_size = context_slide_size(context);
              page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
              break;
            case ACCESS_LOCAL_ATOMIC:
              if(context_copy_size(context) == SYS_FULL_PAGE_SIZE)
                {
                  context_copy_size(context) = page->slide_size - context_page_offset(context);
                }
              if(!(0 <= context_page_offset(context)
                   && context_page_offset(context) + context_copy_size(context)
                   <= page->slide_size) || context_copy_size(context) < 0)
                {
                  error_flag = TRUE;
                  break;
                }
              
              dmi_function(page->buf + context_page_offset(context), context_copy_size(context), context_out_ptr(context), context_out_size(context), context_in_ptr(context), context_in_size(context), context_tag(context));
              break;
            case ACCESS_LOCAL_GWRITE:
              for(i = 0; i < context_set_num(context); i++)
                {
                  if(!(0 <= context_page_offsets(context)[i]
                       && context_page_offsets(context)[i] + context_copy_sizes(context)[i]
                       <= page->slide_size) || context_copy_sizes(context)[i] < 0)
                    {
                      error_flag = TRUE;
                      break;
                    }
                }
              for(i = 0; i < context_set_num(context); i++)
                {
                  memcpy(page->buf + context_page_offsets(context)[i], context_out_ptr(context) + context_ptr_offsets(context)[i], context_copy_sizes(context)[i]);
                }
              break;
            default:
              error();
            }
          if(error_flag == TRUE)
            {
              break;
            }
          
          if(page->valid_num != 1)
            {
              context_adjust_page_pre(context);
              
              sub_increment_order(context->dmi, page);
              
              pthread_mutex_unlock(&page->mutex);
            }
          else
            {
              sub_increment_order(context->dmi, page);
              
              pthread_mutex_unlock(&page->mutex);
              
              switch(context->type)
                {
                case CONTEXT_EXCLUDE_PAGES:
                  context_access_pages_post(context);
                  break;
                case CONTEXT_GEXCLUDE_PAGES:
                  context_gaccess_pages_post(context);
                  break;
                case CONTEXT_EXCLUDE_PAGE:
                  context_access_page_post(context);
                  break;
                case CONTEXT_EXCLUDE_OBJECT:
                  context_access_object_post(context);
                  break;
                case CONTEXT_GEXCLUDE_OBJECT:
                  context_gaccess_object_post(context);
                  break;
                default:
                  error();
                }
            }
          break;
        case ACCESS_REMOTE_WRITE:
        case ACCESS_REMOTE_GWRITE:
        case ACCESS_REMOTE_ATOMIC:
        case ACCESS_REMOTE_SETSIZE:
          page->owner_id = context->recv_packet->src_dmi_id;
          
          sub_increment_order(context->dmi, page);
          
          pthread_mutex_unlock(&page->mutex);
          
          switch(context_access_type(context))
            {
            case ACCESS_REMOTE_WRITE:
            case ACCESS_REMOTE_GWRITE:
            case ACCESS_REMOTE_SETSIZE:
              break;
            case ACCESS_REMOTE_ATOMIC:
              in_ptr = context->recv_packet->page_payload_ptr;
              memcpy(context_in_ptr(context), in_ptr, context_in_size(context));
              break;
            default:
              error();
            }
          
          switch(context->type)
            {
            case CONTEXT_EXCLUDE_PAGES:
              context_access_pages_post(context);
              break;
            case CONTEXT_GEXCLUDE_PAGES:
              context_gaccess_pages_post(context);
              break;
            case CONTEXT_EXCLUDE_PAGE:
              context_access_page_post(context);
              break;
            case CONTEXT_EXCLUDE_OBJECT:
              context_access_object_post(context);
              break;
            case CONTEXT_GEXCLUDE_OBJECT:
              context_gaccess_object_post(context);
              break;
            default:
              error();
            }
          break;
        default:
          error();
        }
    }
  else
    {
      error_flag = TRUE;
      
      pthread_mutex_unlock(&page->mutex);
    }
  
  if(error_flag == TRUE)
    {
      switch(context->type)
        {
        case CONTEXT_EXCLUDE_PAGES:
        case CONTEXT_GEXCLUDE_PAGES:
        case CONTEXT_EXCLUDE_PAGE:
          error();
          break;
        case CONTEXT_EXCLUDE_OBJECT:
          context_ret_flag(context) = FALSE;
          
          context_access_object_post(context);
          break;
        case CONTEXT_GEXCLUDE_OBJECT:
          context_ret_flag(context) = FALSE;
          
          context_gaccess_object_post(context);
          break;
        default:
          error();
        }
    }
  return;
}

void context_adjust_page_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t dmi_id, account_num, i;
  int64_t ptr_offset;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  context_count(context) = 0;
  context_total(context) = page->valid_num - 1;
  if(page->valid_num <= 1) error();
  
  page->owner_flag = FALSE;
  
  account_num = vector_size(page->account_vector);
  for(dmi_id = 0; dmi_id < account_num; dmi_id++)
    {
      account = (account_t*)vector_at(page->account_vector, dmi_id);
      
      if(dmi_id != context->dmi->dmi_id
         && account != NULL && account->state == STATE_DOWNVALID)
        {
          account->state = STATE_INVALID;
          page->valid_num--;
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_REQ_INVALIDATE_PAGE;
          send_packet->src_dmi_id = context->dmi->dmi_id;
          send_packet->context_id = context->context_id;
          send_packet->dst_dmi_id = dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          packet_vm_id(send_packet) = context_vm_id(context);
          packet_page_id(send_packet) = context_page_id(context);
          packet_seq(send_packet) = account->seq++;
          dmi_send_packet(context->dmi, send_packet);
          packet_free(send_packet);
        }
    }
  
  for(dmi_id = 0; dmi_id < account_num; dmi_id++)
    {
      account = (account_t*)vector_at(page->account_vector, dmi_id);
      
      if(dmi_id != context->dmi->dmi_id
         && account != NULL && account->state == STATE_UPVALID)
        {
          send_packet = packet_alloc();
          send_packet->type = PACKET_REQ_VALIDATE_PAGE;
          send_packet->src_dmi_id = context->dmi->dmi_id;
          send_packet->context_id = context->context_id;
          send_packet->dst_dmi_id = dmi_id;
          packet_vm_id(send_packet) = context_vm_id(context);
          packet_page_id(send_packet) = context_page_id(context);
          packet_seq(send_packet) = account->seq++;
          packet_access_type(send_packet) = context_access_type(context);
          
          writebuf = NULL;
          switch(context_access_type(context))
            {
            case ACCESS_LOCAL_WRITE:
            case ACCESS_REMOTE_WRITE:
              packet_page_offset(send_packet) = context_page_offset(context);
              packet_copy_size(send_packet) = context_copy_size(context);
              send_packet->page_payload_size = context_copy_size(context);
              send_packet->page_payload_ptr = context_out_ptr(context);
              send_packet->data_payload_size = 0;
              break;
            case ACCESS_LOCAL_SETSIZE:
            case ACCESS_REMOTE_SETSIZE:
              packet_slide_size(send_packet) = context_slide_size(context);
              packet_page_offset(send_packet) = context_page_offset(context);
              packet_copy_size(send_packet) = context_copy_size(context);
              send_packet->page_payload_size = context_copy_size(context);
              send_packet->page_payload_ptr = context_out_ptr(context);
              send_packet->data_payload_size = 0;
              break;
            case ACCESS_LOCAL_ATOMIC:
            case ACCESS_REMOTE_ATOMIC:
              packet_page_offset(send_packet) = context_page_offset(context);
              packet_copy_size(send_packet) = context_copy_size(context);
              packet_out_size(send_packet) = context_out_size(context);
              packet_tag(send_packet) = context_tag(context);
              send_packet->page_payload_size = context_out_size(context);
              send_packet->page_payload_ptr = context_out_ptr(context);
              send_packet->data_payload_size = 0;
              break;
            case ACCESS_LOCAL_GWRITE:
            case ACCESS_REMOTE_GWRITE:
              packet_page_offset(send_packet) = context_page_offset(context);
              packet_copy_size(send_packet) = context_copy_size(context);
              
              writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
              
              ptr_offset = 0;
              packet_set_num(send_packet) = context_set_num(context);
              for(i = 0; i < packet_set_num(send_packet); i++)
                {
                  writebuf_copy(writebuf, context_out_ptr(context) + ptr_offset, context_copy_sizes(context)[i]);
                  ptr_offset += context_copy_sizes(context)[i];
                }
              
              send_packet->page_payload_size = writebuf_size(writebuf);
              send_packet->page_payload_ptr = writebuf_buf(writebuf);
              
              send_packet->data_payload_size = context_set_num(context) * 2 * sizeof(int64_t);
              send_packet->data_payload_buf = (int8_t*)my_malloc(send_packet->data_payload_size);
              send_packet->data_payload_ptr = send_packet->data_payload_buf;
              memcpy(send_packet->data_payload_ptr, context_page_offsets(context), context_set_num(context) * sizeof(int64_t));
              memcpy(send_packet->data_payload_ptr + context_set_num(context) * sizeof(int64_t), context_copy_sizes(context), context_set_num(context) * sizeof(int64_t));
              break;
            default:
              error();
            }
          
          dmi_send_packet(context->dmi, send_packet);
          
          if(writebuf != NULL)
            {
              writebuf_free(writebuf);
            }
          
          packet_free(send_packet);
        }
    }
  return;
}

void dmi_handle_req_validate_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int8_t *out_ptr;
  int32_t ret, i;
  int64_t ptr_offset;
  int64_t *page_offsets, *copy_sizes;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(dmi, page->order, recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  page->owner_id = recv_packet->src_dmi_id;
  
  page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
  
  switch(packet_access_type(recv_packet))
    {
    case ACCESS_LOCAL_WRITE:
    case ACCESS_REMOTE_WRITE:
      if(packet_copy_size(recv_packet) == SYS_FULL_PAGE_SIZE)
        {
          error();
        }
      if(!(0 <= packet_page_offset(recv_packet)
           && packet_page_offset(recv_packet) + packet_copy_size(recv_packet)
           <= page->slide_size) || packet_copy_size(recv_packet) < 0)
        {
          error();
        }
      
      out_ptr = recv_packet->page_payload_ptr;
      memcpy(page->buf + packet_page_offset(recv_packet), out_ptr, packet_copy_size(recv_packet));
      break;
    case ACCESS_LOCAL_SETSIZE:
    case ACCESS_REMOTE_SETSIZE:
      page->slide_size = packet_slide_size(recv_packet);
      page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
      break;
    case ACCESS_LOCAL_GWRITE:
    case ACCESS_REMOTE_GWRITE:
      out_ptr = recv_packet->page_payload_ptr;
      page_offsets = (int64_t*)recv_packet->data_payload_ptr;
      copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
      ptr_offset = 0;
      for(i = 0; i < packet_set_num(recv_packet); i++)
        {
          if(!(0 <= page_offsets[i] && page_offsets[i] + copy_sizes[i]
               <= page->slide_size) || copy_sizes[i] < 0)
            {
              error();
            }
          
          memcpy(page->buf + page_offsets[i], out_ptr + ptr_offset, copy_sizes[i]);
          ptr_offset += copy_sizes[i];
        }
      break;
    case ACCESS_LOCAL_ATOMIC:
    case ACCESS_REMOTE_ATOMIC:
      if(packet_copy_size(recv_packet) == SYS_FULL_PAGE_SIZE)
        {
          error();
        }
      if(!(0 <= packet_page_offset(recv_packet)
           && packet_page_offset(recv_packet) + packet_copy_size(recv_packet)
           <= page->slide_size) || packet_copy_size(recv_packet) < 0)
        {
          error();
        }
      
      out_ptr = recv_packet->page_payload_ptr;
      dmi_function(page->buf + packet_page_offset(recv_packet), packet_copy_size(recv_packet), out_ptr, packet_out_size(recv_packet), NULL, 0, packet_tag(recv_packet));
      break;
    default:
      error();
    }
  
  sub_notify_watch(page);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_VALIDATE_PAGE;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  sub_increment_order(dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_validate_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_adjust_page_post(context);
  return;
}

void dmi_handle_req_invalidate_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(dmi, page->order, recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  page->owner_id = recv_packet->src_dmi_id;
  
  page->state = STATE_INVALID;
  sub_notify_watch(page);
  
  page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, 0);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_INVALIDATE_PAGE;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  sub_increment_order(dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_invalidate_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_adjust_page_post(context);
  return;
}

void context_adjust_page_post(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  
  context_count(context)++;
  if(context_count(context) == context_total(context))
    {
      vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[context_page_id(context)];
      
      pthread_mutex_lock(&page->mutex);
      
      page->owner_id = context->dmi->dmi_id;
      
      page->owner_flag = TRUE;
      
      switch(context_access_type(context))
        {
        case ACCESS_LOCAL_WRITE:
        case ACCESS_LOCAL_ATOMIC:
        case ACCESS_LOCAL_GWRITE:
        case ACCESS_LOCAL_SETSIZE:
          pthread_mutex_unlock(&page->mutex);
          
          switch(context->type)
            {
            case CONTEXT_EXCLUDE_PAGES:
              context_access_pages_post(context);
              break;
            case CONTEXT_GEXCLUDE_PAGES:
              context_gaccess_pages_post(context);
              break;
            case CONTEXT_EXCLUDE_PAGE:
              context_access_page_post(context);
              break;
            case CONTEXT_EXCLUDE_OBJECT:
              context_access_object_post(context);
              break;
            case CONTEXT_GEXCLUDE_OBJECT:
              context_gaccess_object_post(context);
              break;
            default:
              error();
            }
          break;
        case ACCESS_REMOTE_WRITE:
        case ACCESS_REMOTE_GWRITE:
        case ACCESS_REMOTE_ATOMIC:
        case ACCESS_REMOTE_SETSIZE:
          account = sub_lookup_account(page->account_vector, context_parent_dmi_context(context).dmi_id);
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_COMMIT_PAGE;
          send_packet->src_dmi_id = context->dmi->dmi_id;
          send_packet->context_id = context_parent_dmi_context(context).context_id;
          send_packet->dst_dmi_id = context_parent_dmi_context(context).dmi_id;
          send_packet->data_payload_size = 0;
          packet_ret_flag(send_packet) = TRUE;
          packet_seq(send_packet) = account->seq++;
          
          switch(context_access_type(context))
            {
            case ACCESS_REMOTE_WRITE:
            case ACCESS_REMOTE_GWRITE:
            case ACCESS_REMOTE_SETSIZE:
              send_packet->page_payload_size = 0;
              break;
            case ACCESS_REMOTE_ATOMIC:
              send_packet->page_payload_size = context_in_size(context);
              send_packet->page_payload_ptr = context_in_ptr(context);
              break;
            default:
              error();
            }
          
          dmi_send_packet(context->dmi, send_packet);
          packet_free(send_packet);
          
          dmi_free_context(context->dmi, context, TRUE);
          
          pthread_mutex_unlock(&page->mutex);
          break;
        default:
          error();  
        }
    }
  return;
}

void dmi_handle_req_commit_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *new_context;
  gate_t *vm_gate;
  vm_t *vm;
  page_t *page;
  account_t *account;
  int8_t error_flag;
  int32_t i;
  int64_t ptr_offset;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->owner_flag == TRUE)
    {
      new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
      new_context->type = CONTEXT_EXCLUDE_PAGE;
      context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
      context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
      context_vm_id(new_context) = packet_vm_id(recv_packet);
      context_page_id(new_context) = packet_page_id(recv_packet);
      context_access_type(new_context) = packet_access_type(recv_packet);
      
      switch(context_access_type(new_context))
        {
        case ACCESS_REMOTE_WRITE:
          context_page_offset(new_context) = packet_page_offset(recv_packet);
          context_copy_size(new_context) = packet_copy_size(recv_packet);
          context_out_ptr(new_context) = recv_packet->page_payload_ptr;
          break;
        case ACCESS_REMOTE_SETSIZE:
          context_page_offset(new_context) = packet_page_offset(recv_packet);
          context_copy_size(new_context) = packet_copy_size(recv_packet);
          context_slide_size(new_context) = packet_slide_size(recv_packet);
          context_out_ptr(new_context) = recv_packet->page_payload_ptr;
          break;
        case ACCESS_REMOTE_GWRITE:
          context_set_num(new_context) = packet_set_num(recv_packet);
          context_out_ptr(new_context) = recv_packet->page_payload_ptr;
          context_page_offsets(new_context) = (int64_t*)recv_packet->data_payload_ptr;
          context_copy_sizes(new_context) = (int64_t*)(recv_packet->data_payload_ptr + context_set_num(new_context) * sizeof(int64_t));
          break;
        case ACCESS_REMOTE_ATOMIC:
          context_page_offset(new_context) = packet_page_offset(recv_packet);
          context_copy_size(new_context) = packet_copy_size(recv_packet);
          context_out_size(new_context) = packet_out_size(recv_packet);
          context_in_size(new_context) = packet_in_size(recv_packet);
          context_tag(new_context) = packet_tag(recv_packet);
          context_out_ptr(new_context) = recv_packet->page_payload_ptr;
          new_context->buf = (int8_t*)my_malloc(context_in_size(new_context));
          context_in_ptr(new_context) = new_context->buf;
          break;
        default:
          error();
        }
      
      page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
      
      error_flag = FALSE;
      switch(context_access_type(new_context))
        {
        case ACCESS_REMOTE_WRITE:
          if(context_copy_size(new_context) == SYS_FULL_PAGE_SIZE)
            {
              context_copy_size(new_context) = page->slide_size - context_page_offset(new_context);
            }
          if(!(0 <= context_page_offset(new_context)
               && context_page_offset(new_context) + context_copy_size(new_context)
               <= page->slide_size) || context_copy_size(new_context) < 0)
            {
              error_flag = TRUE;
              break;
            }
          
          memcpy(page->buf + context_page_offset(new_context), context_out_ptr(new_context), context_copy_size(new_context));
          break;
        case ACCESS_REMOTE_SETSIZE:
          page->slide_size = context_slide_size(new_context);
          page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
          break;
        case ACCESS_REMOTE_GWRITE:
          ptr_offset = 0;
          for(i = 0; i < context_set_num(new_context); i++)
            {
              if(!(0 <= context_page_offsets(new_context)[i]
                   && context_page_offsets(new_context)[i] + context_copy_sizes(new_context)[i]
                   <= page->slide_size) || context_copy_sizes(new_context)[i] < 0)
                {
                  error_flag = TRUE;
                  break;
                }
            }
          for(i = 0; i < context_set_num(new_context); i++)
            {
              memcpy(page->buf + context_page_offsets(new_context)[i], context_out_ptr(new_context) + ptr_offset, context_copy_sizes(new_context)[i]);
              ptr_offset += context_copy_sizes(new_context)[i];
            }
          break;
        case ACCESS_REMOTE_ATOMIC:
          if(context_copy_size(new_context) == SYS_FULL_PAGE_SIZE)
            {
              context_copy_size(new_context) = page->slide_size - context_page_offset(new_context);
            }
          if(!(0 <= context_page_offset(new_context)
               && context_page_offset(new_context) + context_copy_size(new_context)
               <= page->slide_size) || context_copy_size(new_context) < 0)
            {
              error_flag = TRUE;
              break;
            }
          
          dmi_function(page->buf + context_page_offset(new_context), context_copy_size(new_context), context_out_ptr(new_context), context_out_size(new_context), context_in_ptr(new_context), context_in_size(new_context), context_tag(new_context));
          break;
        default:
          error();
        }
      
      sub_notify_watch(page);
      
      if(error_flag == TRUE)
        {
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_COMMIT_PAGE;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->data_payload_size = 0;
          send_packet->page_payload_size = 0;
          packet_ret_flag(send_packet) = FALSE;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          
          pthread_mutex_unlock(&page->mutex);
          return;
        }
      
      if(page->valid_num != 1)
        {
          context_adjust_page_pre(new_context);
        }
      else
        {
          account = sub_lookup_account(page->account_vector, recv_packet->src_dmi_id);
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_COMMIT_PAGE;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->data_payload_size = 0;
          packet_ret_flag(send_packet) = TRUE;
          packet_seq(send_packet) = account->seq++;
          
          switch(packet_access_type(recv_packet))
            {
            case ACCESS_REMOTE_WRITE:
            case ACCESS_REMOTE_GWRITE:
            case ACCESS_REMOTE_SETSIZE:
              send_packet->page_payload_size = 0;
              break;
            case ACCESS_REMOTE_ATOMIC:
              send_packet->page_payload_size = context_in_size(new_context);
              send_packet->page_payload_ptr = context_in_ptr(new_context);
              break;
            default:
              error();
            }
          
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          
          dmi_free_context(new_context->dmi, new_context, TRUE);
        }
    }
  else
    {
      recv_packet->dst_dmi_id = page->owner_id;
      dmi_send_packet(dmi, recv_packet);
    }
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_commit_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_exclude_page_post(context);
  return;
}

int32_t sub_check_order(dmi_t *dmi, order_t *order, packet_t *recv_packet)
{
  int32_t ret;
  int64_t load_size;
  
  load_size = recv_packet->load_size;
  
  ret = order_check(order, recv_packet);
  if(ret == FALSE)
    {
      load_increase(dmi->load, load_size);
    }
  return ret;
}

void sub_increment_order(dmi_t *dmi, page_t *page)
{
  packet_t *recv_packet;
  
  pthread_mutex_unlock(&page->mutex);
  
  recv_packet = order_increment(page->order);
  if(recv_packet != NULL)
    {
      dmi_handle_packet(dmi, recv_packet);
      
      load_decrease(dmi->load, recv_packet->load_size);
      
      packet_free(recv_packet);
    }
  
  pthread_mutex_lock(&page->mutex);
  return;
}

account_t* sub_lookup_account(vector_t *account_vector, int32_t dmi_id)
{
  account_t *account;
  
  account = (account_t*)vector_at(account_vector, dmi_id);
  if(account == NULL)
    {
      account = account_alloc();
      account->stamp = 0;
      account->seq = 0;
      account->state = STATE_INVALID;
      
      vector_assign(account_vector, dmi_id, account);
    }
  return account;
}

/* sweep page */

void* dmi_sweeper(void *arg)
{
  dmi_t *dmi;
  context_t *new_context;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  vector_t *vm_id_vector;
  status_t *status;
  window_t *window;
  struct timeval tv;
  int8_t stop_flag;
  int8_t *used_flags;
  int32_t vm_id, vm_num, ret, i, j, step;
  int64_t page_id, sweeped_size, total_size, max_size;
  
  dmi = (dmi_t*)arg;
  
  gettimeofday(&tv, NULL);
  mrand_init(tv.tv_usec);
  
  vm_id_vector = vector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
    
  window = window_alloc(CONST_PAGE_WINDOW_SIZE);
  
  while(1)
    {
      ret = gmemory_monitor(dmi->gmemory, &total_size, &max_size);
      if(ret == FALSE)
        {
          break;
        }
      
      sweeped_size = 0;
      
      dmi_order_vms(dmi, vm_id_vector);
      
      stop_flag = FALSE;
      vm_num = vector_size(vm_id_vector);
      for(i = 0; i < vm_num && stop_flag == FALSE; i++)
        {
          vm_id = (int32_t)(intptr_t)vector_at(vm_id_vector, i);
          vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
          
          ret = gate_enter(vm_gate);
          if(ret == FALSE)
            {
              continue;
            }
          vm = (vm_t*)vm_gate->body;
          
          used_flags = (int8_t*)my_malloc(vm->page_num * sizeof(int8_t));
          for(j = 0; j < vm->page_num; j++)
            {
              used_flags[j] = FALSE;
            }
          
          for(step = 0; step <= 2; step++)
            {
              for(page_id = 0; page_id < vm->page_num; page_id++)
                {
                  if(used_flags[page_id] == TRUE)
                    {
                      continue;
                    }
                  
                  page = vm->page_table[page_id];
                  
                  if((step >= 0
                      && page->decor == 0
                      && page->buf_size != 0
                      && (page->state == STATE_DOWNVALID || page->state == STATE_UPVALID)
                      && page->owner_flag == FALSE)
                     ||
                     (step >= 1
                      && page->decor == 0
                      && page->buf_size != 0
                      && (page->state == STATE_DOWNVALID || page->state == STATE_UPVALID)
                      && page->owner_flag == TRUE
                      && page->valid_num >= 2)
                     ||
                     (step >= 2
                      && page->decor == 0
                      && page->buf_size != 0
                      && (page->state == STATE_DOWNVALID || page->state == STATE_UPVALID)
                      && page->owner_flag == TRUE
                      && page->valid_num == 1))
                    {
                      status = window_expand(window);
                      
                      new_context = dmi_alloc_context(dmi, status, TYPE_MASTER);
                      new_context->type = CONTEXT_SWEEP_PAGE;
                      context_vm_id(new_context) = vm_id;
                      context_page_id(new_context) = page_id;
                      
                      context_sweep_page_pre(new_context);
                      
                      sweeped_size += page->buf_size;
                      
                      if(total_size - sweeped_size <= (1 - CONST_GMEMORY_USAGE_RATE) * max_size)
                        {
                          stop_flag = TRUE;
                          break;
                        }
                      
                      used_flags[page_id] = TRUE;
                    }
                }
            } 
          
          gate_escape(vm_gate);
          
          my_free(used_flags);
        }
      
      window_flush(window);
    }
  
  window_free(window);
  
  vector_free(vm_id_vector);
  return NULL;
}

void dmi_order_vms(dmi_t *dmi, vector_t *vm_id_vector)
{
  gate_t *vm_gate;
  vm_t *vm;
  page_t *page;
  int32_t i, j, count, vm_id, vm_num, tmp_vm_id, ret;
  int32_t *vm_ids;
  int64_t tmp_page_size;
  int64_t *page_sizes;
  
  vm_num = xvector_size(dmi->vm_gate_xvector);
  page_sizes = (int64_t*)my_malloc(vm_num * sizeof(int64_t));
  vm_ids = (int32_t*)my_malloc(vm_num * sizeof(int32_t));
  
  count = 0;
  for(vm_id = 0; vm_id < vm_num; vm_id++)
    {
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, vm_id);
      ret = gate_enter(vm_gate);
      if(ret == FALSE)
        {
          page_sizes[vm_id] = 0;
          continue;
        }
      vm = (vm_t*)vm_gate->body;
      
      if(vm->page_num > 0)
        {
          page = vm->page_table[0];
          page_sizes[vm_id] = page->slide_size;
        }
      else
        {
          page_sizes[vm_id] = 0;
        }
      count++;
      
      gate_escape(vm_gate);
    }
  
  for(i = 0; i < vm_num; i++)
    {
      vm_ids[i] = i;
    }
  
  for(i = 0; i < vm_num; i++)
    {
      tmp_vm_id = vm_ids[i];
      tmp_page_size = page_sizes[vm_ids[i]];
      for(j = i; j > 0 && page_sizes[vm_ids[j - 1]] < tmp_page_size; j--)
        {
          vm_ids[j] = vm_ids[j - 1];
          page_sizes[vm_ids[j]] = page_sizes[vm_ids[j - 1]];
        }
      vm_ids[j] = tmp_vm_id;
      page_sizes[vm_ids[j]] = tmp_page_size;
    }
  
  vector_clear(vm_id_vector);
  for(i = 0; i < count; i++)
    {
      vector_assign(vm_id_vector, i, (void*)(intptr_t)vm_ids[i]);
    }
  
  my_free(page_sizes);
  my_free(vm_ids);
  return;
}

void dmi_kill_sweeper(dmi_t *dmi)
{
  gmemory_disable(dmi->gmemory);
  return;
}

void context_sweep_page_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  ret = gate_enter(vm_gate);
  if(ret == FALSE)
    {
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  vm = (vm_t*)vm_gate->body;
  
  if(!(0 <= context_page_id(context) && context_page_id(context) < vm->page_num))
    {
      gate_escape(vm_gate);
      
      dmi_free_context(context->dmi, context, FALSE);
      return;
    }
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->state == STATE_DOWNVALID || page->state == STATE_UPVALID)
    {
      send_packet = packet_alloc();
      send_packet->type = PACKET_REQ_SWEEP_PAGE;
      send_packet->src_dmi_id = context->dmi->dmi_id;
      send_packet->context_id = context->context_id;
      send_packet->dst_dmi_id = page->owner_id;
      send_packet->page_payload_size = 0;
      send_packet->data_payload_size = 0;
      packet_vm_id(send_packet) = context_vm_id(context);
      packet_page_id(send_packet) = context_page_id(context);
      dmi_send_packet(context->dmi, send_packet);
      packet_free(send_packet);
      
      pthread_mutex_unlock(&page->mutex);
    }
  else
    {
      pthread_mutex_unlock(&page->mutex);
      
      gate_escape(vm_gate);
      
      switch(context->type)
        {
        case CONTEXT_SWEEP_PAGE:
          dmi_free_context(context->dmi, context, TRUE);
          break;
        case CONTEXT_LEAVE_WORLD:
          context_clear_pages_post(context);
          break;
        default:
          error();
        }
    }
  return;
}

void dmi_handle_req_sweep_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  context_t *new_context;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  int32_t owner_id;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  if(page->owner_flag == TRUE)
    {
      if(recv_packet->src_dmi_id == dmi->dmi_id)
        {
          owner_id = dmi_enter_page_heir(dmi, page);
          if(owner_id == SYS_ID_UNDEF)
            {
              account = sub_lookup_account(page->account_vector, recv_packet->src_dmi_id);
              
              send_packet = packet_alloc();
              send_packet->type = PACKET_ACK_SWEEP_PAGE;
              send_packet->src_dmi_id = dmi->dmi_id;
              send_packet->context_id = recv_packet->context_id;
              send_packet->dst_dmi_id = recv_packet->src_dmi_id;
              send_packet->page_payload_size = 0;
              send_packet->data_payload_size = 0;
              packet_seq(send_packet) = account->seq++;
              packet_ret_flag(send_packet) = FALSE;
              dmi_send_packet(dmi, send_packet);
              packet_free(send_packet);
              
              pthread_mutex_unlock(&page->mutex);
            }
          else
            { 
              new_context = dmi_alloc_context(dmi, NULL, TYPE_SLAVE);
              new_context->type = CONTEXT_SWEEP_PAGE;
              new_context->recv_packet = recv_packet;
              context_parent_dmi_context(new_context).dmi_id = recv_packet->src_dmi_id;
              context_parent_dmi_context(new_context).context_id = recv_packet->context_id;
              context_vm_id(new_context) = packet_vm_id(recv_packet);
              context_page_id(new_context) = packet_page_id(recv_packet);
              context_owner_id(new_context) = owner_id;
              
              context_delegate_page_pre(new_context);
              
              pthread_mutex_unlock(&page->mutex);
            }
        }
      else
        {
          account = sub_lookup_account(page->account_vector, recv_packet->src_dmi_id);
          
          if(account->state == STATE_DOWNVALID || account->state == STATE_UPVALID)
            {
              account->state = STATE_INVALID;
              page->valid_num--;
            }
          
          send_packet = packet_alloc();
          send_packet->type = PACKET_ACK_SWEEP_PAGE;
          send_packet->src_dmi_id = dmi->dmi_id;
          send_packet->context_id = recv_packet->context_id;
          send_packet->dst_dmi_id = recv_packet->src_dmi_id;
          send_packet->page_payload_size = 0;
          send_packet->data_payload_size = 0;
          packet_seq(send_packet) = account->seq++;
          packet_ret_flag(send_packet) = TRUE;
          dmi_send_packet(dmi, send_packet);
          packet_free(send_packet);
          
          pthread_mutex_unlock(&page->mutex);
        }
    }
  else
    {
      recv_packet->dst_dmi_id = page->owner_id;
      dmi_send_packet(dmi, recv_packet);
      
      pthread_mutex_unlock(&page->mutex);
    }
  return;
}

int32_t dmi_enter_page_heir(dmi_t *dmi, page_t *page)
{
  account_t *account;
  gate_t *peer_gate;
  int32_t dmi_id, account_num, peer_gate_num, i, ret;
  
  if(page->valid_num >= 2)
    {
      account_num = vector_size(page->account_vector);
      dmi_id = mrand_int(0, account_num - 1);
      for(i = 0; i < account_num; i++)
        {
          account = (account_t*)vector_at(page->account_vector, dmi_id);
          if(dmi_id != dmi->dmi_id && account != NULL 
             && (account->state == STATE_DOWNVALID || account->state == STATE_UPVALID))
            {
              peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, dmi_id);
              ret = gate_enter(peer_gate);
              if(ret == TRUE)
                {
                  return dmi_id;
                }
            }
          dmi_id = (dmi_id + 1) % account_num;
        }
    }
  
  peer_gate_num = xvector_size(dmi->peer_gate_xvector);
  dmi_id = mrand_int(0, peer_gate_num - 1);
  for(i = 0; i < peer_gate_num; i++)
    {
      if(dmi_id != dmi->dmi_id)
        {
          peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, dmi_id);
          ret = gate_enter(peer_gate);
          if(ret == TRUE)
            {
              return dmi_id;
            }
        }
      dmi_id = (dmi_id + 1) % peer_gate_num;
    }
  return SYS_ID_UNDEF;
}

void dmi_escape_page_heir(dmi_t *dmi, int32_t owner_id)
{
  gate_t *peer_gate;
  
  peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, owner_id);
  gate_escape(peer_gate);
  return;
}

void context_delegate_page_pre(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  writebuf_t *writebuf;
  int32_t dmi_id, account_num, count;
  int64_t offset;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  page->owner_flag = FALSE;
  
  account = sub_lookup_account(page->account_vector, context_owner_id(context));
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_DELEGATE_PAGE;
  send_packet->src_dmi_id = context->dmi->dmi_id;
  send_packet->context_id = context->context_id;
  send_packet->dst_dmi_id = context_owner_id(context);
  packet_slide_size(send_packet) = page->slide_size;
  packet_vm_id(send_packet) = packet_vm_id(context->recv_packet);
  packet_page_id(send_packet) = packet_page_id(context->recv_packet);
  packet_seq(send_packet) = account->seq++;
  
  if(account->state == STATE_INVALID)
    {
      send_packet->page_payload_size = page->buf_size;
      send_packet->page_payload_ptr = page->buf;
      
      account->state = STATE_DOWNVALID;
      account->stamp = page->stamp++;
      page->valid_num++;
    }
  else
    {
      send_packet->page_payload_size = 0;
    }
  
  packet_state(send_packet) = account->state;
  
  packet_valid_num(send_packet) = page->valid_num;
  packet_stamp(send_packet) = page->stamp;
  
  writebuf = writebuf_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  
  account_num = vector_size(page->account_vector);
  offset = writebuf_skip(writebuf, sizeof(int32_t));
  count = 0;
  for(dmi_id = 0; dmi_id < account_num; dmi_id++)
    {
      account = (account_t*)vector_at(page->account_vector, dmi_id);
      if(account != NULL)
        {
          writebuf_copy(writebuf, &dmi_id, sizeof(int32_t));
          writebuf_copy(writebuf, &account->seq, sizeof(int32_t));
          writebuf_copy(writebuf, &account->stamp, sizeof(int32_t));
          writebuf_copy(writebuf, &account->state, sizeof(int8_t));
          account_free(account);
          
          vector_assign(page->account_vector, dmi_id, NULL);
          
          count++;
        }
    }
  writebuf_seekcopy(writebuf, offset, &count, sizeof(int32_t));
  
  send_packet->data_payload_size = writebuf_size(writebuf);
  send_packet->data_payload_ptr = writebuf_buf(writebuf);
  
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  writebuf_free(writebuf);
  
  dmi_escape_page_heir(context->dmi, context_owner_id(context));
  return;
}

void dmi_handle_req_delegate_page(dmi_t *dmi, packet_t *recv_packet)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  account_t *account;
  gate_t *vm_gate;
  readbuf_t *readbuf;
  int32_t dmi_id, i, account_num, ret;
  
  vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[packet_page_id(recv_packet)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(dmi, page->order, recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  page->owner_id = dmi->dmi_id;
  
  page->owner_flag = TRUE;
  
  page->state = packet_state(recv_packet);
  page->slide_size = packet_slide_size(recv_packet);
  page->buf = gmemory_change(dmi->gmemory, page->buf, &page->buf_size, page->slide_size);
  sub_notify_watch(page);
  
  if(recv_packet->page_payload_size != 0)
    {
      memcpy(page->buf, recv_packet->page_payload_ptr, page->buf_size);
    }
  
  page->valid_num = packet_valid_num(recv_packet);
  page->stamp = packet_stamp(recv_packet);
  
  readbuf = readbuf_alloc(recv_packet->data_payload_ptr, recv_packet->data_payload_size);
  
  readbuf_copy(readbuf, &account_num, sizeof(int32_t));
  for(i = 0; i < account_num; i++)
    {
      account = account_alloc();
      readbuf_copy(readbuf, &dmi_id, sizeof(int32_t));
      readbuf_copy(readbuf, &account->seq, sizeof(int32_t));
      readbuf_copy(readbuf, &account->stamp, sizeof(int32_t));
      readbuf_copy(readbuf, &account->state, sizeof(int8_t));
      
      vector_assign(page->account_vector, dmi_id, account);
    }
  
  readbuf_free(readbuf);
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_ACK_DELEGATE_PAGE;
  send_packet->src_dmi_id = dmi->dmi_id;
  send_packet->context_id = recv_packet->context_id;
  send_packet->dst_dmi_id = recv_packet->src_dmi_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  dmi_send_packet(dmi, send_packet);
  packet_free(send_packet);
  
  sub_increment_order(dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  return;
}

void dmi_handle_ack_delegate_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_delegate_page_post(context);
  return;
}

void context_delegate_page_post(context_t *context)
{
  packet_t *send_packet;
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  page->owner_id = context->recv_packet->src_dmi_id;
  
  send_packet = packet_alloc();
  send_packet->type = PACKET_REQ_SWEEP_PAGE;
  send_packet->src_dmi_id = context_parent_dmi_context(context).dmi_id;
  send_packet->context_id = context_parent_dmi_context(context).context_id;
  send_packet->dst_dmi_id = page->owner_id;
  send_packet->page_payload_size = 0;
  send_packet->data_payload_size = 0;
  packet_vm_id(send_packet) = context_vm_id(context);
  packet_page_id(send_packet) = context_page_id(context);
  dmi_send_packet(context->dmi, send_packet);
  packet_free(send_packet);
  
  pthread_mutex_unlock(&page->mutex);
  
  dmi_free_context(context->dmi, context, TRUE);
  return;
}

void dmi_handle_ack_sweep_page(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  
  context = dmi_get_context(dmi, recv_packet->context_id);
  context->recv_packet = recv_packet;
  
  context_sweep_page_post(context);
  return;
}

void context_sweep_page_post(context_t *context)
{
  vm_t *vm;
  page_t *page;
  gate_t *vm_gate;
  int32_t ret;
  
  vm_gate = (gate_t*)xvector_at(context->dmi->vm_gate_xvector, context_vm_id(context));
  vm = (vm_t*)vm_gate->body;
  page = vm->page_table[context_page_id(context)];
  
  pthread_mutex_lock(&page->mutex);
  
  ret = sub_check_order(context->dmi, page->order, context->recv_packet);
  if(ret == FALSE)
    {
      pthread_mutex_unlock(&page->mutex);
      return;
    }
  
  page->owner_id = context->recv_packet->src_dmi_id;
  
  if(packet_ret_flag(context->recv_packet) == TRUE)
    {
      page->state = STATE_INVALID;
      sub_notify_watch(page);
      
      page->buf = gmemory_change(context->dmi->gmemory, page->buf, &page->buf_size, 0);
    }
  
  sub_increment_order(context->dmi, page);
  
  pthread_mutex_unlock(&page->mutex);
  
  gate_escape(vm_gate);
  
  switch(context->type)
    {
    case CONTEXT_SWEEP_PAGE:
      dmi_free_context(context->dmi, context, TRUE);
      break;
    case CONTEXT_LEAVE_WORLD:
      context_clear_pages_post(context);
      break;
    default:
      error();
    }
  return;
}

/* methods */

void* dmi_recver(void *arg)
{
  dmi_t *dmi;
  packet_t *recv_packet;
  struct timeval tv;
  int32_t ret;
  
  dmi = (dmi_t*)arg;
  
  gettimeofday(&tv, NULL);
  mrand_init(tv.tv_usec);
  
  while(1)
    {
      recv_packet = packet_alloc();
      
      ret = comm_recv(dmi->comm, recv_packet);
      if(ret == TRUE)
        {
          recv_packet->load_size = dmi_estimate_packet(dmi, recv_packet);
          
          load_increase(dmi->load, recv_packet->load_size);
          
          taskque_unshift(dmi->packet_taskque, recv_packet);
        }
      else
        {
          packet_free(recv_packet);
          break;
        }
    }
  return NULL;
}

void dmi_kill_recver(dmi_t *dmi)
{
  comm_disable(dmi->comm);
  return;
}

void* dmi_handler(void *arg)
{
  dmi_t *dmi;
  packet_t *recv_packet;
  struct timeval tv;
  
  dmi = (dmi_t*)arg;
  
  gettimeofday(&tv, NULL);
  mrand_init(tv.tv_usec);
  
  while(1)
    {
      recv_packet = (packet_t*)taskque_pop(dmi->packet_taskque);
      if(recv_packet == NULL)
        {
          break;
        }
      
#if DEBUG_PACKET
      packet_print(recv_packet, TYPE_HANDLE);
#endif
      
      dmi_handle_packet(dmi, recv_packet);
      
      load_decrease(dmi->load, recv_packet->load_size);
      
#if DEBUG_PACKET
      fprintf(stderr, "HANDLED\n");
#endif
      
      packet_free(recv_packet);
    }
  return NULL;
}

void dmi_kill_handler(dmi_t *dmi)
{
  taskque_notify(dmi->packet_taskque);
  return;
}

int64_t dmi_estimate_packet(dmi_t *dmi, packet_t *recv_packet)
{
  context_t *context;
  gate_t *vm_gate;
  vm_t *vm;
  page_t *page;
  account_t *account;
  int32_t i, count, dmi_id, account_num;
  int64_t load_size, copy_size;
  int64_t *copy_sizes;
  
  load_size = sizeof(packet_t) * 4;
  
  switch(recv_packet->type)
    {
    case PACKET_REQ_CREATE_THREAD:
    case PACKET_ACK_CREATE_THREAD:
    case PACKET_REQ_JOIN_THREAD:
    case PACKET_ACK_JOIN_THREAD:
    case PACKET_REQ_DETACH_THREAD:
    case PACKET_ACK_DETACH_THREAD:
    case PACKET_REQ_WAKE_THREAD:
    case PACKET_ACK_WAKE_THREAD:
    case PACKET_REQ_MIGRATE_THREAD:
    case PACKET_ACK_MIGRATE_THREAD:
    case PACKET_REQ_YIELD_THREAD:
    case PACKET_ACK_YIELD_THREAD:
    case PACKET_REQ_LOCK_TOKEN:
    case PACKET_ACK_LOCK_TOKEN:
    case PACKET_REQ_UNLOCK_TOKEN:
    case PACKET_ACK_UNLOCK_TOKEN:
    case PACKET_REQ_DELEGATE_TOKEN:
    case PACKET_ACK_DELEGATE_TOKEN:
    case PACKET_REQ_HELLO_WORLD:
    case PACKET_ACK_HELLO_WORLD:
    case PACKET_REQ_ALLOC_PEER:
    case PACKET_ACK_ALLOC_PEER:
    case PACKET_REQ_PERMIT_PEER:
    case PACKET_ACK_PERMIT_PEER:
    case PACKET_REQ_FORBID_PEER:
    case PACKET_ACK_FORBID_PEER:
    case PACKET_REQ_FREE_PEER:
    case PACKET_ACK_FREE_PEER:
    case PACKET_REQ_ALLOC_VMS:
    case PACKET_ACK_ALLOC_VMS:
    case PACKET_REQ_PERMIT_VMS:
    case PACKET_ACK_PERMIT_VMS:
    case PACKET_REQ_FORBID_VMS:
    case PACKET_ACK_FORBID_VMS:
    case PACKET_REQ_FREE_VMS:
    case PACKET_ACK_FREE_VMS:
    case PACKET_REQ_BYE_WORLD:
    case PACKET_ACK_BYE_WORLD:
      break;
    case PACKET_REQ_READ_PAGE:
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[packet_page_id(recv_packet)];
      
      if(page->owner_flag == TRUE)
        {
          account = (account_t*)vector_at(page->account_vector, recv_packet->src_dmi_id);
          if(account == NULL || account->state == STATE_INVALID)
            {
              switch(packet_access_type(recv_packet))
                {
                case ACCESS_ONCE_READ:
                  load_size = packet_copy_size(recv_packet);
                  break;
                case ACCESS_ONCE_GREAD:
                  copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
                  load_size = 0;
                  for(i = 0; i < packet_set_num(recv_packet); i++)
                    {
                      load_size += copy_sizes[i];
                    }
                  break;
                case ACCESS_ONCE_GETSIZE:
                  break;
                case ACCESS_INVALIDATE_READ:
                case ACCESS_INVALIDATE_GREAD:
                case ACCESS_INVALIDATE_GETSIZE:
                case ACCESS_UPDATE_READ:
                case ACCESS_UPDATE_GREAD:
                case ACCESS_UPDATE_GETSIZE:
                  load_size = page->slide_size;
                  break;
                default:
                  error();
                }
            }
        }
      break;
    case PACKET_ACK_READ_PAGE:
      break;
    case PACKET_REQ_RELAY_PAGE:
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[packet_page_id(recv_packet)];
      
      switch(packet_access_type(recv_packet))
        {
        case ACCESS_ONCE_READ:
          load_size = packet_copy_size(recv_packet);
          break;
        case ACCESS_ONCE_GREAD:
          copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
          load_size = 0;
          for(i = 0; i < packet_set_num(recv_packet); i++)
            {
              load_size += copy_sizes[i];
            }
          break;
        case ACCESS_ONCE_GETSIZE:
          break;
        case ACCESS_INVALIDATE_READ:
        case ACCESS_INVALIDATE_GREAD:
        case ACCESS_INVALIDATE_GETSIZE:
        case ACCESS_UPDATE_READ:
        case ACCESS_UPDATE_GREAD:
        case ACCESS_UPDATE_GETSIZE:
          load_size = page->slide_size;
          break;
        default:
          error();
        }
      break;
    case PACKET_ACK_RELAY_PAGE:
      break;
    case PACKET_REQ_STEAL_PAGE:
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[packet_page_id(recv_packet)];
      
      if(page->owner_flag == TRUE)
        {
          account = (account_t*)vector_at(page->account_vector, recv_packet->src_dmi_id);
          if(account == NULL || account->state == STATE_INVALID)
            {
              load_size = page->slide_size;
            }
        }
      break;
    case PACKET_ACK_STEAL_PAGE:
      context = dmi_get_context(dmi, recv_packet->context_id);
      
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, context_vm_id(context));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[context_page_id(context)];
      
      copy_size = 0;
      switch(context_access_type(context))
        {
        case ACCESS_LOCAL_WRITE:
        case ACCESS_LOCAL_GWRITE:
        case ACCESS_LOCAL_SETSIZE:
          copy_size = context_copy_size(context);
          break;
        case ACCESS_LOCAL_ATOMIC:
          copy_size = context_out_size(context) + context_in_size(context);
          break;
        default:
          error();
        }
      
      count = 0;
      account_num = vector_size(page->account_vector);
      for(dmi_id = 0; dmi_id < account_num; dmi_id++)
        {
          account = (account_t*)vector_at(page->account_vector, dmi_id);
          if(dmi_id != dmi->dmi_id && account != NULL && account->state == STATE_UPVALID)
            {
              count++;
            }
        }
      load_size = count * copy_size + (page->valid_num - count) * sizeof(packet_t) * 4;
      break;
    case PACKET_REQ_MIGRATE_PAGE:
      break;
    case PACKET_ACK_MIGRATE_PAGE:
      break;
    case PACKET_REQ_VALIDATE_PAGE:
      break;
    case PACKET_ACK_VALIDATE_PAGE:
      break;
    case PACKET_REQ_INVALIDATE_PAGE:
      break;
    case PACKET_ACK_INVALIDATE_PAGE:
      break;
    case PACKET_REQ_COMMIT_PAGE:
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[packet_page_id(recv_packet)];
      
      if(page->owner_flag == TRUE)
        {
          copy_size = 0;
          switch(packet_access_type(recv_packet))
            {
            case ACCESS_REMOTE_WRITE:
              copy_size = packet_copy_size(recv_packet);
              break;
            case ACCESS_REMOTE_GWRITE:
              copy_sizes = (int64_t*)(recv_packet->data_payload_ptr + packet_set_num(recv_packet) * sizeof(int64_t));
              copy_size = 0;
              for(i = 0; i < packet_set_num(recv_packet); i++)
                {
                  copy_size += copy_sizes[i];
                }
              break;
            case ACCESS_REMOTE_ATOMIC:
              copy_size = packet_out_size(recv_packet) + packet_in_size(recv_packet);
              break;
            case ACCESS_REMOTE_SETSIZE:
              break;
            default:
              error();
            }
          
          count = 0;
          account_num = vector_size(page->account_vector);
          for(dmi_id = 0; dmi_id < account_num; dmi_id++)
            {
              account = (account_t*)vector_at(page->account_vector, dmi_id);
              if(dmi_id != dmi->dmi_id && account != NULL && account->state == STATE_UPVALID)
                {
                  count++;
                }
            }
          load_size = count * copy_size + (page->valid_num - count) * sizeof(packet_t) * 4;
        }
      break;
    case PACKET_ACK_COMMIT_PAGE:
      break;
    case PACKET_REQ_SWEEP_PAGE:
      vm_gate = (gate_t*)xvector_at(dmi->vm_gate_xvector, packet_vm_id(recv_packet));
      vm = (vm_t*)vm_gate->body;
      page = vm->page_table[packet_page_id(recv_packet)];
      
      if(page->owner_flag == TRUE)
        {
          if(recv_packet->src_dmi_id == dmi->dmi_id)
            {
              load_size = page->slide_size / 2;
            }
        }
      break;
    case PACKET_ACK_SWEEP_PAGE:
      break;
    case PACKET_REQ_DELEGATE_PAGE:
      break;
    case PACKET_ACK_DELEGATE_PAGE:
      break;
    default:
      error();
    }
  return load_size;
}

void dmi_handle_packet(dmi_t *dmi, packet_t *recv_packet)
{
  switch(recv_packet->type)
    {
    case PACKET_REQ_CREATE_THREAD:
      dmi_handle_req_create_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_CREATE_THREAD:
      dmi_handle_ack_create_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_JOIN_THREAD:
      dmi_handle_req_join_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_JOIN_THREAD:
      dmi_handle_ack_join_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_DETACH_THREAD:
      dmi_handle_req_detach_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_DETACH_THREAD:
      dmi_handle_ack_detach_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_WAKE_THREAD:
      dmi_handle_req_wake_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_WAKE_THREAD:
      dmi_handle_ack_wake_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_MIGRATE_THREAD:
      dmi_handle_req_migrate_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_MIGRATE_THREAD:
      dmi_handle_ack_migrate_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_YIELD_THREAD:
      dmi_handle_req_yield_thread(dmi, recv_packet);
      break;
    case PACKET_ACK_YIELD_THREAD:
      dmi_handle_ack_yield_thread(dmi, recv_packet);
      break;
    case PACKET_REQ_LOCK_TOKEN:
      dmi_handle_req_lock_token(dmi, recv_packet);
      break;
    case PACKET_ACK_LOCK_TOKEN:
      dmi_handle_ack_lock_token(dmi, recv_packet);
      break;
    case PACKET_REQ_UNLOCK_TOKEN:
      dmi_handle_req_unlock_token(dmi, recv_packet);
      break;
    case PACKET_ACK_UNLOCK_TOKEN:
      dmi_handle_ack_unlock_token(dmi, recv_packet);
      break;
    case PACKET_REQ_DELEGATE_TOKEN:
      dmi_handle_req_delegate_token(dmi, recv_packet);
      break;
    case PACKET_ACK_DELEGATE_TOKEN:
      dmi_handle_ack_delegate_token(dmi, recv_packet);
      break;
    case PACKET_REQ_HELLO_WORLD:
      dmi_handle_req_hello_world(dmi, recv_packet);
      break;
    case PACKET_ACK_HELLO_WORLD:
      dmi_handle_ack_hello_world(dmi, recv_packet);
      break;
    case PACKET_REQ_ALLOC_PEER:
      dmi_handle_req_alloc_peer(dmi, recv_packet);
      break;
    case PACKET_ACK_ALLOC_PEER:
      dmi_handle_ack_alloc_peer(dmi, recv_packet);
      break;
    case PACKET_REQ_PERMIT_PEER:
      dmi_handle_req_permit_peer(dmi, recv_packet);
      break;
    case PACKET_ACK_PERMIT_PEER:
      dmi_handle_ack_permit_peer(dmi, recv_packet);
      break;
    case PACKET_REQ_FORBID_PEER:
      dmi_handle_req_forbid_peer(dmi, recv_packet);
      break;
    case PACKET_ACK_FORBID_PEER:
      dmi_handle_ack_forbid_peer(dmi, recv_packet);
      break;
    case PACKET_REQ_FREE_PEER:
      dmi_handle_req_free_peer(dmi, recv_packet);
      break;
    case PACKET_ACK_FREE_PEER:
      dmi_handle_ack_free_peer(dmi, recv_packet);
      break;
    case PACKET_REQ_ALLOC_VMS:
      dmi_handle_req_alloc_vms(dmi, recv_packet);
      break;
    case PACKET_ACK_ALLOC_VMS:
      dmi_handle_ack_alloc_vms(dmi, recv_packet);
      break;
    case PACKET_REQ_PERMIT_VMS:
      dmi_handle_req_permit_vms(dmi, recv_packet);
      break;
    case PACKET_ACK_PERMIT_VMS:
      dmi_handle_ack_permit_vms(dmi, recv_packet);
      break;
    case PACKET_REQ_FORBID_VMS:
      dmi_handle_req_forbid_vms(dmi, recv_packet);
      break;
    case PACKET_ACK_FORBID_VMS:
      dmi_handle_ack_forbid_vms(dmi, recv_packet);
      break;
    case PACKET_REQ_FREE_VMS:
      dmi_handle_req_free_vms(dmi, recv_packet);
      break;
    case PACKET_ACK_FREE_VMS:
      dmi_handle_ack_free_vms(dmi, recv_packet);
      break;
    case PACKET_REQ_BYE_WORLD:
      dmi_handle_req_bye_world(dmi, recv_packet);
      break;
    case PACKET_ACK_BYE_WORLD:
      dmi_handle_ack_bye_world(dmi, recv_packet);
      break;
    case PACKET_REQ_READ_PAGE:
      dmi_handle_req_read_page(dmi, recv_packet);
      break;
    case PACKET_ACK_READ_PAGE:
      dmi_handle_ack_read_page(dmi, recv_packet);
      break;
    case PACKET_REQ_RELAY_PAGE:
      dmi_handle_req_relay_page(dmi, recv_packet);
      break;
    case PACKET_ACK_RELAY_PAGE:
      dmi_handle_ack_relay_page(dmi, recv_packet);
      break;
    case PACKET_REQ_STEAL_PAGE:
      dmi_handle_req_steal_page(dmi, recv_packet);
      break;
    case PACKET_ACK_STEAL_PAGE:
      dmi_handle_ack_steal_page(dmi, recv_packet);
      break;
    case PACKET_REQ_MIGRATE_PAGE:
      dmi_handle_req_migrate_page(dmi, recv_packet);
      break;
    case PACKET_ACK_MIGRATE_PAGE:
      dmi_handle_ack_migrate_page(dmi, recv_packet);
      break;
    case PACKET_REQ_VALIDATE_PAGE:
      dmi_handle_req_validate_page(dmi, recv_packet);
      break;
    case PACKET_ACK_VALIDATE_PAGE:
      dmi_handle_ack_validate_page(dmi, recv_packet);
      break;
    case PACKET_REQ_INVALIDATE_PAGE:
      dmi_handle_req_invalidate_page(dmi, recv_packet);
      break;
    case PACKET_ACK_INVALIDATE_PAGE:
      dmi_handle_ack_invalidate_page(dmi, recv_packet);
      break;
    case PACKET_REQ_COMMIT_PAGE:
      dmi_handle_req_commit_page(dmi, recv_packet);
      break;
    case PACKET_ACK_COMMIT_PAGE:
      dmi_handle_ack_commit_page(dmi, recv_packet);
      break;
    case PACKET_REQ_SWEEP_PAGE:
      dmi_handle_req_sweep_page(dmi, recv_packet);
      break;
    case PACKET_ACK_SWEEP_PAGE:
      dmi_handle_ack_sweep_page(dmi, recv_packet);
      break;
    case PACKET_REQ_DELEGATE_PAGE:
      dmi_handle_req_delegate_page(dmi, recv_packet);
      break;
    case PACKET_ACK_DELEGATE_PAGE:
      dmi_handle_ack_delegate_page(dmi, recv_packet);
      break;
    default:
      error();
    }
  return;
}

void dmi_send_packet(dmi_t *dmi, packet_t *send_packet)
{
  send_packet->via_dmi_id = dmi->dmi_id;
  
  comm_send(dmi->comm, dmi->dmi_id, send_packet->dst_dmi_id, send_packet);
  return;
}

void dmi_bcast_packet(dmi_t *dmi, packet_t *send_packet, int32_t *peer_num_ptr)
{
  gate_t *peer_gate;
  int32_t i, count, dmi_id, peer_gate_num;
  int32_t *dmi_ids;
  
  peer_gate_num = xvector_size(dmi->peer_gate_xvector);
  
  dmi_ids = (int32_t*)my_malloc(peer_gate_num * sizeof(int32_t));
  
  count = 0;
  for(dmi_id = 0; dmi_id < peer_gate_num; dmi_id++)
    {
      peer_gate = (gate_t*)xvector_at(dmi->peer_gate_xvector, dmi_id);
      if(peer_gate->body != NULL)
        {
          dmi_ids[count] = dmi_id;
          count++;
        }
    }
  *peer_num_ptr = count;
  
  for(i = 0; i < count; i++)
    {
      send_packet->dst_dmi_id = dmi_ids[i];
      dmi_send_packet(dmi, send_packet);
    }
  
  my_free(dmi_ids);
  return;
}

context_t* dmi_alloc_context(dmi_t *dmi, status_t *status, int8_t type)
{
  context_t *context;
  xlease_t *context_xlease;
  int32_t ret;
  
  if(type == TYPE_MASTER)
    {
      ret = gate_enter(dmi->contexts_gate);
      if(ret == FALSE)
        {
          return NULL;
        }
    }
  context_xlease = (xlease_t*)dmi->contexts_gate->body;
  
  context = context_alloc();
  
  if(type == TYPE_MASTER)
    {
      context->master_flag = TRUE;
    }
  else
    {
      context->master_flag = FALSE;
    }
  
  if(status == NULL)
    {
      context->status_flag = FALSE;
    }
  else
    {
      context->status_flag = TRUE;
      context->async = status->async;
    }
  
  context->dmi = dmi;
  context->context_id = xlease_putin(context_xlease, context);
  return context;
}

void dmi_free_context(dmi_t *dmi, context_t *context, int8_t ret_flag)
{
  xlease_t *context_xlease;
  int8_t master_flag;
  
  context_xlease = (xlease_t*)dmi->contexts_gate->body;
  
  context = xlease_pickup(context_xlease, context->context_id);
  
  if(context->status_flag == TRUE)
    {
      async_finish(context->async, ret_flag);
    }
  
  master_flag = context->master_flag;
  
  context_free(context);
  
  if(master_flag == TRUE)
    {
      gate_escape(dmi->contexts_gate);
    }
  return;
}

context_t* dmi_get_context(dmi_t *dmi, int32_t context_id)
{
  xlease_t *context_xlease;
  context_t *context;
  
  context_xlease = (xlease_t*)dmi->contexts_gate->body;
  
  context = (context_t*)xlease_at(context_xlease, context_id);
  if(context == NULL)
    {
      //sleep(1000);
      error();
    }
  return context;
}

/* memory management */

void syscall_init(void)
{
#if !DEBUG_MIGRATION
  true_syscall_mmap = mmap;
  true_syscall_mremap = mremap;
  true_syscall_munmap = munmap;
  true_syscall_mprotect = mprotect;
  true_syscall_brk = brk;
  return;
#else
  void *ptr;
  int64_t addr;
  
  addr = CONST_THEAP_SEGMENT_SIZE - PAGESIZE;
  ptr = mmap((void*)addr, PAGESIZE, PROT_READ | PROT_WRITE | PROT_EXEC, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
  if(ptr != (void*)addr) error();
  
  true_syscall_mmap = (void* (*)(void *start, size_t length, int prot, int flags, int fd, off_t offset))((char*)ptr);
  true_syscall_mremap = (void* (*)(void *old_address, size_t old_size, size_t new_size, int flags))((char*)ptr + 100);
  true_syscall_munmap = (int (*)(void *start, size_t length))((char*)ptr + 200);
  true_syscall_mprotect = (int (*)(void *addr, size_t len, int prot))((char*)ptr + 300);
  true_syscall_brk = (int (*)(void *end_data_segment))((char*)ptr + 400);
  
#if SYS_LIBC_VERSION == LIBC_KOTOTOI
  syscall_hijack("mmap", 12, hook_syscall_mmap, true_syscall_mmap);
  syscall_hijack("mremap", 12, hook_syscall_mremap, true_syscall_mremap);
  syscall_hijack("munmap", 15, hook_syscall_munmap, true_syscall_munmap);
  /*syscall_hijack("mprotect", 15, hook_syscall_mprotect, true_syscall_mprotect);*/
  syscall_hijack("brk", 14, hook_syscall_brk, true_syscall_brk);
#elif SYS_LIBC_VERSION == LIBC_KYUTECH
  syscall_hijack("mmap", 16, hook_syscall_mmap, true_syscall_mmap);
  syscall_hijack("mremap", 16, hook_syscall_mremap, true_syscall_mremap);
  syscall_hijack("munmap", 13, hook_syscall_munmap, true_syscall_munmap);
  /*syscall_hijack("mprotect", 13, hook_syscall_mprotect, true_syscall_mprotect);*/
  syscall_hijack("brk", 16, hook_syscall_brk, true_syscall_brk);
#endif
  return;
#endif
}

void syscall_destroy(void)
{
#if !DEBUG_MIGRATION
  return;
#else
  int32_t ret;
  int64_t addr;
  
  addr = CONST_THEAP_SEGMENT_SIZE - PAGESIZE;
  /*
  ret = true_syscall_munmap((void*)addr, PAGESIZE);
  if(ret < 0) error();
  */
  return;
#endif
}

void syscall_hijack(char *syscall_name, int32_t syscall_header_size, void *hook_syscall, void *true_syscall)
{
  void* (*libc_syscall)(), (*mid_syscall)();
  char backup_code[128];
  char *inject_code;
  int32_t ret;
  intptr_t libc_syscall_addr, true_syscall_addr, hook_syscall_addr, mid_syscall_addr;
  
  libc_syscall = dlsym(RTLD_DEFAULT, syscall_name);
  if(libc_syscall == NULL) error();
  libc_syscall_addr = (intptr_t)libc_syscall;
  true_syscall_addr = (intptr_t)true_syscall;
  hook_syscall_addr = (intptr_t)hook_syscall;
  mid_syscall_addr = libc_syscall_addr + syscall_header_size;
  mid_syscall = (void*)mid_syscall_addr;
  
  memcpy(backup_code, libc_syscall, syscall_header_size);
  
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(libc_syscall_addr), PAGESIZE, PROT_READ | PROT_WRITE | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(libc_syscall_addr + 12), PAGESIZE, PROT_READ | PROT_WRITE | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(true_syscall_addr), PAGESIZE, PROT_READ | PROT_WRITE | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(true_syscall_addr + syscall_header_size + 13), PAGESIZE, PROT_READ | PROT_WRITE | PROT_EXEC);
  if(ret < 0) error();
  
  inject_code = (char*)libc_syscall;
  inject_code[0] = 0x48;
  inject_code[1] = 0xb8;
  *(intptr_t*)(inject_code + 2) = hook_syscall_addr;
  inject_code[10] = 0xff;
  inject_code[11] = 0xe0;
  
  memcpy(true_syscall, backup_code, syscall_header_size);
  
  inject_code = (char*)(intptr_t)(true_syscall_addr + syscall_header_size);
  inject_code[0] = 0x49;
  inject_code[1] = 0xbb;
  *(intptr_t*)(inject_code + 2) = mid_syscall_addr;
  inject_code[10] = 0x41;
  inject_code[11] = 0xff;
  inject_code[12] = 0xe3;
  
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(libc_syscall_addr), PAGESIZE, PROT_READ | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(libc_syscall_addr + 12), PAGESIZE, PROT_READ | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(true_syscall_addr), PAGESIZE, PROT_READ | PROT_EXEC);
  if(ret < 0) error();
  ret = mprotect((void*)SYS_PAGESIZE_ALIGN_FLOOR(true_syscall_addr + syscall_header_size + 13), PAGESIZE, PROT_READ | PROT_EXEC);
  if(ret < 0) error();
  return;
}

void* fixed_mmap(void *start, size_t length, int prot, int flags)
{
#if !DEBUG_MIGRATION
  void *ptr;
  int32_t ret;
  
  pthread_mutex_lock(&_memory->mmap_mutex);
  
  ptr = true_syscall_mmap(start, length, prot, flags, -1, 0);
  if(ptr != start)
    {
      ret = true_syscall_munmap(ptr, length);
      if(ret < 0) error();
      ptr = MAP_FAILED;
    }
  
  pthread_mutex_unlock(&_memory->mmap_mutex);
  return ptr;
#else
  void *ptr;
  int32_t ret;
  
  pthread_mutex_lock(&_memory->mmap_mutex);
  
  errno = 0;
  ptr = true_syscall_mremap(start, PAGESIZE, PAGESIZE * 2, 0);
  if(ptr == MAP_FAILED && errno == EFAULT)
    {
      ptr = true_syscall_mmap(start, PAGESIZE, prot, flags | MAP_FIXED, -1, 0);
      if(ptr == MAP_FAILED) error();
      
      ptr = true_syscall_mremap(start, PAGESIZE, length, 0);
      if(ptr == MAP_FAILED)
        {
          ret = true_syscall_munmap(start, PAGESIZE);
          if(ret < 0) error();
        }
    }
  else if(ptr != MAP_FAILED)
    {
      ret = true_syscall_munmap(start + PAGESIZE, PAGESIZE);
      if(ret < 0) error();
      
      ptr = MAP_FAILED;
    }
  
  pthread_mutex_unlock(&_memory->mmap_mutex);
  return ptr;
#endif
  
}

void* hook_syscall_mmap(void *start, size_t length, int prot, int flags, int fd, off_t offset)
{
  pheap_t *pheap;
  theap_t *theap;
  mblock_t *mblock, *new_mblock;
  mmapped_t *mmapped;
  void *start_ptr;
  int32_t pheap_id;
  int64_t addr;
  
  length = SYS_PAGESIZE_ALIGN_CEIL(length);
  if(length == 0)
    {
      return NULL;
    }
  
  start_ptr = NULL;
  if(flags & MAP_ANONYMOUS)
    {
      if(flags & MAP_FIXED)
        {
          errno = EINVAL;
          return MAP_FAILED;
        }
      
      if(_tls_pheap_id != SYS_ID_UNDEF)
        {
          pheap_id = _tls_pheap_id;
          _tls_pheap_id = SYS_ID_UNDEF;
          
          pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, pheap_id);
          
          start_ptr = MAP_FAILED;
          list_head(pheap->mblock_list);
          while(list_hasnext(pheap->mblock_list))
            {
              mblock = (mblock_t*)list_next(pheap->mblock_list);
              
              start_ptr = (char*)mblock->start_ptr + mblock->size;
              start_ptr = fixed_mmap(start_ptr, length, prot, flags);
              if(start_ptr != MAP_FAILED)
                {
                  mblock->size += length;
                  
                  mmapped = mmapped_alloc();
                  mmapped->start_ptr = start_ptr;
                  mmapped->size = length;
                  mmapped->prot = prot;
                  mmapped->flags = flags;
                  
                  list_push(pheap->mmapped_list, mmapped);
                  break;
                }
            }
          if(start_ptr == MAP_FAILED)
            {
              do
                {
                  addr = mrand_01() * CONST_PHEAP_SEGMENT_SIZE + CONST_THEAP_SEGMENT_SIZE;
                  addr = SYS_PAGESIZE_ALIGN_CEIL(addr);
                  start_ptr = (void*)addr;
                  
                  start_ptr = fixed_mmap(start_ptr, length, prot, flags);
                }
              while(start_ptr == MAP_FAILED);
              
              new_mblock = mblock_alloc();
              new_mblock->start_ptr = start_ptr;
              new_mblock->size = length;
              list_push(pheap->mblock_list, new_mblock);
              
              mmapped = mmapped_alloc();
              mmapped->start_ptr = start_ptr;
              mmapped->size = length;
              mmapped->prot = prot;
              mmapped->flags = flags;
              list_push(pheap->mmapped_list, mmapped);
            }
          
          _tls_pheap_id = pheap_id;
        }
      else
        {
          theap = _memory->theap;
          pthread_mutex_lock(&theap->mutex);
          
          while(1)
            {
              start_ptr = (void*)theap->addr;
              start_ptr = fixed_mmap(start_ptr, length, prot, flags);
              if(start_ptr != MAP_FAILED)
                {
                  theap->addr = (intptr_t)start_ptr + length;
                  break;
                }
              else
                {
                  addr = (int64_t)(mrand_01() * CONST_THEAP_SEGMENT_SIZE);
                  addr = SYS_PAGESIZE_ALIGN_CEIL(addr);
                  theap->addr = addr;
                }
            }
          
          pthread_mutex_unlock(&theap->mutex);
        }
    }
  else
    {
      pthread_mutex_lock(&_memory->mmap_mutex);
      
      start_ptr = true_syscall_mmap(start, length, prot, flags, fd, offset);
      
      pthread_mutex_unlock(&_memory->mmap_mutex);
    }
  
#if DEBUG_MEMORY
  print_int(_tls_pheap_id);
  print_str(" : mmap(start=");
  print_intx((intptr_t)start);
  print_str(" length=");
  print_int(length);
  print_str(" prot=");
  print_int(prot);
  print_str(" flags=");
  print_int(flags);
  print_str(" fd=");
  print_int(fd);
  print_str(" offset=");
  print_int(offset);
  print_str(") : ptr=");
  print_intx((intptr_t)start_ptr);
  print_str("\n");
#endif
  return start_ptr;
}

void* hook_syscall_mremap(void *old_address, size_t old_size, size_t new_size, int flags)
{
  pheap_t *pheap;
  mmapped_t *mmapped;
  int old_prot, old_flags;
  int32_t ret, pheap_id;
  void *ptr;
  
  if(old_address == NULL)
    {
      errno = EFAULT;
      return MAP_FAILED;
    }
  
  old_size = SYS_PAGESIZE_ALIGN_CEIL(old_size);
  new_size = SYS_PAGESIZE_ALIGN_CEIL(new_size);
  
  if(new_size > old_size)
    {
      if(flags & MREMAP_MAYMOVE)
        {
          if(_tls_pheap_id != SYS_ID_UNDEF)
            {
              pheap_id = _tls_pheap_id;
              _tls_pheap_id = SYS_ID_UNDEF;
              
              pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, pheap_id);
              
              old_prot = -1;
              old_flags = -1;
              list_head(pheap->mmapped_list);
              while(list_hasnext(pheap->mmapped_list))
                {
                  mmapped = (mmapped_t*)list_next(pheap->mmapped_list);
                  
                  if((char*)mmapped->start_ptr < (char*)old_address + old_size
                     && (char*)old_address < (char*)mmapped->start_ptr + mmapped->size)
                    {
                      if(old_prot == -1 && old_flags == -1)
                        {
                          old_prot = mmapped->prot;
                          old_flags = mmapped->flags;
                        }
                      else if(!(old_prot == mmapped->prot && old_flags == mmapped->flags))
                        {
                          old_prot = -1;
                          old_flags = -1;
                          break;
                        }
                    }
                }
              if(old_prot == -1 && old_flags == -1)
                {
                  errno = EFAULT;
                  ptr = MAP_FAILED;
                }
              else
                {
                  _tls_pheap_id = pheap_id;
                  
                  ptr = hook_syscall_mmap(NULL, new_size, old_prot, old_flags, -1, 0);
                  
                  _tls_pheap_id = SYS_ID_UNDEF;
                  
                  if(ptr == MAP_FAILED)
                    {
                      errno = ENOMEM;
                      ptr = MAP_FAILED;
                    }
                  else
                    {
                      memcpy(ptr, old_address, old_size);
                      
                      _tls_pheap_id = pheap_id;
                      
                      ret = hook_syscall_munmap(old_address, old_size);
                      if(ret < 0) error();
                      
                      _tls_pheap_id = SYS_ID_UNDEF;
                    }
                }
              
              _tls_pheap_id = pheap_id;
            }
          else
            {
              pthread_mutex_lock(&_memory->mmap_mutex);
              
              ptr = true_syscall_mremap(old_address, old_size, new_size, flags);
              
              pthread_mutex_unlock(&_memory->mmap_mutex);
            }
        }
      else
        {
          errno = ENOMEM;
          ptr = MAP_FAILED;
        }
    }
  else if(new_size == old_size)
    {
      ptr = old_address;
    }
  else
    {
      ret = hook_syscall_munmap((char*)old_address + new_size, old_size - new_size);
      if(ret < 0) error();
      
      ptr = old_address;
    }
  return ptr;
}

int hook_syscall_munmap(void *start, size_t length)
{
  pheap_t *pheap;
  mblock_t *mblock, *new_mblock;
  mmapped_t *mmapped, *new_mmapped;
  void *p0, *p1, *q0, *q1;
  int32_t ret_value, pheap_id;
  
  if(start == NULL)
    {
      return 0;
    }
  if((intptr_t)start % PAGESIZE != 0)
    {
      errno = EINVAL;
      return -1;
    }
  length = SYS_PAGESIZE_ALIGN_CEIL(length);
  
  if(_tls_pheap_id != SYS_ID_UNDEF)
    {
      pheap_id = _tls_pheap_id;
      _tls_pheap_id = SYS_ID_UNDEF;
      
      pheap = (pheap_t*)xvector_at(_memory->pheap_xvector, pheap_id);
      
      ret_value = -1;
      list_head(pheap->mblock_list);
      while(list_hasnext(pheap->mblock_list))
        {
          mblock = (mblock_t*)list_next(pheap->mblock_list);
          
          p0 = (char*)mblock->start_ptr;
          p1 = (char*)mblock->start_ptr + mblock->size;
          q0 = (char*)start;
          q1 = (char*)start + length;
          
          if(q0 == p0 && p1 == q1)
            {
              list_remove(pheap->mblock_list);
              
              mblock_free(mblock);
              ret_value = 0;
              break;
            }
          else if(q0 == p0 && q1 < p1)
            {
              mblock->start_ptr = q1;
              mblock->size = (intptr_t)p1 - (intptr_t)q1;
              ret_value = 0;
              break;
            }
          else if(p0 < q0 && p1 == q1)
            {
              mblock->size = (intptr_t)q0 - (intptr_t)p0;
              ret_value = 0;
              break;
            }
          else if(p0 < q0 && q1 < p1)
            {
              new_mblock = mblock_alloc();
              new_mblock->start_ptr = p0;
              new_mblock->size = (intptr_t)q0 - (intptr_t)p0;
              list_insert(pheap->mblock_list, new_mblock);
              
              mblock->start_ptr = q1;
              mblock->size = (intptr_t)p1 - (intptr_t)q1;
              ret_value = 0;
              break;
            }
        }
      
      if(ret_value == -1)
        {
          errno = EINVAL;
        }
      else
        {
          pthread_mutex_lock(&_memory->mmap_mutex);
          
          ret_value = true_syscall_munmap(start, length);
          
          pthread_mutex_unlock(&_memory->mmap_mutex);
          
          if(ret_value == 0)
            {
              list_head(pheap->mmapped_list);
              while(list_hasnext(pheap->mmapped_list))
                {
                  mmapped = (mmapped_t*)list_next(pheap->mmapped_list);
                  
                  p0 = (char*)mmapped->start_ptr;
                  p1 = (char*)mmapped->start_ptr + mmapped->size;
                  q0 = (char*)start;
                  q1 = (char*)start + length;
                  
                  if(q0 <= p0 && p1 <= q1)
                    {
                      list_remove(pheap->mmapped_list);
                      
                      mmapped_free(mmapped);
                      break;
                    }
                  else if(q0 <= p0 && p0 < q1 && q1 < p1)
                    {
                      mmapped->start_ptr = q1;
                      mmapped->size = (intptr_t)p1 - (intptr_t)q1;
                      break;
                    }
                  else if(p0 < q0 && q0 < p1 && p1 <= q1)
                    {
                      mmapped->size = (intptr_t)q0 - (intptr_t)p0;
                      break;
                    }
                  else if(p0 < q0 && q1 < p1)
                    {
                      new_mmapped = mmapped_alloc();
                      new_mmapped->start_ptr = p0;
                      new_mmapped->size = (intptr_t)q0 - (intptr_t)p0;
                      new_mmapped->prot = mmapped->prot;
                      new_mmapped->flags = mmapped->flags;
                      list_insert(pheap->mmapped_list, new_mmapped);
                      
                      mmapped->start_ptr = q1;
                      mmapped->size = (intptr_t)p1 - (intptr_t)q1;
                      break;
                    }
                }
            }
        }
      
      _tls_pheap_id = pheap_id;
    }
  else
    {
      pthread_mutex_lock(&_memory->mmap_mutex);
      
      ret_value = true_syscall_munmap(start, length);
      
      pthread_mutex_unlock(&_memory->mmap_mutex);
    }
  
#if DEBUG_MEMORY
  print_int(_tls_pheap_id);
  print_str(" : munmap(start=");
  print_intx((intptr_t)start);
  print_str(" length=");
  print_int(length);
  print_str(") : ret=");
  print_int(ret_value);
  print_str("\n");
#endif
  return ret_value;
}

int hook_syscall_mprotect(void *addr, size_t len, int prot)
{
  int32_t ret_value;
  
  ret_value = true_syscall_mprotect(addr, len, prot);
  return ret_value;
}

int hook_syscall_brk(void *end_data_segment)
{
#if DEBUG_MEMORY
  print_int(_tls_pheap_id);
  print_str(" : brk(end_data_segment=");
  print_intx((intptr_t)end_data_segment);
  print_str(") : -1");
  print_str("\n");
#endif
  return -1;
}

void print_int(int64_t d)
{
  char str[256];
  char *str_ptr;
  int8_t flag;
  int32_t count;
  
  count = 0;
  str_ptr = str + 256;
  
  flag = FALSE;
  if(d < 0)
    {
      flag = TRUE;
      d = -d;
    }
  else if(d == 0)
    {
      *--str_ptr = '0';
      count++;
    }
  
  while(d)
    {
      *--str_ptr = d % 10 + '0';
      d /= 10;
      count++;
    }
  if(flag == TRUE)
    {
      *--str_ptr = '-';
      count++;
    }
  write(1, str_ptr, count);
  return;
}

void print_intx(int64_t d)
{
  char str[256];
  char *str_ptr;
  int8_t flag;
  int32_t count;
  
  count = 0;
  str_ptr = str + 256;
  
  flag = FALSE;
  if(d < 0)
    {
      flag = TRUE;
      d = -d;
    }
  else if(d == 0)
    {
      *--str_ptr = '0';
      count++;
    }
  
  while(d)
    {
      if(d % 16 <= 9)
        {
          *--str_ptr = d % 16 + '0';
        }
      else
        {
          *--str_ptr = d % 16 - 10 + 'a';
        }
      d /= 16;
      count++;
    }
  *--str_ptr = 'x';
  count++;
  *--str_ptr = '0';
  count++;
  if(flag == TRUE)
    {
      *--str_ptr = '-';
      count++;
    }
  write(1, str_ptr, count);
  return;
}

void print_str(char *str)
{
  int32_t count;
  
  for(count = 0; str[count] != 0; count++);
  write(1, str, count);
  return;
}

/* private objects */

comm_t* comm_alloc(int16_t listen_port)
{
  comm_t *comm;
  int32_t ret;
  
  comm = (comm_t*)my_malloc(sizeof(comm_t));
  comm->sock_xvector = (xvector_t*)xvector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  pthread_cond_init(&comm->cond, NULL);
  pthread_mutex_init(&comm->mutex, NULL);
  comm->epfd_flag = FALSE;
  
  comm->epfd = sock_create_epoll(200);
  if(comm->epfd < 0) error();
  
  comm->listen_sock = sock_listen(listen_port, 12800);
  if(comm->listen_sock < 0) error();
  sock_add_epoll(comm->epfd, comm->listen_sock);
    
  ret = pipe(comm->self_sock);
  if(ret < 0) error();
  sock_add_epoll(comm->epfd, comm->self_sock[PIPE_OUT]);
  
  ret = pipe(comm->recver_sock);
  if(ret < 0) error();
  sock_add_epoll(comm->epfd, comm->recver_sock[PIPE_OUT]);
  return comm;
}

void comm_free(comm_t *comm)
{
  sock_del_epoll(comm->epfd, comm->recver_sock[PIPE_OUT]);
  close(comm->recver_sock[PIPE_IN]);
  close(comm->recver_sock[PIPE_OUT]);
  
  sock_del_epoll(comm->epfd, comm->self_sock[PIPE_OUT]);
  close(comm->self_sock[PIPE_IN]);
  close(comm->self_sock[PIPE_OUT]);
  
  sock_del_epoll(comm->epfd, comm->listen_sock);
  close(comm->listen_sock);
  
  close(comm->epfd);
  
  pthread_mutex_destroy(&comm->mutex);
  pthread_cond_destroy(&comm->cond);
  xvector_free(comm->sock_xvector);
  my_free(comm);
  return;
}

void comm_disable(comm_t *comm)
{
  int8_t command_type;
  int32_t ret;
  
  command_type = COMMAND_DISABLE;
  ret = my_write(comm->recver_sock[PIPE_IN], &command_type, sizeof(int8_t));
  if(ret < 0) error();
  
  pthread_mutex_lock(&comm->mutex);
  
  while(comm->epfd_flag == FALSE)
    {
      pthread_cond_wait(&comm->cond, &comm->mutex);
    }
  comm->epfd_flag = FALSE;
  
  pthread_mutex_unlock(&comm->mutex);
  return;
}

int32_t comm_recv(comm_t *comm, packet_t *recv_packet)
{
  struct epoll_event event;
  int sock, event_sock;
  int8_t command_type, exit_flag;
  int32_t dmi_id, ret, ret_value;
  
  exit_flag = FALSE;
  while(exit_flag == FALSE)
    {
      do
        {
          errno = 0;
          ret = epoll_wait(comm->epfd, &event, 1, -1);
        }
      while(ret < 0 && errno == EINTR);
      
      if(ret < 0) error();
      if(ret != 1) error();
      event_sock = event.data.fd;
      
      if(event_sock == comm->listen_sock)
        {
          sock = sock_accept(event_sock);
          if(sock < 0) error();
          ret = sock_recv(sock, &dmi_id, sizeof(int32_t));
          if(ret == 0) error();
          if(ret < 0) error();
          
          if(dmi_id == SYS_ID_UNDEF)
            {
              ret = packet_recv(recv_packet, sock, TYPE_SOCKET);
              recv_packet->sock = sock;
              
              ret_value = TRUE;
              exit_flag = TRUE;
            }
          else
            {
              xvector_assign(comm->sock_xvector, dmi_id, (void*)(intptr_t)sock);
              
              sock_add_epoll(comm->epfd, sock);
            }
        }
      else if(event_sock == comm->recver_sock[PIPE_OUT])
        {
          ret = my_read(event_sock, &command_type, sizeof(int8_t));
          if(ret == 0) error();
          if(ret < 0) error();
          
          switch(command_type)
            {
            case COMMAND_ADD:
              ret = my_read(event_sock, &sock, sizeof(int));
              if(ret == 0) error();
              if(ret < 0) error();
              
              sock_add_epoll(comm->epfd, sock);
              break;
            case COMMAND_DELETE:
              ret = my_read(event_sock, &sock, sizeof(int));
              if(ret == 0) error();
              if(ret < 0) error();
              
              sock_del_epoll(comm->epfd, sock);
              break;
            case COMMAND_DISABLE:
              ret_value = FALSE;
              exit_flag = TRUE;
              break;
            default:
              error();
            }
          
          pthread_mutex_lock(&comm->mutex);
          
          comm->epfd_flag = TRUE;
          pthread_cond_broadcast(&comm->cond);
          
          pthread_mutex_unlock(&comm->mutex);
        }
      else
        {
          if(event_sock == comm->self_sock[PIPE_OUT])
            {
              ret = packet_recv(recv_packet, event_sock, TYPE_PIPE);
            }
          else
            {
              ret = packet_recv(recv_packet, event_sock, TYPE_SOCKET);
            }
          if(ret == FALSE)
            {
              sock_del_epoll(comm->epfd, event_sock);
              
              sock_close(event_sock);
            }
          else
            {
              recv_packet->sock = event_sock;
              
              ret_value = TRUE;
              exit_flag = TRUE;
            }
        }
    }
  return ret_value;
}

void comm_send(comm_t *comm, int32_t src_dmi_id, int32_t dst_dmi_id, packet_t *send_packet)
{
  int sock;
  
  if(dst_dmi_id == SYS_ID_UNDEF)
    {
      sock = send_packet->sock;
      packet_send(send_packet, sock, TYPE_SOCKET);
    }
  else if(src_dmi_id == dst_dmi_id)
    {
      sock = comm->self_sock[PIPE_IN];
      packet_send(send_packet, sock, TYPE_PIPE);
    }
  else
    {
      sock = (int)(intptr_t)xvector_at(comm->sock_xvector, dst_dmi_id);
      packet_send(send_packet, sock, TYPE_SOCKET);
    }
  return;
}

void comm_connect(comm_t *comm, int32_t src_dmi_id, int32_t dst_dmi_id, char *ip, int16_t port)
{
  int sock;
  int32_t ret;
  
  sock = sock_connect(ip, port);
  if(sock < 0) error();
  ret = sock_send(sock, &src_dmi_id, sizeof(int32_t));
  if(ret < 0) error();
  
  comm_add(comm, dst_dmi_id, sock);
  return;
}

void comm_close(comm_t *comm, int32_t dmi_id)
{
  int sock;
  
  sock = comm_delete(comm, dmi_id);
  
  sock_close(sock);
  return;
}

void comm_add(comm_t *comm, int32_t dmi_id, int sock)
{
  int8_t command_type;
  int32_t ret;
  
  xvector_assign(comm->sock_xvector, dmi_id, (void*)(intptr_t)sock);
  
  command_type = COMMAND_ADD;
  ret = my_write(comm->recver_sock[PIPE_IN], &command_type, sizeof(int8_t));
  if(ret < 0) error();
  ret = my_write(comm->recver_sock[PIPE_IN], &sock, sizeof(int));
  if(ret < 0) error();
  
  pthread_mutex_lock(&comm->mutex);
  
  while(comm->epfd_flag == FALSE)
    {
      pthread_cond_wait(&comm->cond, &comm->mutex);
    }
  comm->epfd_flag = FALSE;
  
  pthread_mutex_unlock(&comm->mutex);
  return;
}

int comm_delete(comm_t *comm, int32_t dmi_id)
{
  int8_t command_type;
  int32_t ret;
  int sock;
  
  sock = (int)(intptr_t)xvector_at(comm->sock_xvector, dmi_id);
  
  command_type = COMMAND_DELETE;
  ret = my_write(comm->recver_sock[PIPE_IN], &command_type, sizeof(int8_t));
  if(ret < 0) error();
  ret = my_write(comm->recver_sock[PIPE_IN], &sock, sizeof(int));
  if(ret < 0) error();
  
  pthread_mutex_lock(&comm->mutex);
  
  while(comm->epfd_flag == FALSE)
    {
      pthread_cond_wait(&comm->cond, &comm->mutex);
    }
  comm->epfd_flag = FALSE;
  
  pthread_mutex_unlock(&comm->mutex);
  return sock;
}

void comm_self(comm_t *comm, host_t *host_ptr)
{
  sock_get_myhost(comm->listen_sock, host_ptr);
  return;
}

packet_t* packet_alloc(void)
{
  packet_t *packet;
  
  packet = (packet_t*)my_malloc(sizeof(packet_t));
  memset(packet, 0, sizeof(packet_t));
  packet->page_payload_buf = NULL;
  packet->data_payload_buf = NULL;
  
  packet->type = -2;
  packet->delay_flag = -2;
  packet->src_dmi_id = -2;
  packet->via_dmi_id = -2;
  packet->dst_dmi_id = -2;
  packet->context_id = -2;
  packet->sock = -2;
  packet->load_size = -2;
  packet->page_payload_size = -2;
  packet->data_payload_size = -2;
  packet->page_payload_ptr = NULL;
  packet->data_payload_ptr = NULL;
  packet->reg.r8a = -2;
  packet->reg.r8b = -2;
  packet->reg.r8c = -2;
  packet->reg.r16a = -2;
  packet->reg.r32a = -2;
  packet->reg.r32b = -2;
  packet->reg.r32c = -2;
  packet->reg.r32d = -2;
  packet->reg.r32e = -2;
  packet->reg.r64a = -2;
  packet->reg.r64b = -2;
  packet->reg.r64c = -2;
  packet->reg.r64d = -2;
  packet->reg.r64e = -2;
  packet->reg.r64f = -2;
  
  return packet;
}

void packet_free(packet_t *packet)
{
  my_free(packet->data_payload_buf);
  my_free(packet->page_payload_buf);
  my_free(packet);
  return;
}

void packet_copy(packet_t *dst_packet, packet_t *src_packet)
{
  *dst_packet = *src_packet;
  
  if(dst_packet->page_payload_buf != NULL)
    {
      dst_packet->page_payload_buf = (int8_t*)my_malloc(dst_packet->page_payload_size);
      memcpy(dst_packet->page_payload_buf, src_packet->page_payload_buf, dst_packet->page_payload_size);
      if(src_packet->page_payload_ptr == src_packet->page_payload_buf)
        {
          dst_packet->page_payload_ptr = dst_packet->page_payload_buf;
        }
      else
        {
          error();
        }
    }
  
  if(dst_packet->data_payload_buf != NULL)
    {
      dst_packet->data_payload_buf = (int8_t*)my_malloc(dst_packet->data_payload_size);
      memcpy(dst_packet->data_payload_buf, src_packet->data_payload_buf, dst_packet->data_payload_size);
      if(src_packet->data_payload_ptr == src_packet->data_payload_buf)
        {
          dst_packet->data_payload_ptr = dst_packet->data_payload_buf;
        }
      else
        {
          error();
        }
    }
  return;
}

void packet_send(packet_t *send_packet, int sock, int8_t type)
{
  static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
  int32_t ret;
  
#if DEBUG_PACKET
  packet_print(send_packet, TYPE_SEND);
#endif
  
  pthread_mutex_lock(&mutex);
  
  switch(type)
    {
    case TYPE_SOCKET:
      ret = sock_send(sock, send_packet, sizeof(packet_t));
      if(ret < 0) error();
      
      if(send_packet->page_payload_size > 0)
        {
          ret = sock_send(sock, send_packet->page_payload_ptr, send_packet->page_payload_size);
          if(ret < 0) error();
        }
      if(send_packet->data_payload_size > 0)
        {
          ret = sock_send(sock, send_packet->data_payload_ptr, send_packet->data_payload_size);
          if(ret < 0) error();
        }
      break;
    case TYPE_PIPE:
      ret = my_write(sock, send_packet, sizeof(packet_t));
      if(ret < 0) error();
      if(send_packet->page_payload_size > 0)
        {
          ret = my_write(sock, send_packet->page_payload_ptr, send_packet->page_payload_size);
          if(ret < 0) error();
        }
      if(send_packet->data_payload_size > 0)
        {
          ret = my_write(sock, send_packet->data_payload_ptr, send_packet->data_payload_size);
          if(ret < 0) error();
        }
      break;
    default:
      error();
    }
  
  pthread_mutex_unlock(&mutex);
  return;
}

int32_t packet_recv(packet_t *recv_packet, int sock, int8_t type)
{
  int32_t ret;
  
  switch(type)
    {
    case TYPE_SOCKET:
      ret = sock_recv(sock, recv_packet, sizeof(packet_t));
      if(ret == 0)
        {
          return FALSE;
        }
      if(ret < 0) error();
      
      recv_packet->page_payload_buf = (int8_t*)my_malloc(recv_packet->page_payload_size);
      if(recv_packet->page_payload_size > 0)
        {
          ret = sock_recv(sock, recv_packet->page_payload_buf, recv_packet->page_payload_size);
          if(ret == 0) error();
          if(ret < 0) error();
        }
      recv_packet->page_payload_ptr = recv_packet->page_payload_buf;
      
      recv_packet->data_payload_buf = (int8_t*)my_malloc(recv_packet->data_payload_size);
      if(recv_packet->data_payload_size > 0)
        {
          ret = sock_recv(sock, recv_packet->data_payload_buf, recv_packet->data_payload_size);
          if(ret == 0) error();
          if(ret < 0) error();
        }
      recv_packet->data_payload_ptr = recv_packet->data_payload_buf;
      break;
    case TYPE_PIPE:
      ret = my_read(sock, recv_packet, sizeof(packet_t));
      if(ret == 0)
        {
          return FALSE;
        }
      if(ret < 0) error();
      
      recv_packet->page_payload_buf = (int8_t*)my_malloc(recv_packet->page_payload_size);
      if(recv_packet->page_payload_size > 0)
        {
          ret = my_read(sock, recv_packet->page_payload_buf, recv_packet->page_payload_size);
          if(ret == 0) error();
          if(ret < 0) error();
        }
      recv_packet->page_payload_ptr = recv_packet->page_payload_buf;
      
      recv_packet->data_payload_buf = (int8_t*)my_malloc(recv_packet->data_payload_size);
      if(recv_packet->data_payload_size > 0)
        {
          ret = my_read(sock, recv_packet->data_payload_buf, recv_packet->data_payload_size);
          if(ret == 0) error();
          if(ret < 0) error();
        }
      recv_packet->data_payload_ptr = recv_packet->data_payload_buf;
      break;
    default:
      error();
    }
  
#if DEBUG_PACKET
  packet_print(recv_packet, TYPE_RECV);
#endif
  
  return TRUE;
}

void packet_print(packet_t *packet, int8_t type)
{
  static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
  int i;
  
  pthread_mutex_lock(&mutex);
  
  switch(type)
    {
    case TYPE_SEND:
      fprintf(stderr, "<< SEND ");
      break;
    case TYPE_RECV:
      fprintf(stderr, ">> RECV ");
      break;
    case TYPE_HANDLE:
      fprintf(stderr, "++ HANDLE ");
      break;
    default:
      error();
    }
  
  fprintf(stderr, "%d:%d->%d "
          , packet->src_dmi_id, packet->via_dmi_id, packet->dst_dmi_id);
  
  switch(packet->type)
    {
    case PACKET_REQ_CREATE_THREAD:
      fprintf(stderr, "PACKET_REQ_CREATE_THREAD");
      break;
    case PACKET_ACK_CREATE_THREAD:
      fprintf(stderr, "PACKET_ACK_CREATE_THREAD");
      break;
    case PACKET_REQ_JOIN_THREAD:
      fprintf(stderr, "PACKET_REQ_JOIN_THREAD");
      break;
    case PACKET_ACK_JOIN_THREAD:
      fprintf(stderr, "PACKET_ACK_JOIN_THREAD");
      break;
    case PACKET_REQ_DETACH_THREAD:
      fprintf(stderr, "PACKET_REQ_DETACH_THREAD");
      break;
    case PACKET_ACK_DETACH_THREAD:
      fprintf(stderr, "PACKET_ACK_DETACH_THREAD");
      break;
    case PACKET_REQ_WAKE_THREAD:
      fprintf(stderr, "PACKET_REQ_WAKE_THREAD");
      break;
    case PACKET_ACK_WAKE_THREAD:
      fprintf(stderr, "PACKET_ACK_WAKE_THREAD");
      break;
    case PACKET_REQ_MIGRATE_THREAD:
      fprintf(stderr, "PACKET_REQ_MIGRATE_THREAD");
      break;
    case PACKET_ACK_MIGRATE_THREAD:
      fprintf(stderr, "PACKET_ACK_MIGRATE_THREAD");
      break;
    case PACKET_REQ_YIELD_THREAD:
      fprintf(stderr, "PACKET_REQ_YIELD_THREAD");
      break;
    case PACKET_ACK_YIELD_THREAD:
      fprintf(stderr, "PACKET_ACK_YIELD_THREAD");
      break;
    case PACKET_REQ_LOCK_TOKEN:
      fprintf(stderr, "PACKET_REQ_LOCK_TOKEN");
      break;
    case PACKET_ACK_LOCK_TOKEN:
      fprintf(stderr, "PACKET_ACK_LOCK_TOKEN");
      break;
    case PACKET_REQ_UNLOCK_TOKEN:
      fprintf(stderr, "PACKET_REQ_UNLOCK_TOKEN");
      break;
    case PACKET_ACK_UNLOCK_TOKEN:
      fprintf(stderr, "PACKET_ACK_UNLOCK_TOKEN");
      break;
    case PACKET_REQ_DELEGATE_TOKEN:
      fprintf(stderr, "PACKET_REQ_DELEGATE_TOKEN");
      break;
    case PACKET_ACK_DELEGATE_TOKEN:
      fprintf(stderr, "PACKET_ACK_DELEGATE_TOKEN");
      break;
    case PACKET_REQ_HELLO_WORLD:
      fprintf(stderr, "PACKET_REQ_HELLO_WORLD");
      break;
    case PACKET_ACK_HELLO_WORLD:
      fprintf(stderr, "PACKET_ACK_HELLO_WORLD");
      break;
    case PACKET_REQ_ALLOC_PEER:
      fprintf(stderr, "PACKET_REQ_ALLOC_PEER");
      break;
    case PACKET_ACK_ALLOC_PEER:
      fprintf(stderr, "PACKET_ACK_ALLOC_PEER");
      break;
    case PACKET_REQ_PERMIT_PEER:
      fprintf(stderr, "PACKET_REQ_PERMIT_PEER");
      break;
    case PACKET_ACK_PERMIT_PEER:
      fprintf(stderr, "PACKET_ACK_PERMIT_PEER");
      break;
    case PACKET_REQ_FORBID_PEER:
      fprintf(stderr, "PACKET_REQ_FORBID_PEER");
      break;
    case PACKET_ACK_FORBID_PEER:
      fprintf(stderr, "PACKET_ACK_FORBID_PEER");
      break;
    case PACKET_REQ_FREE_PEER:
      fprintf(stderr, "PACKET_REQ_FREE_PEER");
      break;
    case PACKET_ACK_FREE_PEER:
      fprintf(stderr, "PACKET_ACK_FREE_PEER");
      break;
    case PACKET_REQ_BYE_WORLD:
      fprintf(stderr, "PACKET_REQ_BYE_WORLD");
      break;
    case PACKET_ACK_BYE_WORLD:
      fprintf(stderr, "PACKET_ACK_BYE_WORLD");
      break;
    case PACKET_REQ_ALLOC_VMS:
      fprintf(stderr, "PACKET_REQ_ALLOC_VMS");
      break;
    case PACKET_ACK_ALLOC_VMS:
      fprintf(stderr, "PACKET_ACK_ALLOC_VMS");
      break;
    case PACKET_REQ_PERMIT_VMS:
      fprintf(stderr, "PACKET_REQ_PERMIT_VMS");
      break;
    case PACKET_ACK_PERMIT_VMS:
      fprintf(stderr, "PACKET_ACK_PERMIT_VMS");
      break;
    case PACKET_REQ_FORBID_VMS:
      fprintf(stderr, "PACKET_REQ_FORBID_VMS");
      break;
    case PACKET_ACK_FORBID_VMS:
      fprintf(stderr, "PACKET_ACK_FORBID_VMS");
      break;
    case PACKET_REQ_FREE_VMS:
      fprintf(stderr, "PACKET_REQ_FREE_VMS");
      break;
    case PACKET_ACK_FREE_VMS:
      fprintf(stderr, "PACKET_ACK_FREE_VMS");
      break;
    case PACKET_REQ_READ_PAGE:
      fprintf(stderr, "PACKET_REQ_READ_PAGE");
      break;
    case PACKET_ACK_READ_PAGE:
      fprintf(stderr, "PACKET_ACK_READ_PAGE");
      break;
    case PACKET_REQ_RELAY_PAGE:
      fprintf(stderr, "PACKET_REQ_RELAY_PAGE");
      break;
    case PACKET_ACK_RELAY_PAGE:
      fprintf(stderr, "PACKET_ACK_RELAY_PAGE");
      break;
    case PACKET_REQ_STEAL_PAGE:
      fprintf(stderr, "PACKET_REQ_STEAL_PAGE");
      break;
    case PACKET_ACK_STEAL_PAGE:
      fprintf(stderr, "PACKET_ACK_STEAL_PAGE");
      break;
    case PACKET_REQ_MIGRATE_PAGE:
      fprintf(stderr, "PACKET_REQ_MIGRATE_PAGE");
      break;
    case PACKET_ACK_MIGRATE_PAGE:
      fprintf(stderr, "PACKET_ACK_MIGRATE_PAGE");
      break;
    case PACKET_REQ_VALIDATE_PAGE:
      fprintf(stderr, "PACKET_REQ_VALIDATE_PAGE");
      break;
    case PACKET_ACK_VALIDATE_PAGE:
      fprintf(stderr, "PACKET_ACK_VALIDATE_PAGE");
      break;
    case PACKET_REQ_INVALIDATE_PAGE:
      fprintf(stderr, "PACKET_REQ_INVALIDATE_PAGE");
      break;
    case PACKET_ACK_INVALIDATE_PAGE:
      fprintf(stderr, "PACKET_ACK_INVALIDATE_PAGE");
      break;
    case PACKET_REQ_COMMIT_PAGE:
      fprintf(stderr, "PACKET_REQ_COMMIT_PAGE");
      break;
    case PACKET_ACK_COMMIT_PAGE:
      fprintf(stderr, "PACKET_ACK_COMMIT_PAGE");
      break;
    case PACKET_REQ_SWEEP_PAGE:
      fprintf(stderr, "PACKET_REQ_SWEEP_PAGE");
      break;
    case PACKET_ACK_SWEEP_PAGE:
      fprintf(stderr, "PACKET_ACK_SWEEP_PAGE");
      break;
    case PACKET_REQ_DELEGATE_PAGE:
      fprintf(stderr, "PACKET_REQ_DELEGATE_PAGE");
      break;
    case PACKET_ACK_DELEGATE_PAGE:
      fprintf(stderr, "PACKET_ACK_DELEGATE_PAGE");
      break;
    default:
      error();
    }
  
  fprintf(stderr, "\n");
  
  switch(packet->type)
    {
    case PACKET_REQ_CREATE_THREAD:
      fprintf(stderr, "vm_id=%d,addr=%ld,stack=%ld,value1=%ld,value2=%ld,value3=%ld"
              , SYS_ADDR_VM_PART(packet_dmi_addr(packet)), SYS_ADDR_OFFSET_PART(packet_dmi_addr(packet)), packet_stack_size(packet), packet_value1(packet), packet_value2(packet), packet_value3(packet));
      break;
    case PACKET_ACK_CREATE_THREAD:
      fprintf(stderr, "thread_id=%d,ret_flag=%d"
              , packet_thread_id(packet), packet_ret_flag(packet));
      break;
    case PACKET_REQ_JOIN_THREAD:
      fprintf(stderr, "thread_id=%d"
              , packet_thread_id(packet));
      break;
    case PACKET_ACK_JOIN_THREAD:
      fprintf(stderr, "vm_id=%d,addr=%ld,ret_flag=%d"
              , SYS_ADDR_VM_PART(packet_dmi_addr(packet)), SYS_ADDR_OFFSET_PART(packet_dmi_addr(packet)), packet_ret_flag(packet));
      break;
    case PACKET_REQ_DETACH_THREAD:
      fprintf(stderr, "thread_id=%d"
              , packet_thread_id(packet));
      break;
    case PACKET_ACK_DETACH_THREAD:
      fprintf(stderr, "ret_flag=%d"
              , packet_ret_flag(packet));
      break;
    case PACKET_REQ_WAKE_THREAD:
      fprintf(stderr, "thread_id=%d"
              , packet_thread_id(packet));
      break;
    case PACKET_ACK_WAKE_THREAD:
      fprintf(stderr, "ret_flag=%d"
              , packet_ret_flag(packet));
      break;
    case PACKET_REQ_MIGRATE_THREAD:
      fprintf(stderr, "thread_id=%d,dmi_id=%d"
              , packet_thread_id(packet), packet_dmi_id(packet));
      break;
    case PACKET_ACK_MIGRATE_THREAD:
      fprintf(stderr, "ret_flag=%d,thread_id=%d"
              , packet_ret_flag(packet), packet_thread_id(packet));
      break;
    case PACKET_REQ_YIELD_THREAD:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_YIELD_THREAD:
      fprintf(stderr, "ret_flag=%d,thread_id=%d"
              , packet_ret_flag(packet), packet_thread_id(packet));
      break;
    case PACKET_REQ_LOCK_TOKEN:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_LOCK_TOKEN:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_UNLOCK_TOKEN:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_UNLOCK_TOKEN:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_DELEGATE_TOKEN:
      fprintf(stderr, "lock_flag=%d"
              , packet_lock_flag(packet));
      break;
    case PACKET_ACK_DELEGATE_TOKEN:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_HELLO_WORLD:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_HELLO_WORLD:
      fprintf(stderr, "owner_id=%d,dmi_id=%d,ret_flag=%d"
              , packet_owner_id(packet), packet_dmi_id(packet), packet_ret_flag(packet));
      break;
    case PACKET_REQ_ALLOC_PEER:
      fprintf(stderr, "port=%d"
              , packet_port(packet));
      break;
    case PACKET_ACK_ALLOC_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_PERMIT_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_PERMIT_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_FORBID_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_FORBID_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_FREE_PEER:
      fprintf(stderr, "owner_id=%d"
              , packet_owner_id(packet));
      break;
    case PACKET_ACK_FREE_PEER:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_BYE_WORLD:
      fprintf(stderr, "-");
      break;
    case PACKET_ACK_BYE_WORLD:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_ALLOC_VMS:
      fprintf(stderr, "vm_num=%d"
              , packet_vm_num(packet));
      break;
    case PACKET_ACK_ALLOC_VMS:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_PERMIT_VMS:
      fprintf(stderr, "vm_num=%d"
              , packet_vm_num(packet));
      break;
    case PACKET_ACK_PERMIT_VMS:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_FORBID_VMS:
      fprintf(stderr, "vm_num=%d"
              , packet_vm_num(packet));
      break;
    case PACKET_ACK_FORBID_VMS:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_FREE_VMS:
      fprintf(stderr, "vm_num=%d"
              , packet_vm_num(packet));
      break;
    case PACKET_ACK_FREE_VMS:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_READ_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld"
              , packet_vm_id(packet), packet_page_id(packet));
      switch(packet_access_type(packet))
        {
        case ACCESS_ONCE_READ:
          fprintf(stderr, ",offset=%ld,size=%ld"
                  , packet_page_offset(packet), packet_copy_size(packet));
          fprintf(stderr, ",access_type=ONCE_READ");
          break;
        case ACCESS_INVALIDATE_READ:
          fprintf(stderr, ",access_type=INVALIDATE_READ");
          break;
        case ACCESS_UPDATE_READ:
          fprintf(stderr, ",access_type=UPDATE_READ");
          break;
        case ACCESS_ONCE_GREAD:
          fprintf(stderr, ",set=%d"
                  , packet_set_num(packet));
          fprintf(stderr, ",access_type=ONCE_GREAD");
          break;
        case ACCESS_INVALIDATE_GREAD:
          fprintf(stderr, ",access_type=INVALIDATE_GREAD");
          break;
        case ACCESS_UPDATE_GREAD:
          fprintf(stderr, ",access_type=UPDATE_GREAD");
          break;
        case ACCESS_ONCE_GETSIZE:
          fprintf(stderr, ",offset=%ld,size=%ld"
                  , packet_page_offset(packet), packet_copy_size(packet));
          fprintf(stderr, ",access_type=ONCE_GETSIZE");
          break;
        case ACCESS_INVALIDATE_GETSIZE:
          fprintf(stderr, ",access_type=INVALIDATE_GETSIZE");
          break;
        case ACCESS_UPDATE_GETSIZE:
          fprintf(stderr, ",access_type=UPDATE_GETSIZE");
          break;
        default:
          error();
        }
      break;
    case PACKET_ACK_READ_PAGE:
      fprintf(stderr, "seq=%d,ret=%d,ack=%d,relay=%d,slide=%ld"
              , packet_seq(packet), packet_ret_flag(packet), packet_ack_flag(packet), packet_relay_flag(packet), packet_slide_size(packet));
      switch(packet_state(packet))
        {
        case STATE_INVALID:
          fprintf(stderr, ",state=INVALID");
          break;
        case STATE_UPVALID:
          fprintf(stderr, ",state=UPVALID");
          break;
        case STATE_DOWNVALID:
          fprintf(stderr, ",state=DOWNVALID");
          break;
        default:
          error();
        }
      fprintf(stderr, ",page=");
      for(i = 0; i < packet->page_payload_size / sizeof(int); i++)
        {
          fprintf(stderr, "%d ", ((int*)packet->page_payload_ptr)[i]);
        }
      break;
    case PACKET_REQ_RELAY_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,seq=%d,seq2=%d,slide=%ld"
              , packet_vm_id(packet), packet_page_id(packet), packet_seq(packet), packet_seq2(packet), packet_slide_size(packet));
      switch(packet_state(packet))
        {
        case STATE_INVALID:
          fprintf(stderr, ",state=INVALID");
          break;
        case STATE_UPVALID:
          fprintf(stderr, ",state=UPVALID");
          break;
        case STATE_DOWNVALID:
          fprintf(stderr, ",state=DOWNVALID");
          break;
        default:
          error();
        }
      switch(packet_access_type(packet))
        {
        case ACCESS_ONCE_READ:
          fprintf(stderr, ",offset=%ld,size=%ld"
                  , packet_page_offset(packet), packet_copy_size(packet));
          fprintf(stderr, ",access_type=ONCE_READ");
          break;
        case ACCESS_INVALIDATE_READ:
          fprintf(stderr, ",access_type=INVALIDATE_READ");
          break;
        case ACCESS_UPDATE_READ:
          fprintf(stderr, ",access_type=UPDATE_READ");
          break;
        case ACCESS_ONCE_GREAD:
          fprintf(stderr, ",set=%d"
                  , packet_set_num(packet));
          fprintf(stderr, ",access_type=ONCE_GREAD");
          break;
        case ACCESS_INVALIDATE_GREAD:
          fprintf(stderr, ",access_type=INVALIDATE_GREAD");
          break;
        case ACCESS_UPDATE_GREAD:
          fprintf(stderr, ",access_type=UPDATE_GREAD");
          break;
        case ACCESS_ONCE_GETSIZE:
          fprintf(stderr, ",offset=%ld,size=%ld"
                  , packet_page_offset(packet), packet_copy_size(packet));
          fprintf(stderr, ",access_type=ONCE_GETSIZE");
          break;
        case ACCESS_INVALIDATE_GETSIZE:
          fprintf(stderr, ",access_type=INVALIDATE_GETSIZE");
          break;
        case ACCESS_UPDATE_GETSIZE:
          fprintf(stderr, ",access_type=UPDATE_GETSIZE");
          break;
        default:
          error();
        }
      break;
    case PACKET_ACK_RELAY_PAGE:
      fprintf(stderr, "seq=%d,ack=%d,relay=%d,slide=%ld"
              , packet_seq(packet), packet_ack_flag(packet), packet_relay_flag(packet), packet_slide_size(packet));
      switch(packet_state(packet))
        {
        case STATE_INVALID:
          fprintf(stderr, ",state=INVALID");
          break;
        case STATE_UPVALID:
          fprintf(stderr, ",state=UPVALID");
          break;
        case STATE_DOWNVALID:
          fprintf(stderr, ",state=DOWNVALID");
          break;
        default:
          error();
        }
      fprintf(stderr, ",page=");
      for(i = 0; i < packet->page_payload_size / sizeof(int); i++)
        {
          fprintf(stderr, "%d ", ((int*)packet->page_payload_ptr)[i]);
        }
      break;
    case PACKET_REQ_STEAL_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld"
              , packet_vm_id(packet), packet_page_id(packet));
      break;
    case PACKET_ACK_STEAL_PAGE:
      fprintf(stderr, "ret=%d,valid_num=%d,seq=%d,slide=%ld"
              , packet_ret_flag(packet), packet_valid_num(packet), packet_seq(packet), packet_slide_size(packet));
      switch(packet_state(packet))
        {
        case STATE_INVALID:
          fprintf(stderr, ",state=INVALID");
          break;
        case STATE_UPVALID:
          fprintf(stderr, ",state=UPVALID");
          break;
        case STATE_DOWNVALID:
          fprintf(stderr, ",state=DOWNVALID");
          break;
        default:
          error();
        }
      fprintf(stderr, ",page=");
      for(i = 0; i < packet->page_payload_size / sizeof(int); i++)
        {
          fprintf(stderr, "%d ", ((int*)packet->page_payload_ptr)[i]);
        }
      break;
    case PACKET_REQ_MIGRATE_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,seq=%d,owner_id=%d"
              , packet_vm_id(packet), packet_page_id(packet), packet_seq(packet), packet_owner_id(packet));
      break;
    case PACKET_ACK_MIGRATE_PAGE:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_VALIDATE_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,seq=%d,offset=%ld,slide=%ld"
              , packet_vm_id(packet), packet_page_id(packet), packet_seq(packet), packet_page_offset(packet), packet_slide_size(packet));
      switch(packet_access_type(packet))
        {
        case ACCESS_REMOTE_WRITE:
          fprintf(stderr, ",size=%ld"
                  , packet_copy_size(packet));
          fprintf(stderr, ",access_type=REMOTE_WRITE");
          break;
        case ACCESS_LOCAL_WRITE:
          fprintf(stderr, ",size=%ld"
                  , packet_copy_size(packet));
          fprintf(stderr, ",access_type=LOCAL_WRITE");
          break;
        case ACCESS_REMOTE_SETSIZE:
          fprintf(stderr, ",size=%ld,slide=%ld"
                  , packet_copy_size(packet), packet_slide_size(packet));
          fprintf(stderr, ",access_type=REMOTE_SETSIZE");
          break;
        case ACCESS_LOCAL_SETSIZE:
          fprintf(stderr, ",size=%ld,slide=%ld"
                  , packet_copy_size(packet), packet_slide_size(packet));
          fprintf(stderr, ",access_type=LOCAL_SETSIZE");
          break;
        case ACCESS_REMOTE_GWRITE:
          fprintf(stderr, ",size=%ld,set=%d"
                  , packet_copy_size(packet), packet_set_num(packet));
          fprintf(stderr, ",access_type=REMOTE_GWRITE");
          break;
        case ACCESS_LOCAL_GWRITE:
          fprintf(stderr, ",size=%ld,set=%d"
                  , packet_copy_size(packet), packet_set_num(packet));
          fprintf(stderr, ",access_type=LOCAL_GWRITE");
          break;
        case ACCESS_REMOTE_ATOMIC:
          fprintf(stderr, ",out_size=%ld,tag=%d"
                  , packet_out_size(packet), packet_tag(packet));
          fprintf(stderr, ",access_type=REMOTE_ATOMIC");
          break;
        case ACCESS_LOCAL_ATOMIC:
          fprintf(stderr, ",out_size=%ld,tag=%d"
                  , packet_out_size(packet), packet_tag(packet));
          fprintf(stderr, ",access_type=LOCAL_ATOMIC");
          break;
        default:
          error();
        }
      break;
    case PACKET_ACK_VALIDATE_PAGE:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_INVALIDATE_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,seq=%d"
              , packet_vm_id(packet), packet_page_id(packet), packet_seq(packet));
      break;
    case PACKET_ACK_INVALIDATE_PAGE:
      fprintf(stderr, "-");
      break;
    case PACKET_REQ_COMMIT_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,offset=%ld,set=%d"
              , packet_vm_id(packet), packet_page_id(packet), packet_page_offset(packet), packet_set_num(packet));
      switch(packet_access_type(packet))
        {
        case ACCESS_REMOTE_WRITE:
          fprintf(stderr, ",size=%ld"
                  , packet_copy_size(packet));
          fprintf(stderr, ",access_type=REMOTE_WRITE");
          break;
        case ACCESS_LOCAL_WRITE:
          fprintf(stderr, ",size=%ld"
                  , packet_copy_size(packet));
          fprintf(stderr, ",access_type=LOCAL_WRITE");
          break;
        case ACCESS_REMOTE_SETSIZE:
          fprintf(stderr, ",size=%ld,slide=%ld"
                  , packet_copy_size(packet), packet_slide_size(packet));
          fprintf(stderr, ",access_type=REMOTE_SETSIZE");
          break;
        case ACCESS_LOCAL_SETSIZE:
          fprintf(stderr, ",size=%ld,slide=%ld"
                  , packet_copy_size(packet), packet_slide_size(packet));
          fprintf(stderr, ",access_type=LOCAL_SETSIZE");
          break;
        case ACCESS_REMOTE_GWRITE:
          fprintf(stderr, ",size=%ld,set=%d"
                  , packet_copy_size(packet), packet_set_num(packet));
          fprintf(stderr, ",access_type=REMOTE_GWRITE");
          break;
        case ACCESS_LOCAL_GWRITE:
          fprintf(stderr, ",size=%ld,set=%d"
                  , packet_copy_size(packet), packet_set_num(packet));
          fprintf(stderr, ",access_type=LOCAL_GWRITE");
          break;
        case ACCESS_REMOTE_ATOMIC:
          fprintf(stderr, ",out_size=%ld,in_size=%ld,tag=%d"
                  , packet_out_size(packet), packet_in_size(packet), packet_tag(packet));
          fprintf(stderr, ",access_type=REMOTE_ATOMIC");
          break;
        case ACCESS_LOCAL_ATOMIC:
          fprintf(stderr, ",out_size=%ld,in_size=%ld,tag=%d"
                  , packet_out_size(packet), packet_in_size(packet), packet_tag(packet));
          fprintf(stderr, ",access_type=LOCAL_ATOMIC");
          break;
        default:
          error();
        }
      break;
    case PACKET_ACK_COMMIT_PAGE:
      fprintf(stderr, "ret=%d,seq=%d"
              , packet_ret_flag(packet), packet_seq(packet));
      break;
    case PACKET_REQ_SWEEP_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld"
              , packet_vm_id(packet), packet_page_id(packet));
      break;
    case PACKET_ACK_SWEEP_PAGE:
      fprintf(stderr, "ret_flag=%d,seq=%d"
              , packet_ret_flag(packet), packet_seq(packet));
      break;
    case PACKET_REQ_DELEGATE_PAGE:
      fprintf(stderr, "vm_id=%d,page_id=%ld,seq=%d,valid_num=%d,slide=%ld"
              , packet_vm_id(packet), packet_page_id(packet), packet_seq(packet), packet_valid_num(packet), packet_slide_size(packet));
      switch(packet_state(packet))
        {
        case STATE_INVALID:
          fprintf(stderr, ",state=INVALID");
          break;
        case STATE_UPVALID:
          fprintf(stderr, ",state=UPVALID");
          break;
        case STATE_DOWNVALID:
          fprintf(stderr, ",state=DOWNVALID");
          break;
        default:
          error();
        }
      fprintf(stderr, ",page=");
      for(i = 0; i < packet->page_payload_size / sizeof(int); i++)
        {
          fprintf(stderr, "%d ", ((int*)packet->page_payload_ptr)[i]);
        }
      break;
    case PACKET_ACK_DELEGATE_PAGE:
      fprintf(stderr, "-");
      break;
    default:
      error();
    }
  
  fprintf(stderr, "\n");
  
  pthread_mutex_unlock(&mutex);
  return;
}

gmemory_t* gmemory_alloc(int64_t max_size)
{
  gmemory_t *gmemory;
  
  gmemory = (gmemory_t*)my_malloc(sizeof(gmemory_t));
  gmemory->exit_flag = FALSE;
  gmemory->total_size = 0;
  gmemory->max_size = max_size;
  pthread_cond_init(&gmemory->cond, NULL);
  pthread_mutex_init(&gmemory->mutex, NULL);
  return gmemory;
}

void gmemory_free(gmemory_t *gmemory)
{
  pthread_mutex_destroy(&gmemory->mutex);
  pthread_cond_destroy(&gmemory->cond);
  my_free(gmemory);
  return;
}

void* gmemory_change(gmemory_t *gmemory, void *buf, int64_t *buf_size, int64_t size)
{
  if(size != *buf_size)
    {
      buf = my_realloc(buf, size);
      
      pthread_mutex_lock(&gmemory->mutex);
      
      gmemory->total_size += size - *buf_size;
      if(gmemory->total_size >= gmemory->max_size)
        {
          pthread_cond_broadcast(&gmemory->cond);
        }
      
      pthread_mutex_unlock(&gmemory->mutex);
      
      *buf_size = size;
    }
  return buf;
}

int32_t gmemory_monitor(gmemory_t *gmemory, int64_t *total_size_ptr, int64_t *max_size_ptr)
{
  int8_t exit_flag, ret_value;
  
  pthread_mutex_lock(&gmemory->mutex);
  
  pthread_cond_wait(&gmemory->cond, &gmemory->mutex);
  *total_size_ptr = gmemory->total_size;
  *max_size_ptr = gmemory->max_size;
  exit_flag = gmemory->exit_flag;
  
  pthread_mutex_unlock(&gmemory->mutex);
  
  ret_value = exit_flag == TRUE ? FALSE : TRUE;
  return ret_value;
}

void gmemory_disable(gmemory_t *gmemory)
{
  pthread_mutex_lock(&gmemory->mutex);
  
  gmemory->exit_flag = TRUE;
  pthread_cond_broadcast(&gmemory->cond);
  
  pthread_mutex_unlock(&gmemory->mutex);
  return;
}

gate_t* gate_alloc(void)
{
  gate_t *gate;
  
  gate = (gate_t*)my_malloc(sizeof(gate_t));
  gate->state = STATE_FORBID;
  gate->count = 0;
  gate->body = NULL;
  gate->context = NULL;
  gate->func_ptr = NULL;
  pthread_mutex_init(&gate->mutex, NULL);
  return gate;
}

void gate_free(gate_t *gate)
{
  pthread_mutex_destroy(&gate->mutex);
  my_free(gate);
  return;
}

void gate_permit(gate_t *gate)
{
  pthread_mutex_lock(&gate->mutex);
  
  gate->state = STATE_PERMIT;
  
  pthread_mutex_unlock(&gate->mutex);
  return;
}

void gate_forbid(gate_t *gate, context_t *context, void (*func_ptr)(context_t *context))
{
  pthread_mutex_lock(&gate->mutex);
  
  gate->state = STATE_FORBID;
  if(gate->count == 0)
    {
      pthread_mutex_unlock(&gate->mutex);
      
      func_ptr(context);
    }
  else
    {
      gate->context = context;
      gate->func_ptr = func_ptr;
      
      pthread_mutex_unlock(&gate->mutex);
    }
  return;
}

int32_t gate_enter(gate_t *gate)
{
  int32_t ret_value;
  
  if(gate == NULL)
    {
      return FALSE;
    }
  
  pthread_mutex_lock(&gate->mutex);
  
  if(gate->state == STATE_PERMIT)
    {
      gate->count++;
      ret_value = TRUE;
    }
  else
    {
      ret_value = FALSE;
    }
  
  pthread_mutex_unlock(&gate->mutex);
  return ret_value;
}

void gate_escape(gate_t *gate)
{
  context_t *context;
  void (*func_ptr)(context_t *context);
  
  pthread_mutex_lock(&gate->mutex);
  
  gate->count--;
  if(gate->state == STATE_FORBID && gate->count == 0)
    {
      context = gate->context;
      func_ptr = gate->func_ptr;
      
      pthread_mutex_unlock(&gate->mutex);
      
      func_ptr(context);
    }
  else
    {
      pthread_mutex_unlock(&gate->mutex);
    }
  return;
}

order_t* order_alloc(void)
{
  order_t *order;
  
  order = (order_t*)my_malloc(sizeof(order_t));
  order->seq = 0;
  order->pending_num = 0;
  order->packet_vector = vector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  return order;
}

void order_free(order_t *order)
{
  vector_free(order->packet_vector);
  my_free(order);
  return;
}

int32_t order_check(order_t *order, packet_t *recv_packet)
{
  packet_t *packet, *tmp_packet;
  int32_t ret_value, i, packet_num;
  
  if(order->seq == packet_seq(recv_packet))
    {
      ret_value = TRUE;
    }
  else
    {
      packet_num = vector_size(order->packet_vector);
      for(i = 0; i < packet_num; i++)
        {
          packet = (packet_t*)vector_at(order->packet_vector, i);
          if(packet == NULL)
            {
              break;
            }
        }
      tmp_packet = packet_alloc();
      packet_copy(tmp_packet, recv_packet);
      vector_assign(order->packet_vector, i, tmp_packet);
      order->pending_num++;
      
      ret_value = FALSE;
    }
  return ret_value;
}

packet_t* order_increment(order_t *order)
{
  packet_t *packet;
  int i, packet_num;
  
  order->seq++;
  
  packet = NULL;
  packet_num = vector_size(order->packet_vector);
  for(i = 0; i < packet_num; i++)
    {
      packet = (packet_t*)vector_at(order->packet_vector, i);
      if(packet != NULL && order->seq == packet_seq(packet))
        {
          vector_assign(order->packet_vector, i, NULL);
          order->pending_num--;
          break;
        }
    }
  if(i == packet_num)
    {
      packet = NULL;
    }
  return packet;
}

load_t* load_alloc(void)
{
  load_t *load;
  
  load = (load_t*)my_malloc(sizeof(load_t));
  load->size = 0;
  pthread_mutex_init(&load->mutex, NULL);
  return load;
}

void load_free(load_t *load)
{
  pthread_mutex_destroy(&load->mutex);
  my_free(load);
  return;
}

void load_increase(load_t *load, int64_t size)
{
  pthread_mutex_lock(&load->mutex);
  
  load->size += size;
  
  pthread_mutex_unlock(&load->mutex);
  return;
}

void load_decrease(load_t *load, int64_t size)
{
  pthread_mutex_lock(&load->mutex);
  
  load->size -= size;
  
  pthread_mutex_unlock(&load->mutex);
  return;
}

int64_t load_size(load_t *load)
{
  return load->size;
}

async_t* async_alloc(void)
{
  async_t *async;
  
  async = (async_t*)my_malloc(sizeof(async_t));
  async->ret = FALSE;
  async->exit_flag = FALSE;
  pthread_cond_init(&async->cond, NULL);
  pthread_mutex_init(&async->mutex, NULL);
  return async;
}

void async_free(async_t *async)
{
  pthread_mutex_destroy(&async->mutex);
  pthread_cond_destroy(&async->cond);
  my_free(async);
  return;
}

void async_finish(async_t *async, int32_t ret)
{
  pthread_mutex_lock(&async->mutex);
  
  async->ret = ret;
  async->exit_flag = TRUE;
  pthread_cond_broadcast(&async->cond);

  pthread_mutex_unlock(&async->mutex);
  return;
}

int32_t async_check(async_t *async, int32_t *ret_ptr)
{
  int32_t ret_value;
  
  pthread_mutex_lock(&async->mutex);
  
  if(async->exit_flag == FALSE)
    {
      ret_value = FALSE;
    }
  else
    {
      ret_value = TRUE;
      *ret_ptr = async->ret;
    }
  
  pthread_mutex_unlock(&async->mutex);
  return ret_value;
}

void async_wait(async_t *async, int32_t *ret_ptr)
{
  pthread_mutex_lock(&async->mutex);
  
  while(async->exit_flag == FALSE)
    {
      pthread_cond_wait(&async->cond, &async->mutex);
    }
  *ret_ptr = async->ret;
  
  pthread_mutex_unlock(&async->mutex);
  return;
}

status_t* status_alloc(void)
{
  status_t *status;
  
  status = (status_t*)my_malloc(sizeof(status_t));
  status->buf = NULL;
  status->async = NULL;
  return status;
}

void status_free(status_t *status)
{
  my_free(status->buf);
  my_free(status);
  return;
}

void status_start(status_t *status)
{
  status->buf = NULL;
  status->async = async_alloc();
  return;
}

void status_finish(status_t *status, int32_t ret)
{
  async_finish(status->async, ret);
  return;
}

int32_t status_check(status_t *status, int32_t *ret_ptr)
{
  int32_t ret_value;
  
  ret_value = async_check(status->async, ret_ptr);
  return ret_value;
}

void status_wait(status_t *status, int32_t *ret_ptr)
{
  async_wait(status->async, ret_ptr);
  async_free(status->async);
  my_free(status->buf);
  return;
}

window_t* window_alloc(int32_t window_size)
{
  window_t *window;
  
  window = (window_t*)my_malloc(sizeof(window_t));
  window->size = window_size;
  window->status_deque = deque_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  pthread_mutex_init(&window->mutex, NULL);
  return window;
}

void window_free(window_t *window)
{
  pthread_mutex_destroy(&window->mutex);
  deque_free(window->status_deque);
  my_free(window);
  return;
}

status_t* window_expand(window_t *window)
{
  status_t *status;
  int32_t ret;
  
  pthread_mutex_lock(&window->mutex);
  
  if(deque_size(window->status_deque) >= window->size)
    {
      status = (status_t*)deque_pop(window->status_deque);
      
      pthread_mutex_unlock(&window->mutex);
      
      status_wait(status, &ret);
      status_free(status);
      
      pthread_mutex_lock(&window->mutex);
    }
  
  status = status_alloc();
  deque_unshift(window->status_deque, status);
  status_start(status);
  
  pthread_mutex_unlock(&window->mutex);
  return status;
}

void window_flush(window_t *window)
{
  status_t *status;
  int32_t ret;
  
  pthread_mutex_lock(&window->mutex);
  
  while(!deque_isempty(window->status_deque))
    {
      status = (status_t*)deque_pop(window->status_deque);
      
      pthread_mutex_unlock(&window->mutex);
      
      status_wait(status, &ret);
      status_free(status);
      
      pthread_mutex_lock(&window->mutex);
    }
  
  pthread_mutex_unlock(&window->mutex);
  return;
}

/* public objects */

dmi_t* dmi_alloc(void)
{
  dmi_t *dmi;
  
  dmi = (dmi_t*)my_malloc(sizeof(dmi_t));
  return dmi;
}

void dmi_free(dmi_t *dmi)
{
  my_free(dmi);
  return;
}

token_t* token_alloc(void)
{
  token_t *token;
  
  token = (token_t*)my_malloc(sizeof(token_t));
  token->dmi_context_deque = deque_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT);
  token->packet_vector = vector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  pthread_mutex_init(&token->mutex, NULL);
  return token;
}

void token_free(token_t *token)
{
  pthread_mutex_destroy(&token->mutex);
  vector_free(token->packet_vector);
  deque_free(token->dmi_context_deque);
  my_free(token);
  return;
}

peer_t* peer_alloc(void)
{
  peer_t *peer;
  
  peer = (peer_t*)my_malloc(sizeof(peer_t));
  return peer;
}

void peer_free(peer_t *peer)
{
  my_free(peer);
  return;
}

thread_t* thread_alloc(void)
{
  thread_t *thread;
  
  thread = (thread_t*)my_malloc(sizeof(thread_t));
  thread->in_buf = NULL;
  pthread_cond_init(&thread->cond, NULL);
  pthread_mutex_init(&thread->mutex, NULL);
  return thread;
}

void thread_free(thread_t *thread)
{
  pthread_mutex_destroy(&thread->mutex);
  pthread_cond_destroy(&thread->cond);
  my_free(thread->in_buf);
  my_free(thread);
  return;
}

vm_t* vm_alloc(void)
{
  vm_t *vm;
  
  vm = (vm_t*)my_malloc(sizeof(vm_t));
  return vm;
}

void vm_free(vm_t *vm)
{
  my_free(vm);
  return;
}

page_t* page_alloc(void)
{
  page_t *page;
  
  page = (page_t*)my_malloc(sizeof(page_t));
  page->account_vector = vector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  page->context_vector = vector_alloc(CONTAINER_DEFAULT, CONTAINER_DEFAULT, NULL);
  page->order = order_alloc();
  pthread_mutex_init(&page->mutex, NULL);
  return page;
}

void page_free(page_t *page)
{
  pthread_mutex_destroy(&page->mutex);
  order_free(page->order);
  vector_free(page->context_vector);
  vector_free(page->account_vector);
  my_free(page);
  return;
}

account_t* account_alloc(void)
{
  account_t *account;
  
  account = (account_t*)my_malloc(sizeof(account_t));
  return account;
}

void account_free(account_t *account)
{
  my_free(account);
  return;
}

pheap_t* pheap_alloc(void)
{
  pheap_t *pheap;
  
  pheap = (pheap_t*)my_malloc(sizeof(pheap_t));
  pheap->mblock_list = list_alloc();
  pheap->mmapped_list = list_alloc();
  return pheap;
}

void pheap_free(pheap_t *pheap)
{
  list_free(pheap->mmapped_list);
  list_free(pheap->mblock_list);
  my_free(pheap);
  return;
}

mblock_t* mblock_alloc(void)
{
  mblock_t *mblock;
  
  mblock = (mblock_t*)my_malloc(sizeof(mblock_t));
  return mblock;
}

void mblock_free(mblock_t *mblock)
{
  my_free(mblock);
  return;
}

mmapped_t* mmapped_alloc(void)
{
  mmapped_t *mmapped;
  
  mmapped = (mmapped_t*)my_malloc(sizeof(mmapped_t));
  return mmapped;
}

void mmapped_free(mmapped_t *mmapped)
{
  my_free(mmapped);
  return;
}

context_t* context_alloc(void)
{
  context_t *context;
  
  context = (context_t*)my_malloc(sizeof(context_t));
  context->buf = NULL;
  pthread_cond_init(&context->cond, NULL);
  pthread_mutex_init(&context->mutex, NULL);
  return context;
}

void context_free(context_t *context)
{
  pthread_mutex_destroy(&context->mutex);
  pthread_cond_destroy(&context->cond);
  my_free(context->buf);
  my_free(context);
  return;
}
